/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.extdoc.rcp.providers.javadoc;

import com.google.common.base.Optional;
import com.google.common.eventbus.EventBus;
import com.google.inject.Inject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocContentAccess2;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLinks;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.recommenders.extdoc.rcp.providers.ExtdocProvider;
import org.eclipse.recommenders.extdoc.rcp.providers.JavaSelectionSubscriber;
import org.eclipse.recommenders.internal.rcp.providers.JavaSelectionUtils;
import org.eclipse.recommenders.rcp.RecommendersPlugin;
import org.eclipse.recommenders.rcp.events.JavaSelectionEvent;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmTypeName;
import org.eclipse.recommenders.utils.rcp.JavaElementResolver;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public final class JavadocProvider
extends ExtdocProvider {
    private final EventBus workspaceBus;
    private final JavaElementResolver resolver;
    private static final String fgStyleSheet = JavadocProvider.loadStyleSheet();

    @Inject
    public JavadocProvider(EventBus workspaceBus, JavaElementResolver resolver) {
        this.workspaceBus = workspaceBus;
        this.resolver = resolver;
    }

    @JavaSelectionSubscriber
    public ExtdocProvider.Status onCompilationUnitSelection(ITypeRoot root, JavaSelectionEvent selection, Composite parent) throws JavaModelException {
        IType type = root.findPrimaryType();
        if (type != null) {
            this.render((IMember)type, parent);
        }
        return ExtdocProvider.Status.OK;
    }

    @JavaSelectionSubscriber
    public ExtdocProvider.Status onTypeSelection(IType type, JavaSelectionEvent selection, Composite parent) throws JavaModelException {
        this.render((IMember)type, parent);
        return ExtdocProvider.Status.OK;
    }

    @JavaSelectionSubscriber
    public ExtdocProvider.Status onMethodSelection(IMethod method, JavaSelectionEvent selection, Composite parent) throws JavaModelException {
        this.render((IMember)method, parent);
        return ExtdocProvider.Status.OK;
    }

    @JavaSelectionSubscriber
    public ExtdocProvider.Status onFieldSelection(IField field, JavaSelectionEvent selection, Composite parent) throws JavaModelException {
        this.render((IMember)field, parent);
        return ExtdocProvider.Status.OK;
    }

    private ExtdocProvider.Status render(IMember element, final Composite parent) throws JavaModelException {
        final String html = this.findJavadoc(element);
        final CountDownLatch latch = new CountDownLatch(1);
        this.runSyncInUiThread(new Runnable(){

            @Override
            public void run() {
                final Browser browser = new Browser(parent, 0);
                final Point maxBrowserSize = this.findParentWithSizeInformation(parent);
                final GridData browserLayoutData = new GridData(maxBrowserSize.x, 0);
                browser.setLayoutData((Object)browserLayoutData);
                browser.setSize(maxBrowserSize.x, 0);
                browser.setText(html);
                browser.addProgressListener((ProgressListener)new ProgressAdapter(){

                    public void completed(ProgressEvent event) {
                        browser.removeProgressListener((ProgressListener)this);
                        browser.getDisplay().timerExec(5, new Runnable(){

                            @Override
                            public void run() {
                                Double result = (Double)browser.evaluate("function getDocHeight() { var D = document; return Math.max( Math.max(D.body.scrollHeight, D.documentElement.scrollHeight), Math.max(D.body.offsetHeight, D.documentElement.offsetHeight),Math.max(D.body.clientHeight, D.documentElement.clientHeight));} return getDocHeight();");
                                if (result == null) {
                                    result = -1.0;
                                }
                                int height = (int)Math.ceil(result);
                                int width = maxBrowserSize.x;
                                Point computeSize = browser.computeSize(width, height);
                                browserLayoutData.widthHint = computeSize.x;
                                browserLayoutData.heightHint = computeSize.y;
                                browser.setSize(computeSize);
                                latch.countDown();
                            }
                        });
                    }
                });
                browser.addLocationListener(JavaElementLinks.createLocationListener((JavaElementLinks.ILinkHandler)new JavaElementLinks.ILinkHandler(){

                    public void handleDeclarationLink(IJavaElement target) {
                        try {
                            JavaUI.openInEditor((IJavaElement)target);
                        }
                        catch (PartInitException e) {
                            JavaPlugin.log((Throwable)e);
                        }
                        catch (JavaModelException e) {
                            JavaPlugin.log((Throwable)e);
                        }
                    }

                    public boolean handleExternalLink(URL url, Display display) {
                        try {
                            if (url.getProtocol().equals("file")) {
                                String path = url.getPath();
                                path = StringUtils.removeStart((String)path, (String)"///");
                                path = StringUtils.removeStart((String)path, (String)"/");
                                String type = "L" + StringUtils.substring((String)path, (int)0, (int)(-".html".length()));
                                VmTypeName typeName = VmTypeName.get((String)type);
                                Optional opt = JavadocProvider.this.resolver.toJdtType((ITypeName)typeName);
                                if (opt.isPresent()) {
                                    JavadocProvider.this.workspaceBus.post((Object)new JavaSelectionEvent((IJavaElement)opt.get(), JavaSelectionEvent.JavaSelectionLocation.METHOD_DECLARATION));
                                }
                            } else {
                                try {
                                    PlatformUI.getWorkbench().getBrowserSupport().createBrowser("recommenders.javadoc").openURL(url);
                                }
                                catch (PartInitException e) {
                                    RecommendersPlugin.logError((Exception)((Object)e), (String)"Error during javadoc selection %s", (Object[])new Object[]{url});
                                }
                            }
                        }
                        catch (Exception e) {
                            RecommendersPlugin.logError((Exception)e, (String)"Error during javadoc selection %s", (Object[])new Object[]{url});
                        }
                        return true;
                    }

                    public void handleInlineJavadocLink(IJavaElement target) {
                        JavaSelectionEvent.JavaSelectionLocation location = JavaSelectionUtils.resolveSelectionLocationFromJavaElement((IJavaElement)target);
                        JavadocProvider.this.workspaceBus.post((Object)new JavaSelectionEvent(target, location));
                    }

                    public void handleJavadocViewLink(IJavaElement target) {
                        this.handleInlineJavadocLink(target);
                    }

                    public void handleTextSet() {
                    }
                }));
            }

            private Point findParentWithSizeInformation(Composite parent2) {
                while (parent2 != null) {
                    Point size = parent2.getSize();
                    if (size.x > 0) {
                        return size;
                    }
                    parent2 = parent2.getParent();
                }
                throw Throws.throwUnreachable();
            }
        });
        try {
            latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {}
        return ExtdocProvider.Status.OK;
    }

    private String findJavadoc(IMember element) throws JavaModelException {
        int max;
        String html = JavadocContentAccess2.getHTMLContent((IMember)element, (boolean)true);
        if (html == null) {
            html = "no javadoc found";
        }
        if (html.substring(0, max = Math.min(100, html.length())).indexOf("<html>") != -1) {
            return html;
        }
        StringBuffer info = new StringBuffer(512 + html.length());
        HTMLPrinter.insertPageProlog((StringBuffer)info, (int)0, (String)fgStyleSheet);
        info.append(html);
        HTMLPrinter.addPageEpilog((StringBuffer)info);
        return info.toString();
    }

    /*
     * Loose catch block
     */
    private static String loadStyleSheet() {
        Bundle bundle = Platform.getBundle((String)JavaPlugin.getPluginId());
        URL styleSheetURL = bundle.getEntry("/JavadocViewStyleSheet.css");
        if (styleSheetURL == null) {
            return null;
        }
        BufferedReader reader = null;
        reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
        StringBuffer buffer = new StringBuffer(1500);
        String line = reader.readLine();
        while (line != null) {
            buffer.append(line);
            buffer.append('\n');
            line = reader.readLine();
        }
        FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.javadocfont")[0];
        String string = HTMLPrinter.convertTopLevelFont((String)buffer.toString(), (FontData)fontData);
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {}
        return string;
        catch (IOException ex) {
            try {
                JavaPlugin.log((Throwable)ex);
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            return null;
        }
    }
}

