/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.extdoc.rcp.preferences;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.recommenders.extdoc.rcp.providers.ExtdocProvider;
import org.eclipse.recommenders.internal.extdoc.rcp.preferences.PreferencesFacade;
import org.eclipse.recommenders.internal.extdoc.rcp.scheduling.Events;

public class ProviderConfigurationPersistenceService {
    private final PreferencesFacade preferences;
    private List<ExtdocProvider> providers;

    @Inject
    public ProviderConfigurationPersistenceService(PreferencesFacade preferences) {
        this.preferences = preferences;
    }

    public void initializeProviderConfiguration(List<ExtdocProvider> providers) {
        this.providers = providers;
        this.loadNamesAndReorderList();
        this.loadEnablement();
    }

    private void loadNamesAndReorderList() {
        String[] orderedProviderNames = this.preferences.loadOrderedProviderNames();
        int i = orderedProviderNames.length - 1;
        while (i >= 0) {
            this.moveToTopIfNameExists(orderedProviderNames[i]);
            --i;
        }
    }

    private void moveToTopIfNameExists(String nameToMove) {
        for (ExtdocProvider p : this.providers) {
            if (!nameToMove.equals(p.getDescription().getName())) continue;
            this.providers.remove(p);
            this.providers.add(0, p);
            return;
        }
    }

    private void loadEnablement() {
        for (ExtdocProvider p : this.providers) {
            boolean isEnabledInPrefs = this.preferences.isProviderEnabled(p);
            p.setEnabled(isEnabledInPrefs);
        }
    }

    @Subscribe
    public void onEvent(Events.ProviderOrderChangedEvent e) {
        this.preferences.storeOrderedProviders(this.providers);
    }

    @Subscribe
    public void onEvent(Events.ProviderActivationEvent e) {
        this.preferences.storeProviderEnablement(this.providers);
    }

    @Subscribe
    public void onEvent(Events.ProviderDeactivationEvent e) {
        this.preferences.storeProviderEnablement(this.providers);
    }
}

