/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SplitFeedbackOverlay {
    final Display display = Display.getCurrent();
    private Shell feedbackShell;
    private int curSide = 0;
    private float ratio;
    private List<Rectangle> rects = new ArrayList<Rectangle>();
    private Rectangle outerRect;

    public SplitFeedbackOverlay(Shell dragShell, Rectangle rect, int side, float pct, boolean enclosed, boolean modified) {
        this.outerRect = rect;
        this.curSide = side;
        this.ratio = pct;
        this.feedbackShell = new Shell(dragShell, 8);
        this.feedbackShell.setBounds(dragShell.getBounds());
        this.setFeedback(enclosed, modified);
        this.defineRegion();
        this.feedbackShell.setVisible(true);
    }

    public void dispose() {
        if (this.feedbackShell != null && !this.feedbackShell.isDisposed()) {
            this.feedbackShell.dispose();
        }
    }

    private void showRects(boolean enclosed) {
        if (this.curSide == 0) {
            return;
        }
        Rectangle ca = new Rectangle(this.outerRect.x, this.outerRect.y, this.outerRect.width, this.outerRect.height);
        this.rects.clear();
        if (enclosed) {
            this.addRect(ca);
            ca.x += 4;
            ca.y += 4;
            ca.width -= 8;
            ca.height -= 8;
        }
        int pctWidth = (int)((float)ca.width * this.ratio);
        int pctHeight = (int)((float)ca.height * this.ratio);
        Rectangle r1 = null;
        Rectangle r2 = null;
        if (this.curSide == 16384) {
            r1 = new Rectangle(ca.x, ca.y, pctWidth, ca.height);
            r2 = new Rectangle(ca.x + r1.width + 2, ca.y, ca.width - (pctWidth + 2), ca.height);
        } else if (this.curSide == 131072) {
            r1 = new Rectangle(ca.x, ca.y, ca.width - pctWidth, ca.height);
            r2 = new Rectangle(ca.x + r1.width + 2, ca.y, pctWidth - 2, ca.height);
        } else if (this.curSide == 128) {
            r1 = new Rectangle(ca.x, ca.y, ca.width, pctHeight);
            r2 = new Rectangle(ca.x, ca.y + pctHeight + 2, ca.width, ca.height - (pctHeight + 2));
        } else if (this.curSide == 1024) {
            r1 = new Rectangle(ca.x, ca.y, ca.width, ca.height - pctHeight);
            r2 = new Rectangle(ca.x, ca.y + r1.height + 2, ca.width, pctHeight - 2);
        }
        this.addRect(r1);
        this.addRect(r2);
    }

    private void defineRegion() {
        Region rgn = new Region();
        for (Rectangle r : this.rects) {
            rgn.add(r);
            rgn.subtract(r.x + 2, r.y + 2, r.width - 4, r.height - 4);
        }
        if (this.feedbackShell.getRegion() != null && !this.feedbackShell.getRegion().isDisposed()) {
            this.feedbackShell.getRegion().dispose();
        }
        this.feedbackShell.setRegion(rgn);
        this.feedbackShell.redraw();
        this.display.update();
    }

    private void addRect(Rectangle rect) {
        rect = this.display.map(null, (Control)this.feedbackShell, rect);
        this.rects.add(rect);
    }

    public void setFeedback(boolean enclosed, boolean modified) {
        if (!modified) {
            this.feedbackShell.setBackground(this.display.getSystemColor(5));
        } else {
            this.feedbackShell.setBackground(this.display.getSystemColor(8));
        }
        this.showRects(enclosed);
        this.defineRegion();
        this.feedbackShell.update();
    }
}

