/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.extdoc;

import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.names.IMethodName;

public final class MethodPattern {
    private int numberOfObservations;
    private Map<IMethodName, Double> methods;

    public static MethodPattern create(int numberOfObservations, Map<IMethodName, Double> methods) {
        MethodPattern res = new MethodPattern();
        res.numberOfObservations = numberOfObservations;
        res.methods = methods;
        res.validate();
        return res;
    }

    public int getNumberOfObservations() {
        return this.numberOfObservations;
    }

    public Map<IMethodName, Double> getMethods() {
        return this.methods;
    }

    public void validate() {
        Checks.ensureIsTrue((this.numberOfObservations > 0 ? 1 : 0) != 0);
        Checks.ensureIsTrue((!this.methods.isEmpty() ? 1 : 0) != 0);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

