/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jmdns.container;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.events.ContainerConnectedEvent;
import org.eclipse.ecf.core.events.ContainerConnectingEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectingEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.IIDFactory;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.ECFRuntimeException;
import org.eclipse.ecf.core.util.StringUtils;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.discovery.AbstractDiscoveryContainerAdapter;
import org.eclipse.ecf.discovery.DiscoveryContainerConfig;
import org.eclipse.ecf.discovery.IServiceEvent;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.IServiceTypeEvent;
import org.eclipse.ecf.discovery.ServiceContainerEvent;
import org.eclipse.ecf.discovery.ServiceProperties;
import org.eclipse.ecf.discovery.ServiceTypeContainerEvent;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.identity.ServiceIDFactory;
import org.eclipse.ecf.discovery.service.IDiscoveryService;
import org.eclipse.ecf.internal.provider.jmdns.JMDNSDebugOptions;
import org.eclipse.ecf.internal.provider.jmdns.JMDNSPlugin;
import org.eclipse.ecf.internal.provider.jmdns.SimpleFIFOQueue;

public class JMDNSDiscoveryContainer
extends AbstractDiscoveryContainerAdapter
implements IDiscoveryService,
ServiceListener,
ServiceTypeListener {
    private static final String SCHEME_PROPERTY = "jmdns.ptcl";
    private static final String URI_PATH_PROPERTY = "path";
    private static final String NAMING_AUTHORITY_PROPERTY = "jmdns.namingauthority";
    public static final int DEFAULT_REQUEST_TIMEOUT = 3000;
    private static int instanceCount = 0;
    JmDNS jmdns;
    private ID targetID;
    List serviceTypes;
    final Map services;
    boolean disposed;
    final Object lock;
    SimpleFIFOQueue queue;
    Thread notificationThread;
    static /* synthetic */ Class class$0;

    public JMDNSDiscoveryContainer() {
        IIDFactory iIDFactory = IDFactory.getDefault();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.provider.jmdns.container.JMDNSDiscoveryContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super("ecf.namespace.jmdns", new DiscoveryContainerConfig(iIDFactory.createStringID(String.valueOf(clazz.getName()) + ";" + instanceCount++)));
        this.jmdns = null;
        this.targetID = null;
        this.serviceTypes = null;
        this.services = Collections.synchronizedMap(new HashMap());
        this.disposed = false;
        this.lock = new Object();
        this.queue = null;
        this.notificationThread = null;
        this.serviceTypes = new ArrayList();
    }

    public ID getConnectedID() {
        return this.targetID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.lock;
        synchronized (object) {
            super.dispose();
            this.disposed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(ID targetID1, IConnectContext joinContext) throws ContainerConnectException {
        Object object = this.lock;
        synchronized (object) {
            if (this.disposed) {
                throw new ContainerConnectException("Container has been disposed");
            }
            if (this.targetID != null) {
                throw new ContainerConnectException("Already connected");
            }
            this.targetID = targetID1 == null ? this.getConfig().getID() : targetID1;
            this.fireContainerEvent((IContainerEvent)new ContainerConnectingEvent(this.getID(), this.targetID, (Object)joinContext));
            this.initializeQueue();
            try {
                this.jmdns = JmDNS.create();
                this.jmdns.addServiceTypeListener(this);
            }
            catch (IOException e) {
                Trace.catching((String)"org.eclipse.ecf.provider.jmdns", (String)JMDNSDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"connect", (Throwable)e);
                if (this.jmdns != null) {
                    this.jmdns.close();
                    this.jmdns = null;
                }
                throw new ContainerConnectException("Cannot create JmDNS instance", (Throwable)e);
            }
            this.fireContainerEvent((IContainerEvent)new ContainerConnectedEvent(this.getID(), this.targetID));
        }
    }

    private void initializeQueue() {
        this.queue = new SimpleFIFOQueue();
        this.notificationThread = new Thread(new Runnable(){

            public void run() {
                while (!JMDNSDiscoveryContainer.this.disposed || JMDNSDiscoveryContainer.this.queue.isStopped()) {
                    if (Thread.currentThread().isInterrupted()) break;
                    Runnable runnable = (Runnable)JMDNSDiscoveryContainer.this.queue.dequeue();
                    if (Thread.currentThread().isInterrupted() || runnable == null) break;
                    try {
                        runnable.run();
                    }
                    catch (Throwable t) {
                        JMDNSPlugin plugin = JMDNSPlugin.getDefault();
                        if (plugin == null) continue;
                        plugin.logException("handleRuntimeException", t);
                    }
                }
            }
        }, "JMDNS Discovery Thread");
        this.notificationThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            if (this.getConnectedID() == null || this.disposed) {
                return;
            }
            ID connectedID = this.getConnectedID();
            this.fireContainerEvent((IContainerEvent)new ContainerDisconnectingEvent(this.getID(), connectedID));
            this.queue.close();
            this.notificationThread.interrupt();
            this.notificationThread = null;
            this.targetID = null;
            this.serviceTypes.clear();
            this.jmdns.close();
            this.jmdns = null;
            this.fireContainerEvent((IContainerEvent)new ContainerDisconnectedEvent(this.getID(), connectedID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceInfo getServiceInfo(IServiceID service) {
        Assert.isNotNull((Object)service);
        Object object = this.lock;
        synchronized (object) {
            try {
                ServiceInfo[] serviceInfos = this.jmdns.list(service.getServiceTypeID().getInternal());
                int i = 0;
                while (i < serviceInfos.length) {
                    ServiceInfo serviceInfo = serviceInfos[i];
                    IServiceInfo iServiceInfo = this.createIServiceInfoFromServiceInfo(serviceInfo);
                    Assert.isNotNull((Object)iServiceInfo);
                    Assert.isNotNull((Object)iServiceInfo.getServiceID());
                    if (iServiceInfo.getServiceID().equals((Object)service)) {
                        return iServiceInfo;
                    }
                    ++i;
                }
                return null;
            }
            catch (Exception e) {
                Trace.catching((String)"org.eclipse.ecf.provider.jmdns", (String)JMDNSDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"getServiceInfo", (Throwable)e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceInfo[] getServices() {
        Object object = this.lock;
        synchronized (object) {
            IServiceTypeID[] serviceTypeArray = this.getServiceTypes();
            ArrayList<IServiceInfo> results = new ArrayList<IServiceInfo>();
            int i = 0;
            while (i < serviceTypeArray.length) {
                IServiceTypeID stid = serviceTypeArray[i];
                if (stid != null) {
                    results.addAll(Arrays.asList(this.getServices(stid)));
                }
                ++i;
            }
            return results.toArray(new IServiceInfo[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceInfo[] getServices(IServiceTypeID type) {
        Assert.isNotNull((Object)type);
        ArrayList<IServiceInfo> serviceInfos = new ArrayList<IServiceInfo>();
        Object object = this.lock;
        synchronized (object) {
            Iterator itr = this.serviceTypes.iterator();
            while (itr.hasNext()) {
                IServiceTypeID serviceType = (IServiceTypeID)itr.next();
                if (!Arrays.equals(serviceType.getServices(), type.getServices()) || !Arrays.equals(serviceType.getProtocols(), type.getProtocols()) || !Arrays.equals(serviceType.getScopes(), type.getScopes())) continue;
                ServiceInfo[] infos = this.jmdns.list(type.getInternal());
                int i = 0;
                while (i < infos.length) {
                    try {
                        IServiceInfo si;
                        if (infos[i] != null && (si = this.createIServiceInfoFromServiceInfo(infos[i])) != null) {
                            serviceInfos.add(si);
                        }
                    }
                    catch (Exception e) {
                        Trace.catching((String)"org.eclipse.ecf.provider.jmdns", (String)JMDNSDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"getServices", (Throwable)e);
                    }
                    ++i;
                }
            }
            return serviceInfos.toArray(new IServiceInfo[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceTypeID[] getServiceTypes() {
        Object object = this.lock;
        synchronized (object) {
            return this.serviceTypes.toArray(new IServiceTypeID[0]);
        }
    }

    public void registerService(IServiceInfo serviceInfo) {
        Assert.isNotNull((Object)serviceInfo);
        ServiceInfo svcInfo = this.createServiceInfoFromIServiceInfo(serviceInfo);
        this.checkServiceInfo(svcInfo);
        try {
            this.jmdns.registerService(svcInfo);
        }
        catch (IOException e) {
            throw new ECFRuntimeException("Exception registering service", (Throwable)e);
        }
    }

    public void unregisterService(IServiceInfo serviceInfo) {
        Assert.isNotNull((Object)serviceInfo);
        ServiceInfo si = this.createServiceInfoFromIServiceInfo(serviceInfo);
        this.jmdns.unregisterService(si);
    }

    public void unregisterAllServices() {
        this.jmdns.unregisterAllServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceInfo[] purgeCache() {
        Object object = this.lock;
        synchronized (object) {
            this.serviceTypes.clear();
        }
        return super.purgeCache();
    }

    private void runInThread(Runnable runnable) {
        this.queue.enqueue(runnable);
    }

    public void serviceTypeAdded(ServiceEvent arg0) {
        Trace.trace((String)"org.eclipse.ecf.provider.jmdns", (String)("serviceTypeAdded(" + arg0.getType() + ")"));
        arg0.getDNS().addServiceListener(arg0.getType(), this);
    }

    void fireTypeDiscovered(IServiceTypeID serviceType) {
        this.fireServiceTypeDiscovered((IServiceTypeEvent)new ServiceTypeContainerEvent(serviceType, this.getID()));
    }

    public void serviceAdded(final ServiceEvent arg0) {
        Trace.trace((String)"org.eclipse.ecf.provider.jmdns", (String)("serviceAdded(" + arg0.getName() + ")"));
        this.runInThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String serviceType = arg0.getType();
                String serviceName = arg0.getName();
                IServiceInfo aServiceInfo = null;
                Object object = JMDNSDiscoveryContainer.this.lock;
                synchronized (object) {
                    if (JMDNSDiscoveryContainer.this.getConnectedID() == null || JMDNSDiscoveryContainer.this.disposed) {
                        return;
                    }
                    try {
                        ServiceInfo info = arg0.getDNS().getServiceInfo(serviceType, serviceName);
                        aServiceInfo = JMDNSDiscoveryContainer.this.createIServiceInfoFromServiceInfo(info);
                        JMDNSDiscoveryContainer.this.services.put(String.valueOf(serviceType) + serviceName, aServiceInfo);
                        JMDNSDiscoveryContainer.this.serviceTypes.add(aServiceInfo.getServiceID().getServiceTypeID());
                    }
                    catch (Exception e) {
                        Trace.trace((String)"org.eclipse.ecf.provider.jmdns", (String)("Failed to resolve in serviceAdded(" + arg0.getName() + ")"));
                        return;
                    }
                }
                JMDNSDiscoveryContainer.this.fireTypeDiscovered(aServiceInfo.getServiceID().getServiceTypeID());
                JMDNSDiscoveryContainer.this.fireDiscovered(aServiceInfo);
            }
        });
    }

    public void serviceRemoved(final ServiceEvent arg0) {
        Trace.trace((String)"org.eclipse.ecf.provider.jmdns", (String)("serviceRemoved(" + arg0.getName() + ")"));
        this.runInThread(new Runnable(){

            public void run() {
                if (JMDNSDiscoveryContainer.this.getConnectedID() == null || JMDNSDiscoveryContainer.this.disposed) {
                    return;
                }
                String serviceType = arg0.getType();
                String serviceName = arg0.getName();
                IServiceInfo aServiceInfo = (IServiceInfo)JMDNSDiscoveryContainer.this.services.remove(String.valueOf(serviceType) + serviceName);
                if (aServiceInfo == null) {
                    Trace.trace((String)"org.eclipse.ecf.provider.jmdns", (String)("Failed to resolve in serviceRemoved(" + arg0.getName() + ")"));
                    return;
                }
                JMDNSDiscoveryContainer.this.fireUndiscovered(aServiceInfo);
            }
        });
    }

    void fireUndiscovered(IServiceInfo serviceInfo) {
        this.fireServiceUndiscovered((IServiceEvent)new ServiceContainerEvent(serviceInfo, this.getID()));
    }

    public void serviceResolved(ServiceEvent arg0) {
        Trace.trace((String)"org.eclipse.ecf.provider.jmdns", (String)("serviceResolved(" + arg0.getName() + ")"));
    }

    void fireDiscovered(IServiceInfo serviceInfo) {
        this.fireServiceDiscovered((IServiceEvent)new ServiceContainerEvent(serviceInfo, this.getID()));
    }

    private void checkServiceInfo(ServiceInfo serviceInfo) {
        String serviceName = serviceInfo.getName();
        if (serviceName == null) {
            throw new ECFRuntimeException("Service name cannot be null");
        }
    }

    IServiceInfo createIServiceInfoFromServiceInfo(ServiceInfo serviceInfo) throws Exception {
        Assert.isNotNull((Object)serviceInfo);
        int priority = serviceInfo.getPriority();
        int weight = serviceInfo.getWeight();
        Properties props = new Properties();
        String uriProtocol = null;
        String uriPath = null;
        String namingAuthority = "iana";
        Enumeration e = serviceInfo.getPropertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (SCHEME_PROPERTY.equals(key)) {
                uriProtocol = serviceInfo.getPropertyString(key);
                continue;
            }
            if (NAMING_AUTHORITY_PROPERTY.equals(key)) {
                namingAuthority = serviceInfo.getPropertyString(key);
                continue;
            }
            if (URI_PATH_PROPERTY.equals(key)) {
                uriPath = serviceInfo.getPropertyString(key);
                continue;
            }
            byte[] bytes = serviceInfo.getPropertyBytes(key);
            try {
                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
                Object object = in.readObject();
                in.close();
                props.put(key, object);
            }
            catch (StreamCorruptedException ioe) {
                props.put(key, serviceInfo.getPropertyString(key));
            }
            catch (EOFException eofe) {
                props.put(key, serviceInfo.getPropertyString(key));
            }
        }
        String proto = serviceInfo.getProtocol();
        String domain = serviceInfo.getDomain();
        String[] scopes = new String[]{domain};
        String authority = String.valueOf(serviceInfo.getHostAddress()) + ":" + serviceInfo.getPort();
        URI uri = new URI(uriProtocol == null ? proto : uriProtocol, authority, uriPath, null, null);
        String st = serviceInfo.getType();
        int end = st.indexOf(proto);
        String[] types = StringUtils.split((String)st.substring(1, end), (String)"._");
        IServiceTypeID sID = ServiceIDFactory.getDefault().createServiceTypeID(this.getServicesNamespace(), types, scopes, new String[]{proto}, namingAuthority);
        String name = serviceInfo.getName();
        return new org.eclipse.ecf.discovery.ServiceInfo(uri, name, sID, priority, weight, (IServiceProperties)new ServiceProperties(props));
    }

    private ServiceInfo createServiceInfoFromIServiceInfo(IServiceInfo serviceInfo) {
        URI location;
        if (serviceInfo == null) {
            return null;
        }
        IServiceID sID = serviceInfo.getServiceID();
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        IServiceProperties svcProps = serviceInfo.getServiceProperties();
        if (svcProps != null) {
            Enumeration e = svcProps.getPropertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object val = svcProps.getProperty(key);
                if (val instanceof String) {
                    props.put(key, val);
                    continue;
                }
                if (val instanceof Serializable) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    try {
                        ObjectOutputStream out = new ObjectOutputStream(bos);
                        out.writeObject(val);
                        out.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    byte[] buf = bos.toByteArray();
                    props.put(key, buf);
                    continue;
                }
                if (val == null) continue;
                props.put(key, val.toString());
            }
        }
        if ((location = serviceInfo.getServiceID().getLocation()) != null) {
            props.put(SCHEME_PROPERTY, location.getScheme());
            props.put(URI_PATH_PROPERTY, location.getPath());
        }
        props.put(NAMING_AUTHORITY_PROPERTY, serviceInfo.getServiceID().getServiceTypeID().getNamingAuthority());
        ServiceInfo si = ServiceInfo.create(sID.getServiceTypeID().getInternal(), serviceInfo.getServiceName(), location.getPort(), serviceInfo.getWeight(), serviceInfo.getPriority(), props);
        return si;
    }

    public String getContainerName() {
        return "ecf.discovery.jmdns";
    }
}

