/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.compare.patch.WorkspacePatcherUI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Diff;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.DiffListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.connection.CVSCommunicationException;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.SingleCommandOperation;
import org.eclipse.ui.IWorkbenchPart;

public abstract class DiffOperation
extends SingleCommandOperation {
    private static final int UNIFIED_FORMAT = 0;
    private static final int CONTEXT_FORMAT = 1;
    private static final int STANDARD_FORMAT = 2;
    protected boolean isMultiPatch;
    protected boolean includeFullPathInformation;
    protected PrintStream stream;
    protected IPath patchRoot;
    protected boolean patchHasContents;
    protected boolean patchHasNewFiles;
    private Object destination = null;
    private static Comparator COMPARATOR = new Comparator(){

        private int compare(IResource r1, IResource r2) {
            return r1.getFullPath().toString().compareTo(r2.getFullPath().toString());
        }

        public int compare(Object o1, Object o2) {
            IResource r1 = null;
            IResource r2 = null;
            r1 = o1 instanceof ICVSResource ? ((ICVSResource)o1).getIResource() : (IResource)o1;
            r2 = o2 instanceof ICVSResource ? ((ICVSResource)o2).getIResource() : (IResource)o2;
            return this.compare(r1, r2);
        }
    };

    public DiffOperation(IWorkbenchPart part, ResourceMapping[] mappings, Command.LocalOption[] options, boolean isMultiPatch, boolean includeFullPathInformation, IPath patchRoot, Object destination) {
        super(part, mappings, options);
        this.isMultiPatch = isMultiPatch;
        this.includeFullPathInformation = includeFullPathInformation;
        this.patchRoot = patchRoot;
        this.patchHasContents = false;
        this.patchHasNewFiles = false;
        this.destination = destination;
    }

    protected boolean shouldRun() {
        if (!super.shouldRun()) {
            return false;
        }
        Job[] jobs = Job.getJobManager().find(this.destination);
        if (jobs.length != 0) {
            MessageDialog question = new MessageDialog(this.getShell(), CVSUIMessages.DiffOperation_CreatePatchConflictTitle, null, NLS.bind((String)CVSUIMessages.DiffOperation_CreatePatchConflictMessage, (Object)this.destination.toString()), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
            if (question.open() == 0) {
                Job.getJobManager().cancel(this.destination);
            } else {
                return false;
            }
        }
        return true;
    }

    public void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        try {
            this.stream = new CustomizableEOLPrintStream(this.openStream());
            if (this.isMultiPatch) {
                this.stream.println(WorkspacePatcherUI.getWorkspacePatchHeader());
            }
            super.execute(monitor);
        }
        finally {
            if (this.stream != null) {
                this.stream.close();
            }
        }
    }

    protected abstract PrintStream openStream() throws CVSException;

    protected void execute(CVSTeamProvider provider, IResource[] resources, boolean recurse, IProgressMonitor monitor) throws CVSException, InterruptedException {
        IProject project;
        final HashSet newFiles = new HashSet();
        final HashSet existingFiles = new HashSet();
        monitor.beginTask(null, 100);
        final IProgressMonitor subMonitor = Policy.subMonitorFor(monitor, 10);
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
            cvsResource.accept(new ICVSResourceVisitor(){

                public void visitFile(ICVSFile file) throws CVSException {
                    if (!file.isIgnored()) {
                        if (!file.isManaged() || file.getSyncInfo().isAdded()) {
                            if (file.exists()) {
                                newFiles.add(file);
                            }
                        } else if (file.isModified(subMonitor)) {
                            existingFiles.add(file.getIResource());
                        }
                    }
                }

                public void visitFolder(ICVSFolder folder) throws CVSException {
                    if (!folder.exists() || folder.isIgnored()) {
                        return;
                    }
                    folder.acceptChildren((ICVSResourceVisitor)this);
                }
            }, recurse);
            ++i;
        }
        TreeSet allFiles = new TreeSet(COMPARATOR);
        allFiles.addAll(existingFiles);
        allFiles.addAll(newFiles);
        subMonitor.done();
        int format = 2;
        Command.LocalOption[] localoptions = this.getLocalOptions(recurse);
        int i2 = 0;
        while (i2 < localoptions.length) {
            Command.LocalOption option = localoptions[i2];
            if (option.equals((Object)Diff.UNIFIED_FORMAT) || this.isMultiPatch) {
                format = 0;
            } else if (option.equals((Object)Diff.CONTEXT_FORMAT)) {
                format = 1;
            }
            ++i2;
        }
        boolean haveAddedProjectHeader = false;
        if (!existingFiles.isEmpty() && this.isMultiPatch && !haveAddedProjectHeader) {
            haveAddedProjectHeader = true;
            project = resources[0].getProject();
            this.stream.println(WorkspacePatcherUI.getWorkspacePatchProjectHeader((IProject)project));
        }
        if (!newFiles.isEmpty() && Diff.INCLUDE_NEWFILES.isElementOf((Command.Option[])localoptions)) {
            this.patchHasNewFiles = true;
            if (this.isMultiPatch && !haveAddedProjectHeader) {
                haveAddedProjectHeader = true;
                project = resources[0].getProject();
                this.stream.println(WorkspacePatcherUI.getWorkspacePatchProjectHeader((IProject)project));
            }
        }
        ArrayList existingFilesSubList = new ArrayList();
        Iterator iter = allFiles.iterator();
        while (iter.hasNext()) {
            Object file = iter.next();
            if (existingFiles.contains(file)) {
                existingFilesSubList.add(file);
                continue;
            }
            if (!newFiles.contains(file)) continue;
            this.addExistingFilesSubListToDiff(provider, existingFilesSubList, recurse, monitor, existingFiles.size());
            ICVSFile cvsFile = (ICVSFile)file;
            this.addFileToDiff(this.getNewFileRoot(cvsFile), cvsFile, this.stream, format);
        }
        this.addExistingFilesSubListToDiff(provider, existingFilesSubList, recurse, monitor, existingFiles.size());
        monitor.done();
    }

    private void addExistingFilesSubListToDiff(CVSTeamProvider provider, Collection subList, boolean recurse, IProgressMonitor monitor, int existingFilesTotal) throws InterruptedException {
        if (!subList.isEmpty()) {
            int ticks = 90 * subList.size() / existingFilesTotal;
            try {
                super.execute(provider, subList.toArray(new IResource[subList.size()]), recurse, Policy.subMonitorFor(monitor, ticks));
            }
            catch (CVSCommunicationException ex) {
                CVSUIPlugin.openError(this.getShell(), null, null, ex, 9);
            }
            catch (CVSException ex) {
                this.handleCVSException(ex);
            }
            subList.clear();
        }
    }

    private void handleCVSException(CVSException ex) {
        IStatus status = ex.getStatus();
        ArrayList<IStatus> toShow = new ArrayList<IStatus>();
        IStatus[] children = status.getChildren();
        boolean may = true;
        int i = 0;
        while (i < children.length) {
            if (children[i].getCode() == -31 || children[i].getCode() == -23 || children[i].getCode() == -14) {
                toShow.add(children[i]);
                if (children[i].getCode() == -31) {
                    may = false;
                }
            }
            ++i;
        }
        if (toShow.size() > 0) {
            String msg = may ? CVSUIMessages.DiffOperation_ThePatchMayNotContainAllTheChanges : CVSUIMessages.DiffOperation_ThePatchDoesNotContainAllTheChanges;
            status = new MultiStatus("org.eclipse.team.cvs.core", -10, toShow.toArray(new IStatus[0]), CVSUIMessages.DiffOperation_ErrorsOccurredWhileCreatingThePatch, null);
            CVSUIPlugin.openError(this.getShell(), this.getTaskName(), msg, status, 9);
        }
    }

    private ICVSFolder getNewFileRoot(ICVSFile cvsFile) {
        ICVSFolder patchRootFolder = this.getPatchRootFolder();
        if (patchRootFolder != null) {
            return patchRootFolder;
        }
        return CVSWorkspaceRoot.getCVSFolderFor((IContainer)cvsFile.getIResource().getProject());
    }

    protected IStatus executeCommand(Session session, CVSTeamProvider provider, ICVSResource[] resources, boolean recurse, IProgressMonitor monitor) throws CVSException, InterruptedException {
        DiffListener diffListener = new DiffListener(this.stream);
        IStatus status = Command.DIFF.execute(session, Command.NO_GLOBAL_OPTIONS, this.getLocalOptions(recurse), resources, (ICommandOutputListener)diffListener, monitor);
        if (!this.patchHasContents) {
            this.patchHasContents = diffListener.wroteToStream();
        }
        return status;
    }

    protected String getTaskName(CVSTeamProvider provider) {
        return NLS.bind((String)CVSUIMessages.DiffOperation_0, (Object[])new String[]{provider.getProject().getName()});
    }

    protected String getTaskName() {
        return CVSUIMessages.DiffOperation_1;
    }

    Map getProviderTraversalMapping(IProgressMonitor monitor) throws CoreException {
        Map providerTraversal = super.getProviderTraversalMapping(monitor);
        TreeMap result = new TreeMap(new Comparator(){

            public int compare(Object o1, Object o2) {
                CVSTeamProvider p1 = (CVSTeamProvider)o1;
                CVSTeamProvider p2 = (CVSTeamProvider)o2;
                return COMPARATOR.compare(p1.getProject(), p2.getProject());
            }
        });
        result.putAll(providerTraversal);
        return result;
    }

    private void addFileToDiff(ICVSFolder patchRoot, ICVSFile file, PrintStream printStream, int format) throws CVSException {
        String nullFilePrefix = "";
        String newFilePrefix = "";
        String positionInfo = "";
        String linePrefix = "";
        String pathString = "";
        pathString = file.getRelativePath(patchRoot);
        int lines = 0;
        BufferedReader fileReader = new BufferedReader(new InputStreamReader(file.getContents()));
        try {
            try {
                while (fileReader.readLine() != null) {
                    ++lines;
                }
            }
            catch (IOException e) {
                throw CVSException.wrapException((IResource)file.getIResource(), (String)NLS.bind((String)CVSUIMessages.DiffOperation_ErrorAddingFileToDiff, (Object[])new String[]{pathString}), (IOException)e);
            }
        }
        catch (Throwable throwable) {
            try {
                fileReader.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fileReader.close();
        }
        catch (IOException iOException) {}
        if (lines == 0) {
            return;
        }
        switch (format) {
            case 0: {
                nullFilePrefix = "--- ";
                newFilePrefix = "+++ ";
                positionInfo = "@@ -0,0 +1," + lines + " @@";
                linePrefix = "+";
                break;
            }
            case 1: {
                nullFilePrefix = "*** ";
                newFilePrefix = "--- ";
                positionInfo = "--- 1," + lines + " ----";
                linePrefix = "+ ";
                break;
            }
            default: {
                positionInfo = "0a1," + lines;
                linePrefix = "> ";
            }
        }
        fileReader = new BufferedReader(new InputStreamReader(file.getContents()));
        try {
            try {
                printStream.println("Index: " + pathString);
                printStream.println("===================================================================");
                printStream.println("RCS file: " + pathString);
                printStream.println("diff -N " + pathString);
                if (format != 2) {
                    printStream.println(String.valueOf(nullFilePrefix) + "/dev/null\t1 Jan 1970 00:00:00 -0000");
                    printStream.println(String.valueOf(newFilePrefix) + pathString + "\t1 Jan 1970 00:00:00 -0000");
                }
                if (format == 1) {
                    printStream.println("***************");
                    printStream.println("*** 0 ****");
                }
                printStream.println(positionInfo);
                int i = 0;
                while (i < lines - 1) {
                    printStream.print(linePrefix);
                    printStream.println(fileReader.readLine());
                    ++i;
                }
                printStream.print(linePrefix);
                this.readLastLine(fileReader, printStream);
            }
            catch (IOException e) {
                throw CVSException.wrapException((IResource)file.getIResource(), (String)NLS.bind((String)CVSUIMessages.DiffOperation_ErrorAddingFileToDiff, (Object[])new String[]{pathString}), (IOException)e);
            }
        }
        catch (Throwable throwable) {
            try {
                fileReader.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fileReader.close();
        }
        catch (IOException iOException) {}
    }

    private void readLastLine(BufferedReader reader, PrintStream printStream) throws IOException {
        boolean sawCRorLF = false;
        boolean sawEOF = false;
        boolean ignoreSingleCR = false;
        while (!sawEOF) {
            int c = reader.read();
            if (c == -1) {
                sawEOF = true;
                break;
            }
            printStream.print((char)c);
            if (c == 10) {
                sawCRorLF = true;
                break;
            }
            if (c != 13) continue;
            sawCRorLF = true;
            c = reader.read();
            if (c == -1) {
                sawEOF = true;
                break;
            }
            if (c != 10) {
                if (!ignoreSingleCR) break;
                sawCRorLF = false;
                printStream.print((char)c);
                continue;
            }
            printStream.print((char)c);
            break;
        }
        if (!sawCRorLF) {
            printStream.println();
            printStream.println("\\ No newline at end of file");
        }
    }

    public void setStream(PrintStream stream) {
        this.stream = new CustomizableEOLPrintStream(stream);
    }

    protected void reportEmptyDiff() {
        CVSUIPlugin.openDialog(this.getShell(), new CVSUIPlugin.IOpenableInShell(){

            public void open(Shell shell) {
                MessageDialog.openInformation((Shell)shell, (String)CVSUIMessages.GenerateCVSDiff_noDiffsFoundTitle, (String)CVSUIMessages.GenerateCVSDiff_noDiffsFoundMsg);
            }
        }, 1);
    }

    protected ICVSFolder getLocalRoot(CVSTeamProvider provider) throws CVSException {
        ICVSFolder root = this.getPatchRootFolder();
        if (root != null) {
            return root;
        }
        return super.getLocalRoot(provider);
    }

    private ICVSFolder getPatchRootFolder() {
        if (!this.isMultiPatch && !this.includeFullPathInformation) {
            Object patchFolder = null;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            patchFolder = this.patchRoot.segmentCount() > 1 ? root.getFolder(this.patchRoot) : root.getProject(this.patchRoot.toString());
            ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)patchFolder);
            if (!cvsResource.isFolder()) {
                cvsResource = cvsResource.getParent();
            }
            return (ICVSFolder)cvsResource;
        }
        return null;
    }

    public boolean consultModelsForMappings() {
        return false;
    }

    public boolean belongsTo(Object family) {
        if (family != null && family.equals(this.destination)) {
            return true;
        }
        return super.belongsTo(family);
    }

    private class CustomizableEOLPrintStream
    extends PrintStream {
        private boolean error = false;
        private String defaultLineEnding = "\n";

        public CustomizableEOLPrintStream(PrintStream openStream) {
            super(openStream);
            if (CVSProviderPlugin.getPlugin().isUsePlatformLineend()) {
                this.defaultLineEnding = System.getProperty("line.separator");
            }
        }

        public boolean checkError() {
            return this.error || super.checkError();
        }

        public void println() {
            try {
                this.write(this.defaultLineEnding.getBytes());
            }
            catch (IOException iOException) {
                this.error = true;
            }
        }

        public void println(boolean x) {
            this.print(x);
            this.println();
        }

        public void println(char x) {
            this.print(x);
            this.println();
        }

        public void println(char[] x) {
            this.print(x);
            this.println();
        }

        public void println(double x) {
            this.print(x);
            this.println();
        }

        public void println(float x) {
            this.print(x);
            this.println();
        }

        public void println(int x) {
            this.print(x);
            this.println();
        }

        public void println(long x) {
            this.print(x);
            this.println();
        }

        public void println(Object x) {
            this.print(x);
            this.println();
        }

        public void println(String x) {
            this.print(x);
            this.println();
        }
    }
}

