/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp.wiring;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.recommenders.rcp.RecommendersPlugin;
import org.eclipse.recommenders.rcp.repo.IModelRepository;

public class RepositoryUrlChangeListener
implements IPropertyChangeListener {
    private final IModelRepository repository;

    @Inject
    public RepositoryUrlChangeListener(IModelRepository repository) {
        this.repository = repository;
        this.hookRegister();
    }

    @VisibleForTesting
    protected void hookRegister() {
        RecommendersPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(RecommendersPlugin.P_REPOSITORY_URL)) {
            String newUrl = event.getNewValue().toString();
            this.repository.setRemote(newUrl);
        }
    }
}

