/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp.repo;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.recommenders.internal.rcp.repo.ModelRepositoryIndex;
import org.eclipse.recommenders.rcp.repo.IModelRepository;
import org.eclipse.recommenders.rcp.repo.IModelRepositoryIndex;
import org.eclipse.recommenders.utils.Zips;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateModelIndexJob
extends Job {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final IModelRepositoryIndex index;
    private final IModelRepository repo;

    public UpdateModelIndexJob(IModelRepositoryIndex index, IModelRepository repo) {
        super("Recommenders: Updating model index.");
        this.index = index;
        this.repo = repo;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            try {
                File location = this.index.getLocation();
                if (this.doesNotExistOrIsAlmostEmptyFolder(location)) {
                    this.downloadAndUnzipIndex(monitor);
                } else if (!this.repo.isLatest(ModelRepositoryIndex.INDEX_ARTIFACT)) {
                    this.repo.delete(ModelRepositoryIndex.INDEX_ARTIFACT);
                    this.downloadAndUnzipIndex(monitor);
                }
            }
            catch (Exception e) {
                this.log.debug("Updating index cancelled.", (Throwable)e);
                IStatus iStatus = Status.CANCEL_STATUS;
                this.index.open();
                return iStatus;
            }
        }
        finally {
            this.index.open();
        }
        return Status.OK_STATUS;
    }

    private boolean doesNotExistOrIsAlmostEmptyFolder(File location) {
        return !location.exists() || location.listFiles().length < 2;
    }

    private void downloadAndUnzipIndex(IProgressMonitor monitor) throws Exception {
        try {
            this.repo.resolve(ModelRepositoryIndex.INDEX_ARTIFACT, monitor);
        }
        catch (NullPointerException nullPointerException) {}
        File f = this.repo.location(ModelRepositoryIndex.INDEX_ARTIFACT);
        if (!f.exists()) {
            return;
        }
        this.index.close();
        File basedir = this.index.getLocation();
        FileUtils.cleanDirectory((File)basedir);
        Zips.unzip((File)f, (File)basedir);
    }
}

