/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp.providers;

import com.google.common.collect.MapMaker;
import com.google.inject.Singleton;
import java.util.Map;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.recommenders.rcp.IAstProvider;
import org.eclipse.recommenders.utils.Checks;

@Singleton
public class CachingAstProvider
implements IAstProvider,
IElementChangedListener {
    private final Map<ICompilationUnit, CompilationUnit> cache = new MapMaker().maximumSize(20).makeMap();

    @Override
    public CompilationUnit get(ICompilationUnit compilationUnit) {
        CompilationUnit ast = this.cache.get(compilationUnit);
        if (ast == null && (ast = SharedASTProvider.getAST((ITypeRoot)compilationUnit, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null)) != null) {
            this.cache.put(compilationUnit, ast);
        }
        return ast;
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        CompilationUnit ast = delta.getCompilationUnitAST();
        if (ast == null) {
            return;
        }
        ICompilationUnit cu = (ICompilationUnit)Checks.cast((Object)ast.getJavaElement());
        if (cu == null) {
            return;
        }
        this.cache.put(cu, ast);
    }
}

