/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp.models.archive;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.eclipse.recommenders.internal.rcp.models.archive.IModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZipPoolableModelFactory<K, M>
implements IModelFactory<K, M> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    protected ZipFile zip;

    public ZipPoolableModelFactory(File zip) throws IOException {
        this(new ZipFile(zip));
    }

    public ZipPoolableModelFactory(ZipFile zip) {
        this.zip = zip;
    }

    @Override
    public void open() {
    }

    @Override
    public boolean validateModel(K key, M model) {
        return true;
    }

    @Override
    public void passivateModel(K key, M model) {
    }

    @Override
    public void destroyModel(K key, M obj) {
    }

    @Override
    public void activateModel(K key, M model) {
    }

    @Override
    public void close() {
        try {
            this.zip.close();
        }
        catch (Exception e) {
            this.log.warn("Failed to close zip'" + this.zip + "'", (Throwable)e);
        }
    }
}

