/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.AbstractDebugActionDelegate;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.viewers.model.ILabelUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.ITreeModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.TimeTriggeredProgressMonitorDialog;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IVirtualItemListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IVirtualItemValidator;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.PresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.VirtualItem;
import org.eclipse.debug.internal.ui.viewers.model.provisional.VirtualTreeModelViewer;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;

public class VirtualCopyToClipboardActionDelegate
extends AbstractDebugActionDelegate {
    private TreeModelViewer fClientViewer;
    private static final String TAB = "\t";
    private static final String SEPARATOR = "line.separator";
    static /* synthetic */ Class class$0;

    protected boolean initialize(IAction action, ISelection selection) {
        if (!this.isInitialized()) {
            IDebugView adapter;
            IViewPart iViewPart = this.getView();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.ui.IDebugView");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IDebugView)iViewPart.getAdapter((Class)clazz)) != null) {
                if (adapter.getViewer() instanceof TreeModelViewer) {
                    this.setViewer((TreeModelViewer)adapter.getViewer());
                }
                adapter.setAction(this.getActionId(), action);
            }
            return super.initialize(action, selection);
        }
        return false;
    }

    protected String getActionId() {
        return IDebugView.COPY_ACTION;
    }

    protected void append(VirtualItem item, StringBuffer buffer, int indent) {
        int i = 0;
        while (i < indent) {
            buffer.append(TAB);
            ++i;
        }
        String[] labels = (String[])item.getData(VirtualItem.LABEL_KEY);
        if (labels != null && labels.length > 0) {
            int i2 = 0;
            while (i2 < labels.length) {
                String text = labels[i2];
                if (text != null && !text.trim().equals("")) {
                    buffer.append(String.valueOf(text) + TAB);
                }
                ++i2;
            }
            buffer.append(System.getProperty(SEPARATOR));
        }
    }

    private IPresentationContext makeVirtualPresentationContext(IPresentationContext clientViewerContext) {
        return new PresentationContext(clientViewerContext.getId(), clientViewerContext){
            {
                String[] clientProperties = iPresentationContext.getProperties();
                int i = 0;
                while (i < clientProperties.length) {
                    this.setProperty(clientProperties[i], iPresentationContext.getProperty(clientProperties[i]));
                    ++i;
                }
            }

            public String[] getColumns() {
                String[] clientColumns = super.getColumns();
                if (clientColumns == null || clientColumns.length == 0) {
                    return null;
                }
                int i = 0;
                while (i < clientColumns.length) {
                    if ("org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_NAME".equals(clientColumns[i])) {
                        return new String[]{"org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_NAME"};
                    }
                    ++i;
                }
                return new String[]{clientColumns[0]};
            }
        };
    }

    private VirtualTreeModelViewer initVirtualViewer(TreeModelViewer clientViewer, VirtualViewerListener listener, ItemsToCopyVirtualItemValidator validator) {
        Object input = clientViewer.getInput();
        ModelDelta stateDelta = new ModelDelta(input, 0);
        clientViewer.saveElementState(TreePath.EMPTY, stateDelta, 0x100000);
        VirtualTreeModelViewer virtualViewer = new VirtualTreeModelViewer(clientViewer.getDisplay(), 0x10000000, this.makeVirtualPresentationContext(clientViewer.getPresentationContext()), validator);
        virtualViewer.setFilters(clientViewer.getFilters());
        virtualViewer.addLabelUpdateListener(listener);
        virtualViewer.getTree().addItemListener(listener);
        virtualViewer.setInput(input);
        virtualViewer.updateViewer(stateDelta);
        listener.fSelectionRootDepth = Integer.MAX_VALUE;
        TreeItem[] selection = this.getSelectedItems(clientViewer);
        HashSet<VirtualItem> vSelection = new HashSet<VirtualItem>(selection.length * 4 / 3);
        int i = 0;
        while (i < selection.length) {
            TreePath parentPath = this.fClientViewer.getTreePathFromItem((Item)selection[i].getParentItem());
            listener.fSelectionRootDepth = Math.min(parentPath.getSegmentCount() + 1, listener.fSelectionRootDepth);
            VirtualItem parentVItem = virtualViewer.findItem(parentPath);
            if (parentVItem != null) {
                int index = -1;
                TreeItem parentItem = selection[i].getParentItem();
                if (parentItem != null) {
                    index = parentItem.indexOf(selection[i]);
                } else {
                    Tree parentTree = selection[i].getParent();
                    index = parentTree.indexOf(selection[i]);
                }
                index = ((ITreeModelContentProvider)clientViewer.getContentProvider()).viewToModelIndex(parentPath, index);
                vSelection.add(parentVItem.getItem(new VirtualItem.Index(index)));
            }
            ++i;
        }
        validator.setItemsToCopy(vSelection);
        listener.fItemsToUpdate = new HashSet(vSelection);
        virtualViewer.getTree().validate();
        return virtualViewer;
    }

    protected TreeItem[] getSelectedItems(TreeModelViewer clientViewer) {
        return clientViewer.getTree().getSelection();
    }

    public void run(IAction action) {
        VirtualTreeModelViewer virtualViewer;
        if (this.fClientViewer.getSelection().isEmpty()) {
            return;
        }
        final VirtualViewerListener listener = new VirtualViewerListener();
        ItemsToCopyVirtualItemValidator validator = new ItemsToCopyVirtualItemValidator();
        listener.fVirtualViewer = virtualViewer = this.initVirtualViewer(this.fClientViewer, listener, validator);
        TimeTriggeredProgressMonitorDialog dialog = new TimeTriggeredProgressMonitorDialog(this.fClientViewer.getControl().getShell(), 500);
        IProgressMonitor monitor = dialog.getProgressMonitor();
        dialog.setCancelable(true);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void run(IProgressMonitor m) throws InvocationTargetException, InterruptedException {
                var2_2 = listener;
                synchronized (var2_2) {
                    listener.fProgressMonitor = m;
                    listener.fProgressMonitor.beginTask(DebugUIPlugin.removeAccelerators(VirtualCopyToClipboardActionDelegate.access$0(VirtualCopyToClipboardActionDelegate.this).getText()), listener.fItemsToUpdate.size());
                    // MONITOREXIT @DISABLED, blocks:[0, 2] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
                    if (true) ** GOTO lbl12
                }
                do {
                    Thread.sleep(1L);
lbl12:
                    // 2 sources

                } while (!listener.fItemsToUpdate.isEmpty() && !listener.fProgressMonitor.isCanceled());
                var2_2 = listener;
                synchronized (var2_2) {
                    listener.fProgressMonitor = null;
                }
            }
        };
        try {
            dialog.run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            DebugUIPlugin.log(e);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        if (!monitor.isCanceled()) {
            this.copySelectionToClipboard(virtualViewer, validator.fItemsToCopy, listener.fSelectionRootDepth);
        }
        virtualViewer.removeLabelUpdateListener(listener);
        virtualViewer.getTree().removeItemListener(listener);
        virtualViewer.dispose();
    }

    private void copySelectionToClipboard(VirtualTreeModelViewer virtualViewer, Set itemsToCopy, int selectionRootDepth) {
        StringBuffer buffer = new StringBuffer();
        this.writeItemToBuffer(virtualViewer.getTree(), itemsToCopy, buffer, -selectionRootDepth);
        this.writeBufferToClipboard(buffer);
    }

    protected void writeItemToBuffer(VirtualItem item, Set itemsToCopy, StringBuffer buffer, int indent) {
        VirtualItem[] children;
        if (itemsToCopy.contains(item)) {
            this.append(item, buffer, indent);
        }
        if ((children = item.getItems()) != null) {
            int i = 0;
            while (i < children.length) {
                this.writeItemToBuffer(children[i], itemsToCopy, buffer, indent + 1);
                ++i;
            }
        }
    }

    protected void writeBufferToClipboard(StringBuffer buffer) {
        if (buffer.length() == 0) {
            return;
        }
        TextTransfer plainTextTransfer = TextTransfer.getInstance();
        Clipboard clipboard = new Clipboard(this.fClientViewer.getControl().getDisplay());
        try {
            try {
                clipboard.setContents((Object[])new String[]{buffer.toString()}, new Transfer[]{plainTextTransfer});
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (MessageDialog.openQuestion((Shell)this.fClientViewer.getControl().getShell(), (String)ActionMessages.CopyToClipboardActionDelegate_Problem_Copying_to_Clipboard_1, (String)ActionMessages.CopyToClipboardActionDelegate_There_was_a_problem_when_accessing_the_system_clipboard__Retry__2)) {
                    this.writeBufferToClipboard(buffer);
                }
                clipboard.dispose();
            }
        }
        finally {
            clipboard.dispose();
        }
    }

    protected TreeModelViewer getViewer() {
        return this.fClientViewer;
    }

    protected void setViewer(TreeModelViewer viewer) {
        this.fClientViewer = viewer;
    }

    protected void doAction(Object element) {
    }

    protected boolean getEnableStateForSelection(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return true;
        }
        return super.getEnableStateForSelection(selection);
    }

    static /* synthetic */ IAction access$0(VirtualCopyToClipboardActionDelegate virtualCopyToClipboardActionDelegate) {
        return virtualCopyToClipboardActionDelegate.getAction();
    }

    private class ItemsToCopyVirtualItemValidator
    implements IVirtualItemValidator {
        Set fItemsToCopy = Collections.EMPTY_SET;
        Set fItemsToValidate = Collections.EMPTY_SET;

        private ItemsToCopyVirtualItemValidator() {
        }

        public boolean isItemVisible(VirtualItem item) {
            return this.fItemsToValidate.contains(item);
        }

        public void showItem(VirtualItem item) {
        }

        void setItemsToCopy(Set itemsToCopy) {
            this.fItemsToCopy = itemsToCopy;
            this.fItemsToValidate = new HashSet();
            Iterator itr = itemsToCopy.iterator();
            while (itr.hasNext()) {
                VirtualItem itemToCopy = (VirtualItem)itr.next();
                while (itemToCopy != null) {
                    this.fItemsToValidate.add(itemToCopy);
                    itemToCopy = itemToCopy.getParent();
                }
            }
        }
    }

    private class VirtualViewerListener
    implements ILabelUpdateListener,
    IVirtualItemListener {
        VirtualTreeModelViewer fVirtualViewer;
        IProgressMonitor fProgressMonitor;
        int fSelectionRootDepth;
        Set fItemsToUpdate;

        private VirtualViewerListener() {
        }

        public void labelUpdateStarted(ILabelUpdate update) {
        }

        public void labelUpdateComplete(ILabelUpdate update) {
            VirtualItem updatedItem = this.fVirtualViewer.findItem(update.getElementPath());
            if (this.fItemsToUpdate.remove(updatedItem)) {
                this.incrementProgress(1);
            }
        }

        public void labelUpdatesBegin() {
        }

        public void labelUpdatesComplete() {
        }

        public void revealed(VirtualItem item) {
        }

        public void disposed(VirtualItem item) {
            if (this.fItemsToUpdate.remove(item)) {
                this.incrementProgress(1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void incrementProgress(int count) {
            IProgressMonitor pm;
            VirtualCopyToClipboardActionDelegate virtualCopyToClipboardActionDelegate = VirtualCopyToClipboardActionDelegate.this;
            synchronized (virtualCopyToClipboardActionDelegate) {
                pm = this.fProgressMonitor;
            }
            if (pm != null) {
                pm.worked(count);
                if (this.fItemsToUpdate.isEmpty()) {
                    pm.done();
                }
            }
        }
    }
}

