/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.PackInvalidException;
import org.eclipse.jgit.errors.PackMismatchException;
import org.eclipse.jgit.errors.StoredObjectRepresentationNotAvailableException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.storage.file.ByteArrayWindow;
import org.eclipse.jgit.storage.file.ByteBufferWindow;
import org.eclipse.jgit.storage.file.ByteWindow;
import org.eclipse.jgit.storage.file.DeltaBaseCache;
import org.eclipse.jgit.storage.file.LargePackedDeltaObject;
import org.eclipse.jgit.storage.file.LargePackedWholeObject;
import org.eclipse.jgit.storage.file.LocalObjectRepresentation;
import org.eclipse.jgit.storage.file.LocalObjectToPack;
import org.eclipse.jgit.storage.file.PackIndex;
import org.eclipse.jgit.storage.file.PackReverseIndex;
import org.eclipse.jgit.storage.file.WindowCache;
import org.eclipse.jgit.storage.file.WindowCursor;
import org.eclipse.jgit.storage.pack.BinaryDelta;
import org.eclipse.jgit.storage.pack.ObjectToPack;
import org.eclipse.jgit.storage.pack.PackOutputStream;
import org.eclipse.jgit.util.LongList;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.RawParseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackFile
implements Iterable<PackIndex.MutableEntry> {
    public static final Comparator<PackFile> SORT = new Comparator<PackFile>(){

        @Override
        public int compare(PackFile a, PackFile b) {
            return b.packLastModified - a.packLastModified;
        }
    };
    private final File idxFile;
    private final File packFile;
    private volatile String packName;
    final int hash;
    private RandomAccessFile fd;
    private final Object readLock = new Object();
    long length;
    private int activeWindows;
    private int activeCopyRawData;
    private int packLastModified;
    private volatile boolean invalid;
    private byte[] packChecksum;
    private PackIndex loadedIdx;
    private PackReverseIndex reverseIdx;
    private volatile LongList corruptObjects;

    public PackFile(File idxFile, File packFile) {
        this.idxFile = idxFile;
        this.packFile = packFile;
        this.packLastModified = (int)(packFile.lastModified() >> 10);
        this.hash = System.identityHashCode(this) * 31;
        this.length = Long.MAX_VALUE;
    }

    private synchronized PackIndex idx() throws IOException {
        if (this.loadedIdx == null) {
            if (this.invalid) {
                throw new PackInvalidException(this.packFile);
            }
            try {
                PackIndex idx = PackIndex.open(this.idxFile);
                if (this.packChecksum == null) {
                    this.packChecksum = idx.packChecksum;
                } else if (!Arrays.equals(this.packChecksum, idx.packChecksum)) {
                    throw new PackMismatchException(JGitText.get().packChecksumMismatch);
                }
                this.loadedIdx = idx;
            }
            catch (IOException e) {
                this.invalid = true;
                throw e;
            }
        }
        return this.loadedIdx;
    }

    public File getPackFile() {
        return this.packFile;
    }

    public String getPackName() {
        String name = this.packName;
        if (name == null) {
            name = this.getPackFile().getName();
            if (name.startsWith("pack-")) {
                name = name.substring("pack-".length());
            }
            if (name.endsWith(".pack")) {
                name = name.substring(0, name.length() - ".pack".length());
            }
            this.packName = name;
        }
        return name;
    }

    public boolean hasObject(AnyObjectId id) throws IOException {
        long offset = this.idx().findOffset(id);
        return 0L < offset && !this.isCorrupt(offset);
    }

    ObjectLoader get(WindowCursor curs, AnyObjectId id) throws IOException {
        long offset = this.idx().findOffset(id);
        return 0L < offset && !this.isCorrupt(offset) ? this.load(curs, offset) : null;
    }

    void resolve(Set<ObjectId> matches, AbbreviatedObjectId id, int matchLimit) throws IOException {
        this.idx().resolve(matches, id, matchLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        WindowCache.purge(this);
        PackFile packFile = this;
        synchronized (packFile) {
            this.loadedIdx = null;
            this.reverseIdx = null;
        }
    }

    @Override
    public Iterator<PackIndex.MutableEntry> iterator() {
        try {
            return this.idx().iterator();
        }
        catch (IOException e) {
            return Collections.emptyList().iterator();
        }
    }

    long getObjectCount() throws IOException {
        return this.idx().getObjectCount();
    }

    ObjectId findObjectForOffset(long offset) throws IOException {
        return this.getReverseIdx().findObject(offset);
    }

    private final byte[] decompress(long position, int sz, WindowCursor curs) throws IOException, DataFormatException {
        byte[] dstbuf;
        try {
            dstbuf = new byte[sz];
        }
        catch (OutOfMemoryError noMemory) {
            return null;
        }
        if (curs.inflate(this, position, dstbuf, 0) != sz) {
            throw new EOFException(MessageFormat.format(JGitText.get().shortCompressedStreamAt, position));
        }
        return dstbuf;
    }

    void copyPackAsIs(PackOutputStream out, boolean validate, WindowCursor curs) throws IOException {
        curs.pin(this, 0L);
        curs.copyPackAsIs(this, this.length, validate, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void copyAsIs(PackOutputStream out, LocalObjectToPack src, boolean validate, WindowCursor curs) throws IOException, StoredObjectRepresentationNotAvailableException {
        this.beginCopyAsIs(src);
        try {
            this.copyAsIs2(out, src, validate, curs);
        }
        finally {
            this.endCopyAsIs();
        }
    }

    private void copyAsIs2(PackOutputStream out, LocalObjectToPack src, boolean validate, WindowCursor curs) throws IOException, StoredObjectRepresentationNotAvailableException {
        long cnt;
        long pos;
        long expectedCRC;
        ByteArrayWindow quickCopy;
        CRC32 crc1 = validate ? new CRC32() : null;
        CRC32 crc2 = validate ? new CRC32() : null;
        byte[] buf = out.getCopyBuffer();
        this.readFully(src.offset, buf, 0, 20, curs);
        int c = buf[0] & 0xFF;
        int typeCode = c >> 4 & 7;
        long inflatedLength = c & 0xF;
        int shift = 4;
        int headerCnt = 1;
        while ((c & 0x80) != 0) {
            c = buf[headerCnt++] & 0xFF;
            inflatedLength += (long)(c & 0x7F) << shift;
            shift += 7;
        }
        if (typeCode == 6) {
            while (((c = buf[headerCnt++] & 0xFF) & 0x80) != 0) {
            }
            if (validate) {
                crc1.update(buf, 0, headerCnt);
                crc2.update(buf, 0, headerCnt);
            }
        } else if (typeCode == 7) {
            if (validate) {
                crc1.update(buf, 0, headerCnt);
                crc2.update(buf, 0, headerCnt);
            }
            this.readFully(src.offset + (long)headerCnt, buf, 0, 20, curs);
            if (validate) {
                crc1.update(buf, 0, 20);
                crc2.update(buf, 0, 20);
            }
            headerCnt += 20;
        } else if (validate) {
            crc1.update(buf, 0, headerCnt);
            crc2.update(buf, 0, headerCnt);
        }
        long dataOffset = src.offset + (long)headerCnt;
        long dataLength = src.length;
        try {
            quickCopy = curs.quickCopy(this, dataOffset, dataLength);
            if (validate && this.idx().hasCRC32Support()) {
                expectedCRC = this.idx().findCRC32(src);
                if (quickCopy != null) {
                    quickCopy.crc32(crc1, dataOffset, (int)dataLength);
                } else {
                    int n;
                    pos = dataOffset;
                    for (cnt = dataLength; cnt > 0L; cnt -= (long)n) {
                        n = (int)Math.min(cnt, (long)buf.length);
                        this.readFully(pos, buf, 0, n, curs);
                        crc1.update(buf, 0, n);
                        pos += (long)n;
                    }
                }
                if (crc1.getValue() != expectedCRC) {
                    this.setCorrupt(src.offset);
                    throw new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, src.offset, this.getPackFile()));
                }
            } else if (validate) {
                Inflater inf = curs.inflater();
                byte[] tmp = new byte[1024];
                if (quickCopy != null) {
                    quickCopy.check(inf, tmp, dataOffset, (int)dataLength);
                } else {
                    int n;
                    long pos2 = dataOffset;
                    for (long cnt2 = dataLength; cnt2 > 0L; cnt2 -= (long)n) {
                        n = (int)Math.min(cnt2, (long)buf.length);
                        this.readFully(pos2, buf, 0, n, curs);
                        crc1.update(buf, 0, n);
                        inf.setInput(buf, 0, n);
                        while (inf.inflate(tmp, 0, tmp.length) > 0) {
                        }
                        pos2 += (long)n;
                    }
                }
                if (!inf.finished() || inf.getBytesRead() != dataLength) {
                    this.setCorrupt(src.offset);
                    throw new EOFException(MessageFormat.format(JGitText.get().shortCompressedStreamAt, src.offset));
                }
                expectedCRC = crc1.getValue();
            } else {
                expectedCRC = -1L;
            }
        }
        catch (DataFormatException dataFormat) {
            this.setCorrupt(src.offset);
            CorruptObjectException corruptObject = new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, src.offset, this.getPackFile()));
            corruptObject.initCause(dataFormat);
            StoredObjectRepresentationNotAvailableException gone = new StoredObjectRepresentationNotAvailableException(src);
            gone.initCause(corruptObject);
            throw gone;
        }
        catch (IOException ioError) {
            StoredObjectRepresentationNotAvailableException gone = new StoredObjectRepresentationNotAvailableException(src);
            gone.initCause(ioError);
            throw gone;
        }
        if (quickCopy != null) {
            out.writeHeader(src, inflatedLength);
            quickCopy.write(out, dataOffset, (int)dataLength, null);
        } else if (dataLength <= (long)buf.length) {
            if (!validate) {
                int n;
                pos = dataOffset;
                for (cnt = dataLength; cnt > 0L; cnt -= (long)n) {
                    n = (int)Math.min(cnt, (long)buf.length);
                    this.readFully(pos, buf, 0, n, curs);
                    pos += (long)n;
                }
            }
            out.writeHeader(src, inflatedLength);
            out.write(buf, 0, (int)dataLength);
        } else {
            int n;
            out.writeHeader(src, inflatedLength);
            pos = dataOffset;
            for (cnt = dataLength; cnt > 0L; cnt -= (long)n) {
                n = (int)Math.min(cnt, (long)buf.length);
                this.readFully(pos, buf, 0, n, curs);
                if (validate) {
                    crc2.update(buf, 0, n);
                }
                out.write(buf, 0, n);
                pos += (long)n;
            }
            if (validate && crc2.getValue() != expectedCRC) {
                throw new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, src.offset, this.getPackFile()));
            }
        }
    }

    boolean invalid() {
        return this.invalid;
    }

    void setInvalid() {
        this.invalid = true;
    }

    private void readFully(long position, byte[] dstbuf, int dstoff, int cnt, WindowCursor curs) throws IOException {
        if (curs.copy(this, position, dstbuf, dstoff, cnt) != cnt) {
            throw new EOFException();
        }
    }

    private synchronized void beginCopyAsIs(ObjectToPack otp) throws StoredObjectRepresentationNotAvailableException {
        if (++this.activeCopyRawData == 1 && this.activeWindows == 0) {
            try {
                this.doOpen();
            }
            catch (IOException thisPackNotValid) {
                StoredObjectRepresentationNotAvailableException gone = new StoredObjectRepresentationNotAvailableException(otp);
                gone.initCause(thisPackNotValid);
                throw gone;
            }
        }
    }

    private synchronized void endCopyAsIs() {
        if (--this.activeCopyRawData == 0 && this.activeWindows == 0) {
            this.doClose();
        }
    }

    synchronized boolean beginWindowCache() throws IOException {
        if (++this.activeWindows == 1) {
            if (this.activeCopyRawData == 0) {
                this.doOpen();
            }
            return true;
        }
        return false;
    }

    synchronized boolean endWindowCache() {
        boolean r;
        boolean bl = r = --this.activeWindows == 0;
        if (r && this.activeCopyRawData == 0) {
            this.doClose();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOpen() throws IOException {
        try {
            if (this.invalid) {
                throw new PackInvalidException(this.packFile);
            }
            Object object = this.readLock;
            synchronized (object) {
                this.fd = new RandomAccessFile(this.packFile, "r");
                this.length = this.fd.length();
                this.onOpenPack();
            }
        }
        catch (IOException ioe) {
            this.openFail();
            throw ioe;
        }
        catch (RuntimeException re) {
            this.openFail();
            throw re;
        }
        catch (Error re) {
            this.openFail();
            throw re;
        }
    }

    private void openFail() {
        this.activeWindows = 0;
        this.activeCopyRawData = 0;
        this.invalid = true;
        this.doClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose() {
        Object object = this.readLock;
        synchronized (object) {
            if (this.fd != null) {
                try {
                    this.fd.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.fd = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteArrayWindow read(long pos, int size) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            if (this.length < pos + (long)size) {
                size = (int)(this.length - pos);
            }
            byte[] buf = new byte[size];
            this.fd.seek(pos);
            this.fd.readFully(buf, 0, size);
            return new ByteArrayWindow(this, pos, buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteWindow mmap(long pos, int size) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            MappedByteBuffer map;
            if (this.length < pos + (long)size) {
                size = (int)(this.length - pos);
            }
            try {
                map = this.fd.getChannel().map(FileChannel.MapMode.READ_ONLY, pos, size);
            }
            catch (IOException ioe1) {
                System.gc();
                System.runFinalization();
                map = this.fd.getChannel().map(FileChannel.MapMode.READ_ONLY, pos, size);
            }
            if (map.hasArray()) {
                return new ByteArrayWindow(this, pos, map.array());
            }
            return new ByteBufferWindow(this, pos, map);
        }
    }

    private void onOpenPack() throws IOException {
        PackIndex idx = this.idx();
        byte[] buf = new byte[20];
        this.fd.seek(0L);
        this.fd.readFully(buf, 0, 12);
        if (RawParseUtils.match(buf, 0, Constants.PACK_SIGNATURE) != 4) {
            throw new IOException(JGitText.get().notAPACKFile);
        }
        long vers = NB.decodeUInt32(buf, 4);
        long packCnt = NB.decodeUInt32(buf, 8);
        if (vers != 2L && vers != 3L) {
            throw new IOException(MessageFormat.format(JGitText.get().unsupportedPackVersion, vers));
        }
        if (packCnt != idx.getObjectCount()) {
            throw new PackMismatchException(MessageFormat.format(JGitText.get().packObjectCountMismatch, packCnt, idx.getObjectCount(), this.getPackFile()));
        }
        this.fd.seek(this.length - 20L);
        this.fd.readFully(buf, 0, 20);
        if (!Arrays.equals(buf, this.packChecksum)) {
            throw new PackMismatchException(MessageFormat.format(JGitText.get().packObjectCountMismatch, ObjectId.fromRaw(buf).name(), ObjectId.fromRaw(idx.packChecksum).name(), this.getPackFile()));
        }
    }

    ObjectLoader load(WindowCursor curs, long pos) throws IOException {
        try {
            byte[] ib = curs.tempId;
            Delta delta = null;
            byte[] data = null;
            int type = -1;
            boolean cached = false;
            block9: while (true) {
                this.readFully(pos, ib, 0, 20, curs);
                int c = ib[0] & 0xFF;
                int typeCode = c >> 4 & 7;
                long sz = c & 0xF;
                int shift = 4;
                int p = 1;
                while ((c & 0x80) != 0) {
                    c = ib[p++] & 0xFF;
                    sz += (long)(c & 0x7F) << shift;
                    shift += 7;
                }
                switch (typeCode) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        if (sz < (long)curs.getStreamFileThreshold()) {
                            data = this.decompress(pos + (long)p, (int)sz, curs);
                        }
                        if (delta != null) {
                            type = typeCode;
                            break block9;
                        }
                        if (data != null) {
                            return new ObjectLoader.SmallObject(typeCode, data);
                        }
                        return new LargePackedWholeObject(typeCode, sz, pos, p, this, curs.db);
                    }
                    case 6: {
                        c = ib[p++] & 0xFF;
                        long base = c & 0x7F;
                        while ((c & 0x80) != 0) {
                            ++base;
                            c = ib[p++] & 0xFF;
                            base <<= 7;
                            base += (long)(c & 0x7F);
                        }
                        base = pos - base;
                        delta = new Delta(delta, pos, (int)sz, p, base);
                        if (sz != (long)delta.deltaSize) break block9;
                        DeltaBaseCache.Entry e = curs.getDeltaBaseCache().get(this, base);
                        if (e != null) {
                            type = e.type;
                            data = e.data;
                            cached = true;
                            break block9;
                        }
                        pos = base;
                        continue block9;
                    }
                    case 7: {
                        this.readFully(pos + (long)p, ib, 0, 20, curs);
                        long base = this.findDeltaBase(ObjectId.fromRaw(ib));
                        delta = new Delta(delta, pos, (int)sz, p + 20, base);
                        if (sz != (long)delta.deltaSize) break block9;
                        DeltaBaseCache.Entry e = curs.getDeltaBaseCache().get(this, base);
                        if (e != null) {
                            type = e.type;
                            data = e.data;
                            cached = true;
                            break block9;
                        }
                        pos = base;
                        continue block9;
                    }
                    default: {
                        throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, typeCode));
                    }
                }
                break;
            }
            if (data == null) {
                return delta.large(this, curs);
            }
            do {
                byte[] result;
                if (cached) {
                    cached = false;
                } else if (delta.next == null) {
                    curs.getDeltaBaseCache().store(this, delta.basePos, data, type);
                }
                pos = delta.deltaPos;
                byte[] cmds = this.decompress(pos + (long)delta.hdrLen, delta.deltaSize, curs);
                if (cmds == null) {
                    data = null;
                    return delta.large(this, curs);
                }
                long sz = BinaryDelta.getResultSize(cmds);
                if (Integer.MAX_VALUE <= sz) {
                    return delta.large(this, curs);
                }
                try {
                    result = new byte[(int)sz];
                }
                catch (OutOfMemoryError tooBig) {
                    data = null;
                    return delta.large(this, curs);
                }
                BinaryDelta.apply(data, cmds, result);
                data = result;
            } while ((delta = delta.next) != null);
            return new ObjectLoader.SmallObject(type, data);
        }
        catch (DataFormatException dfe) {
            CorruptObjectException coe = new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, pos, this.getPackFile()));
            coe.initCause(dfe);
            throw coe;
        }
    }

    private long findDeltaBase(ObjectId baseId) throws IOException, MissingObjectException {
        long ofs = this.idx().findOffset(baseId);
        if (ofs < 0L) {
            throw new MissingObjectException(baseId, JGitText.get().missingDeltaBase);
        }
        return ofs;
    }

    byte[] getDeltaHeader(WindowCursor wc, long pos) throws IOException, DataFormatException {
        byte[] hdr = new byte[18];
        wc.inflate(this, pos, hdr, 0);
        return hdr;
    }

    int getObjectType(WindowCursor curs, long pos) throws IOException {
        int type;
        byte[] ib = curs.tempId;
        block5: while (true) {
            this.readFully(pos, ib, 0, 20, curs);
            int c = ib[0] & 0xFF;
            type = c >> 4 & 7;
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return type;
                }
                case 6: {
                    int p = 1;
                    while ((c & 0x80) != 0) {
                        c = ib[p++] & 0xFF;
                    }
                    c = ib[p++] & 0xFF;
                    long ofs = c & 0x7F;
                    while ((c & 0x80) != 0) {
                        ++ofs;
                        c = ib[p++] & 0xFF;
                        ofs <<= 7;
                        ofs += (long)(c & 0x7F);
                    }
                    pos -= ofs;
                    continue block5;
                }
                case 7: {
                    int p = 1;
                    while ((c & 0x80) != 0) {
                        c = ib[p++] & 0xFF;
                    }
                    this.readFully(pos + (long)p, ib, 0, 20, curs);
                    pos = this.findDeltaBase(ObjectId.fromRaw(ib));
                    continue block5;
                }
            }
            break;
        }
        throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, type));
    }

    long getObjectSize(WindowCursor curs, AnyObjectId id) throws IOException {
        long offset = this.idx().findOffset(id);
        return 0L < offset ? this.getObjectSize(curs, offset) : -1L;
    }

    long getObjectSize(WindowCursor curs, long pos) throws IOException {
        long deltaAt;
        byte[] ib = curs.tempId;
        this.readFully(pos, ib, 0, 20, curs);
        int c = ib[0] & 0xFF;
        int type = c >> 4 & 7;
        long sz = c & 0xF;
        int shift = 4;
        int p = 1;
        while ((c & 0x80) != 0) {
            c = ib[p++] & 0xFF;
            sz += (long)(c & 0x7F) << shift;
            shift += 7;
        }
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return sz;
            }
            case 6: {
                c = ib[p++] & 0xFF;
                while ((c & 0x80) != 0) {
                    c = ib[p++] & 0xFF;
                }
                deltaAt = pos + (long)p;
                break;
            }
            case 7: {
                deltaAt = pos + (long)p + 20L;
                break;
            }
            default: {
                throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, type));
            }
        }
        try {
            return BinaryDelta.getResultSize(this.getDeltaHeader(curs, deltaAt));
        }
        catch (DataFormatException e) {
            throw new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, pos, this.getPackFile()));
        }
    }

    LocalObjectRepresentation representation(WindowCursor curs, AnyObjectId objectId) throws IOException {
        long pos = this.idx().findOffset(objectId);
        if (pos < 0L) {
            return null;
        }
        byte[] ib = curs.tempId;
        this.readFully(pos, ib, 0, 20, curs);
        int c = ib[0] & 0xFF;
        int p = 1;
        int typeCode = c >> 4 & 7;
        while ((c & 0x80) != 0) {
            c = ib[p++] & 0xFF;
        }
        long len = this.findEndOffset(pos) - pos;
        switch (typeCode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return LocalObjectRepresentation.newWhole(this, pos, len - (long)p);
            }
            case 6: {
                c = ib[p++] & 0xFF;
                long ofs = c & 0x7F;
                while ((c & 0x80) != 0) {
                    ++ofs;
                    c = ib[p++] & 0xFF;
                    ofs <<= 7;
                    ofs += (long)(c & 0x7F);
                }
                ofs = pos - ofs;
                return LocalObjectRepresentation.newDelta(this, pos, len - (long)p, ofs);
            }
            case 7: {
                len -= (long)p;
                this.readFully(pos + (long)p, ib, 0, 20, curs);
                ObjectId id = ObjectId.fromRaw(ib);
                return LocalObjectRepresentation.newDelta(this, pos, len -= 20L, id);
            }
        }
        throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, typeCode));
    }

    private long findEndOffset(long startOffset) throws IOException, CorruptObjectException {
        long maxOffset = this.length - 20L;
        return this.getReverseIdx().findNextOffset(startOffset, maxOffset);
    }

    private synchronized PackReverseIndex getReverseIdx() throws IOException {
        if (this.reverseIdx == null) {
            this.reverseIdx = new PackReverseIndex(this.idx());
        }
        return this.reverseIdx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCorrupt(long offset) {
        LongList list = this.corruptObjects;
        if (list == null) {
            return false;
        }
        LongList longList = list;
        synchronized (longList) {
            return list.contains(offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCorrupt(long offset) {
        Object object;
        LongList list = this.corruptObjects;
        if (list == null) {
            object = this.readLock;
            synchronized (object) {
                list = this.corruptObjects;
                if (list == null) {
                    this.corruptObjects = list = new LongList();
                }
            }
        }
        object = list;
        synchronized (object) {
            list.add(offset);
        }
    }

    private static class Delta {
        final Delta next;
        final long deltaPos;
        final int deltaSize;
        final int hdrLen;
        final long basePos;

        Delta(Delta next, long ofs, int sz, int hdrLen, long baseOffset) {
            this.next = next;
            this.deltaPos = ofs;
            this.deltaSize = sz;
            this.hdrLen = hdrLen;
            this.basePos = baseOffset;
        }

        ObjectLoader large(PackFile pack, WindowCursor wc) {
            Delta d = this;
            while (d.next != null) {
                d = d.next;
            }
            return d.newLargeLoader(pack, wc);
        }

        private ObjectLoader newLargeLoader(PackFile pack, WindowCursor wc) {
            return new LargePackedDeltaObject(this.deltaPos, this.basePos, this.hdrLen, pack, wc.db);
        }
    }
}

