/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.internal.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mylyn.builds.core.IBuildFactory;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.core.spi.BuildServerBehaviour;
import org.eclipse.mylyn.builds.core.spi.BuildServerConfiguration;
import org.eclipse.mylyn.builds.internal.core.BuildElement;
import org.eclipse.mylyn.builds.internal.core.BuildPackage;
import org.eclipse.mylyn.builds.internal.core.IBuildLoader;
import org.eclipse.mylyn.builds.internal.core.operations.RefreshConfigurationOperation;
import org.eclipse.mylyn.builds.internal.core.operations.RefreshSession;
import org.eclipse.mylyn.commons.core.net.NetUtil;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;

public class BuildServer
extends BuildElement
implements IBuildServer {
    protected static final RepositoryLocation LOCATION_EDEFAULT = null;
    protected RepositoryLocation location = LOCATION_EDEFAULT;
    protected static final String CONNECTOR_KIND_EDEFAULT = null;
    protected String connectorKind = CONNECTOR_KIND_EDEFAULT;
    protected static final String REPOSITORY_URL_EDEFAULT = null;
    protected String repositoryUrl = REPOSITORY_URL_EDEFAULT;
    private final PropertyChangeListener locationChangeListener = new PropertyChangeListener(){

        public void propertyChange(final PropertyChangeEvent event) {
            BuildServer.this.getLoader().getRealm().asyncExec(new Runnable(){

                public void run() {
                    if (event.getNewValue() == null) {
                        BuildServer.this.getAttributes().remove(event.getPropertyName());
                    }
                    if (event.getNewValue() instanceof String) {
                        BuildServer.this.getAttributes().put(event.getPropertyName(), (String)event.getNewValue());
                    }
                    if ("label".equals(event.getPropertyName())) {
                        BuildServer.this.setName((String)event.getNewValue());
                    } else if ("url".equals(event.getPropertyName())) {
                        BuildServer.this.setUrl(event.getNewValue().toString());
                    }
                }
            });
        }
    };
    private RefreshSession refreshSession;
    private IBuildLoader loader;
    private BuildServerBehaviour behaviour;

    protected BuildServer() {
    }

    protected EClass eStaticClass() {
        return BuildPackage.Literals.BUILD_SERVER;
    }

    public RepositoryLocation getLocation() {
        return this.location;
    }

    public void setLocation(RepositoryLocation newLocation) {
        RepositoryLocation oldLocation = this.location;
        if (oldLocation != null) {
            oldLocation.removePropertyChangeListener(this.locationChangeListener);
        }
        this.location = newLocation;
        if (this.location != null) {
            this.location.addPropertyChangeListener(this.locationChangeListener);
        }
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldLocation, (Object)this.location));
        }
    }

    public String getConnectorKind() {
        return this.connectorKind;
    }

    public void setConnectorKind(String newConnectorKind) {
        String oldConnectorKind = this.connectorKind;
        this.connectorKind = newConnectorKind;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldConnectorKind, (Object)this.connectorKind));
        }
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public void setRepositoryUrl(String newRepositoryUrl) {
        String oldRepositoryUrl = this.repositoryUrl;
        this.repositoryUrl = newRepositoryUrl;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldRepositoryUrl, (Object)this.repositoryUrl));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 6: {
                return this.getLocation();
            }
            case 7: {
                return this.getConnectorKind();
            }
            case 8: {
                return this.getRepositoryUrl();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 6: {
                this.setLocation((RepositoryLocation)newValue);
                return;
            }
            case 7: {
                this.setConnectorKind((String)newValue);
                return;
            }
            case 8: {
                this.setRepositoryUrl((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 6: {
                this.setLocation(LOCATION_EDEFAULT);
                return;
            }
            case 7: {
                this.setConnectorKind(CONNECTOR_KIND_EDEFAULT);
                return;
            }
            case 8: {
                this.setRepositoryUrl(REPOSITORY_URL_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 6: {
                return LOCATION_EDEFAULT == null ? this.location != null : !LOCATION_EDEFAULT.equals(this.location);
            }
            case 7: {
                return CONNECTOR_KIND_EDEFAULT == null ? this.connectorKind != null : !CONNECTOR_KIND_EDEFAULT.equals(this.connectorKind);
            }
            case 8: {
                return REPOSITORY_URL_EDEFAULT == null ? this.repositoryUrl != null : !REPOSITORY_URL_EDEFAULT.equals(this.repositoryUrl);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (location: ");
        result.append(this.location);
        result.append(", connectorKind: ");
        result.append(this.connectorKind);
        result.append(", repositoryUrl: ");
        result.append(this.repositoryUrl);
        result.append(')');
        return result.toString();
    }

    public IBuildLoader getLoader() {
        return this.loader;
    }

    public void setLoader(IBuildLoader loader) {
        this.loader = loader;
    }

    public BuildServerBehaviour getBehaviour() throws CoreException {
        if (this.behaviour == null) {
            this.behaviour = this.getLoader().loadBehaviour(this);
        }
        return this.behaviour;
    }

    public IBuildServer getServer() {
        return this;
    }

    public IStatus validate(IOperationMonitor monitor) throws CoreException {
        return this.getBehaviour().validate(monitor);
    }

    public BuildServer getOriginal() {
        return (BuildServer)super.getOriginal();
    }

    public BuildServer createWorkingCopy() {
        BuildServer newServer = (BuildServer)super.createWorkingCopy();
        newServer.setLoader(this.getLoader());
        return newServer;
    }

    public void applyToOriginal() {
        if (this.original == null) {
            throw new IllegalStateException();
        }
        EcoreUtil.Copier copier = new EcoreUtil.Copier(){

            protected EObject createCopy(EObject source) {
                return BuildServer.this.original;
            }

            protected void copyAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
                if (eAttribute.getFeatureID() == 6) {
                    return;
                }
                super.copyAttribute(eAttribute, eObject, copyEObject);
            }

            protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
            }
        };
        copier.copy((EObject)this);
    }

    public IBuildPlan createBuildPlan() {
        IBuildPlan plan = IBuildFactory.INSTANCE.createBuildPlan();
        return plan;
    }

    public BuildServerConfiguration getConfiguration() throws CoreException {
        return this.getBehaviour().getConfiguration();
    }

    public BuildServerConfiguration refreshConfiguration(IOperationMonitor monitor) throws CoreException {
        new RefreshConfigurationOperation(Collections.singletonList(this)).run((IProgressMonitor)monitor);
        return this.getConfiguration();
    }

    public String getShortUrl() {
        String url = this.getUrl();
        if (url != null) {
            return NetUtil.getHost((String)url);
        }
        return url;
    }

    public String getLabel() {
        String name = this.getName();
        if (name != null && name.length() > 0) {
            return name;
        }
        return this.getShortUrl();
    }

    public synchronized RefreshSession getRefreshSession() {
        if (this.refreshSession == null) {
            this.refreshSession = new RefreshSession(this);
        }
        return this.refreshSession;
    }
}

