/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.reflect;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.sonatype.guice.bean.reflect.MildKeys;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MildValues<K, V>
implements Map<K, V> {
    final ReferenceQueue<V> queue = new ReferenceQueue();
    private final Map<K, Reference<V>> map;
    private final boolean soft;

    MildValues(Map<K, Reference<V>> map, boolean soft) {
        this.map = map;
        this.soft = soft;
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.map.containsValue(MildValues.tempValue(value));
    }

    @Override
    public final V get(Object key) {
        Reference<V> ref = this.map.get(key);
        return null != ref ? (V)ref.get() : null;
    }

    @Override
    public final V put(K key, V value) {
        this.compact();
        Reference<V> ref = this.map.put(key, this.mildValue(key, value));
        return null != ref ? (V)ref.get() : null;
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> m) {
        this.compact();
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.map.put(e.getKey(), this.mildValue(e.getKey(), e.getValue()));
        }
    }

    @Override
    public final V remove(Object key) {
        this.compact();
        Reference<V> ref = this.map.remove(key);
        return null != ref ? (V)ref.get() : null;
    }

    @Override
    public final void clear() {
        this.map.clear();
        this.compact();
    }

    @Override
    public final boolean isEmpty() {
        this.compact();
        return this.map.isEmpty();
    }

    @Override
    public final int size() {
        this.compact();
        return this.map.size();
    }

    @Override
    public final Set<K> keySet() {
        this.compact();
        return this.map.keySet();
    }

    @Override
    public final Collection<V> values() {
        this.compact();
        ArrayList<V> values = new ArrayList<V>();
        for (Reference<V> r : this.map.values()) {
            V value = r.get();
            if (null == value) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        this.compact();
        HashMap<K, V> entries = new HashMap<K, V>();
        for (Map.Entry<K, Reference<V>> e : this.map.entrySet()) {
            V value = e.getValue().get();
            if (null == value) continue;
            entries.put(e.getKey(), value);
        }
        return entries.entrySet();
    }

    final Reference<V> mildValue(K key, V value) {
        return this.soft ? new Soft<K, V>(key, value, this.queue) : new Weak<K, V>(key, value, this.queue);
    }

    static final Reference<?> tempValue(Object value) {
        return new Weak<Object, Object>(null, value, null);
    }

    void compact() {
        Reference<V> ref;
        while ((ref = this.queue.poll()) != null) {
            Object key = ((InverseMapping)((Object)ref)).key();
            if (this.map.get(key) != ref) continue;
            this.map.remove(key);
        }
    }

    static interface InverseMapping {
        public Object key();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Soft<K, V>
    extends MildKeys.Soft<V>
    implements InverseMapping {
        private final K key;

        Soft(K key, V value, ReferenceQueue<V> queue) {
            super(value, queue);
            this.key = key;
        }

        @Override
        public Object key() {
            return this.key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Weak<K, V>
    extends MildKeys.Weak<V>
    implements InverseMapping {
        private final K key;

        Weak(K key, V value, ReferenceQueue<V> queue) {
            super(value, queue);
            this.key = key;
        }

        @Override
        public Object key() {
            return this.key;
        }
    }
}

