/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.scm;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Scm;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.project.AbstractProjectScanner;
import org.eclipse.m2e.scm.MavenProjectScmInfo;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenProjectPomScanner<T>
extends AbstractProjectScanner<MavenProjectScmInfo> {
    private static final Logger log = LoggerFactory.getLogger(MavenProjectPomScanner.class);
    private final boolean developer;
    private final Dependency[] dependencies;
    private IMaven maven;

    public MavenProjectPomScanner(boolean developer, Dependency[] dependencies) {
        this.developer = developer;
        this.dependencies = dependencies;
        this.maven = MavenPlugin.getMaven();
    }

    public String getDescription() {
        if (this.dependencies.length == 1) {
            Dependency d = this.dependencies[0];
            return String.valueOf(d.getGroupId()) + ":" + d.getArtifactId() + ":" + d.getVersion() + (d.getClassifier() == null ? "" : ":" + d.getClassifier());
        }
        return this.dependencies.length + " projects";
    }

    /*
     * Unable to fully structure code
     */
    public void run(IProgressMonitor monitor) throws InterruptedException {
        i = 0;
        while (i < this.dependencies.length) {
            block10: {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                d = this.dependencies[i];
                try {
                    block11: {
                        model = this.resolveModel(d.getGroupId(), d.getArtifactId(), d.getVersion(), monitor);
                        if (model == null) {
                            msg = "Can't resolve " + d.getArtifactId();
                            error = new Exception(msg);
                            MavenProjectPomScanner.log.error(msg, (Throwable)error);
                            this.addError(error);
                            break block10;
                        }
                        scm = this.resolveScm(model, monitor);
                        if (scm == null) {
                            msg = "No SCM info for " + d.getArtifactId();
                            error = new Exception(msg);
                            MavenProjectPomScanner.log.error(msg, (Throwable)error);
                            this.addError(error);
                            break block10;
                        }
                        tag = scm.getTag();
                        MavenProjectPomScanner.log.info(d.getArtifactId());
                        MavenProjectPomScanner.log.info("Connection: " + scm.getConnection());
                        MavenProjectPomScanner.log.info("       dev: " + scm.getDeveloperConnection());
                        MavenProjectPomScanner.log.info("       url: " + scm.getUrl());
                        MavenProjectPomScanner.log.info("       tag: " + tag);
                        if (!this.developer) break block11;
                        connection = scm.getDeveloperConnection();
                        if (connection == null) {
                            msg = String.valueOf(d.getArtifactId()) + " doesn't specify developer SCM connection";
                            error = new Exception(msg);
                            MavenProjectPomScanner.log.error(msg, (Throwable)error);
                            this.addError(error);
                            break block10;
                        }
                        ** GOTO lbl-1000
                    }
                    connection = scm.getConnection();
                    if (connection == null) {
                        msg = String.valueOf(d.getArtifactId()) + " doesn't specify SCM connection";
                        error = new Exception(msg);
                        MavenProjectPomScanner.log.error(msg, (Throwable)error);
                        this.addError(error);
                    } else lbl-1000:
                    // 2 sources

                    {
                        if (connection.endsWith("/")) {
                            connection = connection.substring(0, connection.length() - 1);
                        }
                        label = String.valueOf((n = connection.lastIndexOf("/")) == -1 ? connection : connection.substring(n)) + "/" + "pom.xml";
                        this.addProject(new MavenProjectScmInfo(label, model, null, tag, connection, connection));
                    }
                }
                catch (Exception ex) {
                    this.addError(ex);
                    msg = "Error reading " + d.getArtifactId();
                    MavenProjectPomScanner.log.error(msg, (Throwable)ex);
                }
            }
            ++i;
        }
    }

    private Scm resolveScm(Model model, IProgressMonitor monitor) throws ArtifactResolutionException, ArtifactNotFoundException, XmlPullParserException, IOException, CoreException {
        Scm scm = model.getScm();
        if (scm != null) {
            return scm;
        }
        Parent parent = model.getParent();
        if (parent == null) {
            return null;
        }
        Model parentModel = this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), monitor);
        if (parentModel == null) {
            return null;
        }
        Scm parentScm = this.resolveScm(parentModel, monitor);
        if (parentScm == null) {
            return null;
        }
        HashSet modules = new HashSet(parentModel.getModules());
        List parentModelProfiles = parentModel.getProfiles();
        for (Profile profile : parentModelProfiles) {
            modules.addAll(profile.getModules());
        }
        String artifactId = model.getArtifactId();
        for (String module : modules) {
            if (!module.equals(artifactId) && !module.endsWith("/" + artifactId)) continue;
            if (parentScm.getConnection() != null) {
                parentScm.setConnection(String.valueOf(parentScm.getConnection()) + "/" + module);
            }
            if (parentScm.getDeveloperConnection() != null) {
                parentScm.setDeveloperConnection(String.valueOf(parentScm.getDeveloperConnection()) + "/" + module);
            }
            return parentScm;
        }
        return parentScm;
    }

    private Model resolveModel(String groupId, String artifactId, String version, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(NLS.bind((String)Messages.MavenProjectPomScanner_task_resolving, (Object[])new Object[]{groupId, artifactId, version}));
        List repositories = this.maven.getArtifactRepositories();
        Artifact artifact = this.maven.resolve(groupId, artifactId, version, "pom", null, repositories, monitor);
        File file = artifact.getFile();
        if (file == null) {
            return null;
        }
        monitor.subTask(NLS.bind((String)Messages.MavenProjectPomScanner_23, (Object[])new Object[]{groupId, artifactId, version}));
        return this.maven.readModel(file);
    }
}

