/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.helpers;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.e4.ui.css.core.dom.CSSStylableElement;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.css.swt.dom.html.SWTHTMLElement;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Element;

public class SWTElementHelpers {
    public static final String SWT_ELEMENT_KEY = "org.eclipse.e4.ui.core.css.swt.dom.SWTElement.ELEMENT";
    public static final String SWT_NODELIST_KEY = "org.eclipse.e4.ui.core.css.swt.dom.SWTElement.NODELIST";
    private static final Class[] ELEMENT_CONSTRUCTOR_PARAM = new Class[]{Widget.class, CSSEngine.class};

    public static Element getElement(Widget widget, CSSEngine engine, Class classElement) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Constructor constructor = classElement.getConstructor(ELEMENT_CONSTRUCTOR_PARAM);
        Object[] o = new Object[]{widget, engine};
        Element newElement = (Element)constructor.newInstance(o);
        return newElement;
    }

    public static Element getElement(Widget widget, CSSEngine engine) {
        try {
            return SWTElementHelpers.getElement(widget, engine, WidgetElement.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Element getHTMLElement(Widget widget, CSSEngine engine) {
        try {
            return SWTElementHelpers.getElement(widget, engine, SWTHTMLElement.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Control getControl(Object element) {
        CSSStylableElement elt;
        Object widget;
        if (element instanceof Control) {
            return (Control)element;
        }
        if (element instanceof CSSStylableElement && (widget = (elt = (CSSStylableElement)element).getNativeWidget()) instanceof Control) {
            return (Control)widget;
        }
        return null;
    }

    public static Widget getWidget(Object element) {
        CSSStylableElement elt;
        Object widget;
        if (element instanceof Widget) {
            return (Widget)element;
        }
        if (element instanceof CSSStylableElement && (widget = (elt = (CSSStylableElement)element).getNativeWidget()) instanceof Widget) {
            return (Widget)widget;
        }
        return null;
    }
}

