/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters.io;

import java.io.IOException;
import java.io.Reader;
import java.util.NoSuchElementException;
import org.apache.commons.collections.primitives.CharIterator;

public class ReaderCharIterator
implements CharIterator {
    private Reader reader = null;
    private boolean nextAvailable = false;
    private int next;

    public ReaderCharIterator(Reader in) {
        this.reader = in;
    }

    public static CharIterator adapt(Reader in) {
        return in == null ? null : new ReaderCharIterator(in);
    }

    public boolean hasNext() {
        this.ensureNextAvailable();
        return -1 != this.next;
    }

    public char next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element");
        }
        this.nextAvailable = false;
        return (char)this.next;
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("remove() is not supported here");
    }

    private void ensureNextAvailable() {
        if (!this.nextAvailable) {
            this.readNext();
        }
    }

    private void readNext() {
        try {
            this.next = this.reader.read();
            this.nextAvailable = true;
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }
}

