/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.primitives.ByteCollection;
import org.apache.commons.collections.primitives.ByteIterator;
import org.apache.commons.collections.primitives.ByteList;
import org.apache.commons.collections.primitives.ByteListIterator;
import org.apache.commons.collections.primitives.adapters.AbstractCollectionByteCollection;
import org.apache.commons.collections.primitives.adapters.ByteCollectionCollection;
import org.apache.commons.collections.primitives.adapters.ListByteList;
import org.apache.commons.collections.primitives.adapters.ListIteratorByteListIterator;

abstract class AbstractListByteList
extends AbstractCollectionByteCollection
implements ByteList {
    AbstractListByteList() {
    }

    public void add(int index, byte element) {
        this.getList().add(index, new Byte(element));
    }

    public boolean addAll(int index, ByteCollection collection) {
        return this.getList().addAll(index, ByteCollectionCollection.wrap(collection));
    }

    public byte get(int index) {
        return ((Number)this.getList().get(index)).byteValue();
    }

    public int indexOf(byte element) {
        return this.getList().indexOf(new Byte(element));
    }

    public int lastIndexOf(byte element) {
        return this.getList().lastIndexOf(new Byte(element));
    }

    public ByteListIterator listIterator() {
        return ListIteratorByteListIterator.wrap(this.getList().listIterator());
    }

    public ByteListIterator listIterator(int index) {
        return ListIteratorByteListIterator.wrap(this.getList().listIterator(index));
    }

    public byte removeElementAt(int index) {
        return ((Number)this.getList().remove(index)).byteValue();
    }

    public byte set(int index, byte element) {
        return ((Number)this.getList().set(index, new Byte(element))).byteValue();
    }

    public ByteList subList(int fromIndex, int toIndex) {
        return ListByteList.wrap(this.getList().subList(fromIndex, toIndex));
    }

    public boolean equals(Object obj) {
        if (obj instanceof ByteList) {
            ByteList that = (ByteList)obj;
            if (this == that) {
                return true;
            }
            if (this.size() != that.size()) {
                return false;
            }
            ByteIterator thisiter = this.iterator();
            ByteIterator thatiter = that.iterator();
            while (thisiter.hasNext()) {
                if (thisiter.next() == thatiter.next()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.getList().hashCode();
    }

    protected final Collection getCollection() {
        return this.getList();
    }

    protected abstract List getList();
}

