/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.recommenders.jayes.Factor;
import org.eclipse.recommenders.jayes.util.BidirectionalMap;
import org.eclipse.recommenders.jayes.util.MathUtils;

public class BayesNode {
    private final String name;
    private final List<BayesNode> children = new ArrayList<BayesNode>();
    private List<BayesNode> parents = new ArrayList<BayesNode>();
    private int outcomes = 0;
    private final BidirectionalMap<String, Integer> outcomeIndices = new BidirectionalMap();
    private final Factor factor = new Factor();
    private int id = -1;

    public BayesNode(String name) {
        this.name = name;
    }

    public void setProbabilities(double[] probabilities) {
        this.factor.setValues(probabilities);
    }

    public List<BayesNode> getChildren() {
        return this.children;
    }

    public List<BayesNode> getParents() {
        return Collections.unmodifiableList(this.parents);
    }

    public void setParents(List<BayesNode> parents) {
        this.parents = parents;
        for (BayesNode p : parents) {
            p.children.add(this);
        }
        this.adjustFactordimensions();
    }

    private void adjustFactordimensions() {
        int[] dimensions = new int[this.parents.size() + 1];
        int[] dimensionIds = new int[this.parents.size() + 1];
        this.fillWithParentDimensions(dimensions, dimensionIds);
        this.insertSelf(dimensions, dimensionIds);
        this.factor.setDimensions(dimensions);
        this.factor.setDimensionIDs(dimensionIds);
    }

    private void insertSelf(int[] dimensions, int[] dimensionIds) {
        dimensions[dimensions.length - 1] = this.getOutcomeCount();
        dimensionIds[dimensionIds.length - 1] = this.getId();
    }

    private void fillWithParentDimensions(int[] dimensions, int[] dimensionIds) {
        ListIterator<BayesNode> it = this.parents.listIterator();
        while (it.hasNext()) {
            BayesNode p = it.next();
            dimensions[it.nextIndex() - 1] = p.getOutcomeCount();
            dimensionIds[it.nextIndex() - 1] = p.getId();
        }
    }

    public double[] marginalize(Map<BayesNode, String> evidence) {
        for (BayesNode p : this.parents) {
            if (evidence.containsKey(p)) {
                this.factor.select(p.getId(), p.getOutcomeIndex(evidence.get(p)));
                continue;
            }
            this.factor.select(p.getId(), -1);
        }
        double[] result = MathUtils.normalize(this.factor.sum(-1));
        this.factor.resetSelections();
        return result;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        if (this.id != -1 && this.id != id) {
            throw new IllegalStateException("Impossible to reset Id!");
        }
        this.id = id;
        this.adjustFactordimensions();
    }

    public int addOutcome(String name) {
        if (!this.outcomeIndices.containsKey(name)) {
            this.outcomeIndices.put(name, this.outcomes);
            ++this.outcomes;
            this.adjustFactordimensions();
            return this.outcomes - 1;
        }
        throw new IllegalArgumentException("Outcome already exists");
    }

    public int getOutcomeIndex(String name) {
        return this.outcomeIndices.get(name);
    }

    public String getOutcomeName(int index) {
        return this.outcomeIndices.getKey(index);
    }

    public int getOutcomeCount() {
        return this.outcomes;
    }

    public Factor getFactor() {
        return this.factor;
    }

    public Set<String> getOutcomes() {
        return this.outcomeIndices.keySet();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

