/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.integration.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mvel2.ParserConfiguration;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.BaseVariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.integration.impl.SimpleValueResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassImportResolverFactory
extends BaseVariableResolverFactory {
    private Set<String> packageImports;
    private final ClassLoader classLoader;

    public ClassImportResolverFactory(ParserConfiguration ctx) {
        this.classLoader = ctx.getClassLoader();
        this.variableResolvers = new HashMap();
    }

    public ClassImportResolverFactory(ParserConfiguration ctx, VariableResolverFactory nextFactory) {
        this.packageImports = ctx.getPackageImports();
        Map<String, Object> classes = ctx.getImports();
        this.classLoader = ctx.getClassLoader();
        this.nextFactory = nextFactory;
        this.variableResolvers = new HashMap();
        for (Map.Entry<String, Object> e : classes.entrySet()) {
            this.variableResolvers.put(e.getKey(), new SimpleValueResolver(e.getValue()));
        }
    }

    @Override
    public VariableResolver createVariable(String name, Object value) {
        if (this.nextFactory == null) {
            this.nextFactory = new MapVariableResolverFactory(new HashMap());
        }
        return this.nextFactory.createVariable(name, value);
    }

    public VariableResolver createVariable(String name, Object value, Class type) {
        if (this.nextFactory == null) {
            this.nextFactory = new MapVariableResolverFactory(new HashMap());
        }
        return this.nextFactory.createVariable(name, value);
    }

    public Class addClass(Class clazz) {
        this.variableResolvers.put(clazz.getSimpleName(), new SimpleValueResolver(clazz));
        return clazz;
    }

    @Override
    public boolean isTarget(String name) {
        return this.variableResolvers.containsKey(name);
    }

    @Override
    public boolean isResolveable(String name) {
        if (this.variableResolvers.containsKey(name) || this.isNextResolveable(name)) {
            return true;
        }
        if (this.packageImports != null) {
            for (String s : this.packageImports) {
                try {
                    this.addClass(this.classLoader.loadClass(String.valueOf(s) + "." + name));
                    return true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public void clear() {
        this.variableResolvers.clear();
    }

    public void setImportedClasses(Map<String, Class> imports) {
        if (imports == null) {
            return;
        }
        for (Map.Entry<String, Class> e : imports.entrySet()) {
            this.variableResolvers.put(e.getKey(), new SimpleValueResolver(e.getValue()));
        }
    }

    public Map<String, Object> getImportedClasses() {
        HashMap<String, Object> imports = new HashMap<String, Object>();
        for (Map.Entry e : this.variableResolvers.entrySet()) {
            imports.put((String)e.getKey(), ((VariableResolver)e.getValue()).getValue());
        }
        return imports;
    }

    public void addPackageImport(String packageName) {
        if (this.packageImports == null) {
            this.packageImports = new HashSet<String>();
        }
        this.packageImports.add(packageName);
    }

    @Override
    public Set<String> getKnownVariables() {
        return this.nextFactory == null ? new HashSet(0) : this.nextFactory.getKnownVariables();
    }
}

