/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp;

import com.google.common.base.Optional;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.codeassist.InternalCompletionContext;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnLocalName;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnMemberAccess;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnQualifiedNameReference;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.Region;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.internal.completion.rcp.ProposalCollectingCompletionRequestor;
import org.eclipse.recommenders.rcp.IAstProvider;
import org.eclipse.recommenders.rcp.RecommendersPlugin;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.rcp.CompilerBindings;
import org.eclipse.recommenders.utils.rcp.JdtUtils;

public abstract class BaseRecommendersCompletionContext
implements IRecommendersCompletionContext {
    private final JavaContentAssistInvocationContext javaContext;
    private InternalCompletionContext coreContext;
    private final IAstProvider astProvider;
    private ProposalCollectingCompletionRequestor collector;

    public BaseRecommendersCompletionContext(JavaContentAssistInvocationContext jdtContext, IAstProvider astProvider) {
        this.javaContext = jdtContext;
        this.astProvider = astProvider;
        this.coreContext = (InternalCompletionContext)Checks.cast((Object)jdtContext.getCoreContext());
        this.requestExtendedContext();
    }

    private void requestExtendedContext() {
        ICompilationUnit cu = this.getCompilationUnit();
        this.collector = new ProposalCollectingCompletionRequestor(this.javaContext);
        try {
            cu.codeComplete(this.getInvocationOffset(), (CompletionRequestor)this.collector);
        }
        catch (JavaModelException e) {
            RecommendersPlugin.log((CoreException)e);
        }
        this.coreContext = this.collector.getCoreContext();
    }

    public InternalCompletionContext getCoreContext() {
        return this.coreContext;
    }

    @Override
    public JavaContentAssistInvocationContext getJavaContext() {
        return this.javaContext;
    }

    @Override
    public IJavaProject getProject() {
        return this.javaContext.getProject();
    }

    @Override
    public int getInvocationOffset() {
        return this.javaContext.getInvocationOffset();
    }

    @Override
    public Region getReplacementRange() {
        int offset = this.getInvocationOffset();
        int length = this.getPrefix().length();
        return new Region(offset, length);
    }

    @Override
    public Optional<IMethod> getEnclosingMethod() {
        IJavaElement enclosing = (IJavaElement)this.getEnclosingElement().orNull();
        if (enclosing instanceof IMethod) {
            return Optional.of((Object)((IMethod)enclosing));
        }
        return Optional.absent();
    }

    @Override
    public Optional<IType> getEnclosingType() {
        IJavaElement enclosing = (IJavaElement)this.getEnclosingElement().orNull();
        if (enclosing instanceof IType) {
            return Optional.of((Object)((IType)enclosing));
        }
        return Optional.absent();
    }

    @Override
    public Optional<IJavaElement> getEnclosingElement() {
        try {
            if (this.coreContext.isExtended()) {
                return Optional.fromNullable((Object)this.coreContext.getEnclosingElement());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return Optional.absent();
    }

    @Override
    public boolean hasEnclosingElement() {
        return this.getEnclosingElement().isPresent();
    }

    @Override
    public Optional<IType> getClosestEnclosingType() {
        IJavaElement enclosing;
        if (!this.hasEnclosingElement()) {
            Optional.absent();
        }
        if ((enclosing = (IJavaElement)this.getEnclosingElement().get()) instanceof IType) {
            return Optional.of((Object)((IType)enclosing));
        }
        IType type = (IType)enclosing.getAncestor(7);
        return Optional.fromNullable((Object)type);
    }

    @Override
    public boolean isCompletionInMethodBody() {
        return this.getEnclosingMethod().isPresent();
    }

    @Override
    public boolean isCompletionInTypeBody() {
        return this.getEnclosingType().isPresent();
    }

    @Override
    public ICompilationUnit getCompilationUnit() {
        return this.javaContext.getCompilationUnit();
    }

    @Override
    public CompilationUnit getAST() {
        return this.astProvider.get(this.getCompilationUnit());
    }

    @Override
    public Map<IJavaCompletionProposal, CompletionProposal> getProposals() {
        return this.collector.getProposals();
    }

    @Override
    public Optional<String> getExpectedTypeSignature() {
        char[][] keys = this.coreContext.getExpectedTypesKeys();
        if (keys == null) {
            return Optional.absent();
        }
        if (keys.length < 1) {
            return Optional.absent();
        }
        String res = new String(keys[0]);
        return Optional.of((Object)res);
    }

    @Override
    public Optional<IType> getExpectedType() {
        IType res = this.javaContext.getExpectedType();
        return Optional.fromNullable((Object)res);
    }

    @Override
    public String getPrefix() {
        char[] token = this.coreContext.getToken();
        if (token == null) {
            return "";
        }
        return new String(token);
    }

    @Override
    public String getReceiverName() {
        ASTNode n = this.getCompletionNode();
        char[] name = null;
        if (n instanceof CompletionOnQualifiedNameReference) {
            CompletionOnQualifiedNameReference c = (CompletionOnQualifiedNameReference)Checks.cast((Object)n);
            switch (c.binding.kind()) {
                case 1: 
                case 2: 
                case 3: {
                    VariableBinding b = (VariableBinding)c.binding;
                    name = b.name;
                }
            }
        } else if (n instanceof CompletionOnLocalName) {
            CompletionOnLocalName c = (CompletionOnLocalName)Checks.cast((Object)n);
            name = c.realName;
        } else if (n instanceof CompletionOnSingleNameReference) {
            CompletionOnSingleNameReference c = (CompletionOnSingleNameReference)Checks.cast((Object)n);
            name = c.token;
        } else if (n instanceof CompletionOnMemberAccess) {
            CompletionOnMemberAccess c = (CompletionOnMemberAccess)Checks.cast((Object)n);
            if (c.receiver instanceof ThisReference) {
                name = "this".toCharArray();
            } else if (c.receiver instanceof MessageSend) {
                name = null;
            } else if (c.fieldBinding() != null) {
                name = c.fieldBinding().name;
            } else if (c.localVariableBinding() != null) {
                name = c.localVariableBinding().name;
            }
        }
        return this.toString(name);
    }

    private String toString(char[] name) {
        if (name == null) {
            return "";
        }
        return new String(name).replace(" ", "");
    }

    @Override
    public Optional<String> getReceiverTypeSignature() {
        Optional<TypeBinding> opt = this.findReceiverTypeBinding();
        return this.toString((TypeBinding)opt.orNull());
    }

    private Optional<TypeBinding> findReceiverTypeBinding() {
        ASTNode n = this.getCompletionNode();
        TypeBinding receiver = null;
        if (!(n instanceof CompletionOnLocalName)) {
            if (n instanceof CompletionOnSingleNameReference) {
                CompletionOnSingleNameReference c = (CompletionOnSingleNameReference)Checks.cast((Object)n);
                receiver = c.resolvedType;
            } else if (n instanceof CompletionOnQualifiedNameReference) {
                CompletionOnQualifiedNameReference c = (CompletionOnQualifiedNameReference)Checks.cast((Object)n);
                switch (c.binding.kind()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        VariableBinding varBinding = (VariableBinding)c.binding;
                        receiver = varBinding.type;
                        break;
                    }
                    case 4: {
                        receiver = (TypeBinding)c.binding;
                    }
                }
            } else if (n instanceof CompletionOnMemberAccess) {
                CompletionOnMemberAccess c = (CompletionOnMemberAccess)Checks.cast((Object)n);
                receiver = c.actualReceiverType;
            }
        }
        return Optional.fromNullable(receiver);
    }

    private Optional<String> toString(TypeBinding receiver) {
        if (receiver == null) {
            return Optional.absent();
        }
        String res = new String(receiver.signature());
        return Optional.of((Object)res);
    }

    @Override
    public Optional<IType> getReceiverType() {
        Optional<TypeBinding> opt = this.findReceiverTypeBinding();
        if (!opt.isPresent()) {
            return Optional.absent();
        }
        TypeBinding b = (TypeBinding)opt.get();
        if (b instanceof MissingTypeBinding) {
            return Optional.absent();
        }
        return JdtUtils.createUnresolvedType((TypeBinding)b);
    }

    @Override
    public Optional<IMethodName> getMethodDef() {
        ASTNode node = this.getCompletionNode();
        if (node instanceof CompletionOnMemberAccess) {
            CompletionOnMemberAccess n = (CompletionOnMemberAccess)Checks.cast((Object)node);
            if (n.receiver instanceof MessageSend) {
                MessageSend receiver = (MessageSend)n.receiver;
                MethodBinding binding = receiver.binding;
                return CompilerBindings.toMethodName((MethodBinding)binding);
            }
        }
        return Optional.absent();
    }
}

