/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.history;

import java.util.List;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.spi.GetBuildsRequest;
import org.eclipse.mylyn.builds.internal.core.operations.BuildJob;
import org.eclipse.mylyn.builds.internal.core.operations.GetBuildsOperation;
import org.eclipse.mylyn.builds.internal.core.operations.OperationChangeEvent;
import org.eclipse.mylyn.builds.internal.core.operations.OperationChangeListener;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.mylyn.internal.builds.ui.commands.OpenHandler;
import org.eclipse.mylyn.internal.builds.ui.editor.BuildEditorInput;
import org.eclipse.mylyn.internal.builds.ui.history.BuildHistoryContentProvider;
import org.eclipse.mylyn.internal.builds.ui.view.BuildDurationLabelProvider;
import org.eclipse.mylyn.internal.builds.ui.view.BuildLabelProvider;
import org.eclipse.mylyn.internal.builds.ui.view.BuildSummaryLabelProvider;
import org.eclipse.mylyn.internal.builds.ui.view.BuildTimeLabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class BuildHistoryPage
extends HistoryPage {
    private TreeViewer viewer;
    private BuildHistoryContentProvider contentProvider;
    private GetBuildsOperation refreshOperation;

    public boolean isValidInput(Object object) {
        return BuildHistoryPage.canShowHistoryFor(object);
    }

    public void refresh() {
        this.inputSet();
    }

    public IBuildPlan getPlan() {
        if (this.getInput() instanceof IBuild) {
            return ((IBuild)this.getInput()).getPlan();
        }
        if (this.getInput() instanceof IBuildPlan) {
            return (IBuildPlan)this.getInput();
        }
        if (this.getInput() instanceof BuildEditorInput) {
            return ((BuildEditorInput)this.getInput()).getPlan();
        }
        return null;
    }

    public String getName() {
        IBuildPlan plan = this.getPlan();
        return plan != null ? NLS.bind((String)"Build Plan {0}", (Object)plan.getLabel()) : null;
    }

    public String getDescription() {
        return NLS.bind((String)"Build history for {0}", (Object)this.getName());
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void dispose() {
        this.cancelRefresh();
        super.dispose();
    }

    public boolean inputSet() {
        this.cancelRefresh();
        if (this.viewer == null) {
            return false;
        }
        final IBuildPlan plan = this.getPlan();
        if (plan != null) {
            GetBuildsRequest request = new GetBuildsRequest(plan, GetBuildsRequest.Kind.ALL, GetBuildsRequest.Scope.HISTORY);
            this.refreshOperation = new GetBuildsOperation(BuildsUiInternal.getFactory().getService(), request){

                protected void schedule(List<BuildJob> jobs) {
                    for (BuildJob job : jobs) {
                        BuildHistoryPage.this.schedule((Job)job);
                    }
                }
            };
            this.refreshOperation.addOperationChangeListener(new OperationChangeListener(){

                public void done(OperationChangeEvent event) {
                    if (!event.getStatus().isOK()) {
                        return;
                    }
                    if (Display.getDefault().isDisposed()) {
                        return;
                    }
                    final GetBuildsOperation operation = (GetBuildsOperation)event.getOperation();
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            List builds;
                            if (BuildHistoryPage.this.viewer.getControl() != null && !BuildHistoryPage.this.viewer.getControl().isDisposed() && (builds = operation.getBuilds()) != null) {
                                for (IBuild build : builds) {
                                    build.setPlan(plan);
                                    build.setServer(plan.getServer());
                                }
                                BuildHistoryPage.this.viewer.setInput((Object)builds);
                            }
                        }
                    });
                }
            });
            this.refreshOperation.execute();
            return true;
        }
        return false;
    }

    private void cancelRefresh() {
        if (this.refreshOperation != null) {
            this.refreshOperation.cancel();
            this.refreshOperation = null;
        }
    }

    private IWorkbenchPartSite getWorkbenchSite() {
        IWorkbenchPart part = this.getHistoryPageSite().getPart();
        return part != null ? part.getSite() : null;
    }

    private void schedule(Job job) {
        IWorkbenchSiteProgressService progress;
        IWorkbenchPartSite site = this.getWorkbenchSite();
        if (site != null && (progress = (IWorkbenchSiteProgressService)site.getAdapter(IWorkbenchSiteProgressService.class)) != null) {
            progress.schedule(job, 0L, true);
            return;
        }
        job.schedule();
    }

    public void createControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 65536);
        Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(true);
        TreeViewerColumn buildViewerColumn = new TreeViewerColumn(this.viewer, 16384);
        buildViewerColumn.setLabelProvider((CellLabelProvider)new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new BuildLabelProvider(true), null, null));
        TreeColumn buildColumn = buildViewerColumn.getColumn();
        buildColumn.setText("ID");
        buildColumn.setWidth(70);
        buildColumn.setData("org.eclipse.mylyn.column.viewer.support.column.can.hide", (Object)false);
        TreeViewerColumn timeViewerColumn = new TreeViewerColumn(this.viewer, 16384);
        timeViewerColumn.setLabelProvider((CellLabelProvider)new BuildTimeLabelProvider());
        TreeColumn timeColumn = timeViewerColumn.getColumn();
        timeColumn.setText("Time");
        timeColumn.setWidth(140);
        TreeViewerColumn durationViewerColumn = new TreeViewerColumn(this.viewer, 16384);
        durationViewerColumn.setLabelProvider((CellLabelProvider)new BuildDurationLabelProvider());
        TreeColumn durationColumn = durationViewerColumn.getColumn();
        durationColumn.setText("Duration");
        durationColumn.setWidth(70);
        TreeViewerColumn summaryViewerColumn = new TreeViewerColumn(this.viewer, 16384);
        summaryViewerColumn.setLabelProvider((CellLabelProvider)new BuildSummaryLabelProvider());
        TreeColumn summaryColumn = summaryViewerColumn.getColumn();
        summaryColumn.setText("Summary");
        summaryColumn.setWidth(220);
        this.contentProvider = new BuildHistoryContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object item = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (item instanceof IBuild) {
                    IBuild build = (IBuild)item;
                    OpenHandler.fetchAndOpen(BuildHistoryPage.this.getSite().getPage(), build);
                }
            }
        });
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.getControl().setFocus();
        }
    }

    public static boolean canShowHistoryFor(Object object) {
        return object instanceof IBuildPlan || object instanceof IBuild || object instanceof BuildEditorInput;
    }
}

