/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.logging;

import java.util.Map;
import org.codehaus.plexus.logging.AbstractLoggerManager;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.sonatype.guice.bean.reflect.Weak;
import org.sonatype.guice.plexus.config.Roles;

public abstract class BaseLoggerManager
extends AbstractLoggerManager
implements Initializable {
    private final Map<String, Logger> activeLoggers = Weak.values();
    String threshold = "INFO";
    private int currentThreshold;

    public final void initialize() {
        this.currentThreshold = BaseLoggerManager.parseThreshold(this.threshold);
    }

    public final synchronized Logger getLoggerForComponent(String role, String hint) {
        String name = Roles.canonicalRoleHint((String)role, (String)hint);
        Logger logger = this.activeLoggers.get(name);
        if (null == logger) {
            logger = this.createLogger(name);
            logger.setThreshold(this.currentThreshold);
            this.activeLoggers.put(name, logger);
        }
        return logger;
    }

    public final synchronized void returnComponentLogger(String role, String hint) {
        this.activeLoggers.remove(Roles.canonicalRoleHint((String)role, (String)hint));
    }

    public final int getThreshold() {
        return this.currentThreshold;
    }

    public final void setThreshold(int currentThreshold) {
        this.currentThreshold = currentThreshold;
    }

    public final synchronized void setThresholds(int currentThreshold) {
        this.currentThreshold = currentThreshold;
        for (Logger logger : this.activeLoggers.values()) {
            logger.setThreshold(currentThreshold);
        }
    }

    public static final int parseThreshold(String text) {
        if ("DEBUG".equalsIgnoreCase(text)) {
            return 0;
        }
        if ("INFO".equalsIgnoreCase(text)) {
            return 1;
        }
        if ("WARN".equalsIgnoreCase(text)) {
            return 2;
        }
        if ("ERROR".equalsIgnoreCase(text)) {
            return 3;
        }
        if ("FATAL".equalsIgnoreCase(text)) {
            return 4;
        }
        if ("DISABLED".equalsIgnoreCase(text)) {
            return 5;
        }
        return 0;
    }

    public final synchronized int getActiveLoggerCount() {
        return this.activeLoggers.size();
    }

    protected abstract Logger createLogger(String var1);
}

