/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.mapping;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.egit.core.synchronize.GitCommitsModelCache;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.GitLabelProvider;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCommit;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.team.ui.mapping.SynchronizationLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitChangeSetLabelProvider
extends SynchronizationLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    public static final String BINDING_CHANGESET_SHORT_MESSAGE = "{short_message}";
    public static final String BINDING_CHANGESET_COMMITTER = "{committer}";
    public static final String BINDING_CHANGESET_AUTHOR = "{author}";
    public static final String BINDING_CHANGESET_DATE = "{date}";
    public static final String DEFAULT_CHANGESET_FORMAT = String.format("[%s] (%s) %s", "{author}", "{date}", "{short_message}");
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private IPreferenceStore store = Activator.getDefault().getPreferenceStore();
    private final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(this.store.getString("date_format"));
    private GitLabelProvider delegateLabelProvider;

    protected GitLabelProvider getDelegateLabelProvider() {
        if (this.delegateLabelProvider == null) {
            this.delegateLabelProvider = new GitLabelProvider();
        }
        return this.delegateLabelProvider;
    }

    public StyledString getStyledText(Object element) {
        if (element.getClass().equals(GitModelCommit.class)) {
            String formattedName = this.createChangeSetLabel((GitModelCommit)element);
            StyledString string = new StyledString(formattedName);
            GitModelCommit commit = (GitModelCommit)element;
            String format = " [" + this.getAbbreviatedId(commit) + "]";
            string.append(format, StyledString.DECORATIONS_STYLER);
            return string;
        }
        return this.getDelegateLabelProvider().getStyledText(element);
    }

    private String createChangeSetLabel(GitModelCommit commitModel) {
        String format = this.store.getString("sync_view_changeset_pattern");
        GitCommitsModelCache.Commit commit = commitModel.getCachedCommitObj();
        HashMap<String, String> bindings = new HashMap<String, String>();
        bindings.put(BINDING_CHANGESET_DATE, this.DATE_FORMAT.format(commit.getCommitDate()));
        bindings.put(BINDING_CHANGESET_AUTHOR, commit.getAuthorName());
        bindings.put(BINDING_CHANGESET_COMMITTER, commit.getCommitterName());
        bindings.put(BINDING_CHANGESET_SHORT_MESSAGE, commit.getShortMessage());
        return GitChangeSetLabelProvider.formatName(format, bindings);
    }

    public static String formatName(String format, Map<String, String> bindings) {
        String result = format;
        for (Map.Entry<String, String> e : bindings.entrySet()) {
            result = result.replace(e.getKey(), e.getValue());
        }
        return result;
    }

    private String getAbbreviatedId(GitModelCommit commit) {
        AbbreviatedObjectId shortId = commit.getCachedCommitObj().getId();
        return shortId.name().substring(0, 6);
    }
}

