/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.submodule;

import java.io.File;
import org.eclipse.egit.ui.UIText;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class SubmodulePathWizardPage
extends WizardPage {
    private final Repository repo;
    private Text pathText;
    private String path;

    public SubmodulePathWizardPage(Repository repo) {
        super("pathPage");
        this.repo = repo;
    }

    public void createControl(Composite parent) {
        Composite displayArea = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).applyTo(displayArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)displayArea);
        new Label(displayArea, 0).setText(UIText.SubmodulePathWizardPage_PathLabel);
        this.pathText = new Text(displayArea, 2052);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.pathText);
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SubmodulePathWizardPage.this.validate();
            }
        });
        this.setControl((Control)displayArea);
        this.setTitle(UIText.SubmodulePathWizardPage_Title);
        this.setMessage(UIText.SubmodulePathWizardPage_Message);
        this.setPageComplete(false);
    }

    public String getPath() {
        return this.path;
    }

    private void validate() {
        String[] children;
        String currentPath = this.pathText.getText();
        if (currentPath.length() == 0) {
            this.setPageComplete(false);
            return;
        }
        File file = new File(this.repo.getWorkTree(), currentPath);
        if (file.isFile()) {
            this.setErrorMessage(UIText.SubmodulePathWizardPage_ErrorPathMustBeEmpty);
            this.setPageComplete(false);
            return;
        }
        if (file.isDirectory() && (children = file.list()) != null && children.length > 0) {
            this.setErrorMessage(UIText.SubmodulePathWizardPage_ErrorPathMustBeEmpty);
            this.setPageComplete(false);
            return;
        }
        this.path = currentPath;
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }
}

