/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.staging;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.lib.Repository;

public class StagingEntry
implements IAdaptable {
    private Repository repository;
    private State state;
    private String path;
    private boolean submodule;

    public StagingEntry(Repository repository, State modified, String file) {
        this.repository = repository;
        this.state = modified;
        this.path = file;
    }

    public void setSubmodule(boolean submodule) {
        this.submodule = submodule;
    }

    public boolean isSubmodule() {
        return this.submodule;
    }

    public String getPath() {
        return this.path;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public State getState() {
        return this.state;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IResource.class) {
            IPath absolutePath = new Path(this.repository.getWorkTree().getAbsolutePath()).append(this.path);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile resource = root.getFileForLocation(absolutePath);
            if (resource == null) {
                resource = root.getFile(absolutePath);
            }
            return resource;
        }
        return null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StagingEntry other = (StagingEntry)obj;
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return this.state == other.state;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        ADDED,
        CHANGED,
        REMOVED,
        MISSING,
        MODIFIED,
        PARTIALLY_MODIFIED,
        UNTRACKED,
        CONFLICTING;

    }
}

