/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class RepositoryMatch
extends PlatformObject
implements IWorkbenchAdapter {
    private List<RepositoryCommit> commits = new ArrayList<RepositoryCommit>();
    private Repository repository;

    public RepositoryMatch(Repository repository) {
        Assert.isNotNull((Object)repository, (String)"Repository cannot be null");
        this.repository = repository;
    }

    public int hashCode() {
        return 31 * this.repository.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RepositoryMatch)) {
            return false;
        }
        RepositoryMatch other = (RepositoryMatch)((Object)obj);
        return this.repository.getDirectory().equals(other.repository.getDirectory());
    }

    public Repository getRepository() {
        return this.repository;
    }

    public RepositoryMatch addCommit(RepositoryCommit commit) {
        if (commit != null) {
            this.commits.add(commit);
        }
        return this;
    }

    public int getMatchCount() {
        return this.commits.size();
    }

    public Object[] getChildren(Object o) {
        return this.commits.toArray();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return UIIcons.REPOSITORY;
    }

    public String getLabel(Object o) {
        if (this.repository.isBare()) {
            return this.repository.getDirectory().getName();
        }
        return this.repository.getDirectory().getParentFile().getName();
    }

    public Object getParent(Object o) {
        return null;
    }
}

