/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.SubmoduleUpdateOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.SubmoduleCommand;
import org.eclipse.jgit.lib.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmoduleUpdateCommand
extends SubmoduleCommand<RepositoryTreeNode<?>> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final Map<Repository, List<String>> repoPaths = this.getSubmodules(this.getSelectedNodes(event));
        if (!repoPaths.isEmpty()) {
            Job job = new Job(UIText.SubmoduleUpdateCommand_Title){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask("", repoPaths.size());
                    try {
                        for (Map.Entry entry : repoPaths.entrySet()) {
                            SubmoduleUpdateOperation op = new SubmoduleUpdateOperation((Repository)entry.getKey());
                            if (entry.getValue() != null) {
                                for (String path : (List)entry.getValue()) {
                                    op.addPath(path);
                                }
                            }
                            op.execute((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                    catch (CoreException e) {
                        Activator.logError(UIText.SubmoduleUpdateCommand_UpdateError, e);
                    }
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    if (JobFamilies.SUBMODULE_UPDATE.equals(family)) {
                        return true;
                    }
                    return super.belongsTo(family);
                }
            };
            job.setUser(true);
            job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            job.schedule();
        }
        return null;
    }
}

