/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.StashCreateOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StashCreateCommand
extends RepositoriesViewCommandHandler<RepositoryNode> {
    public static final String ID = "org.eclipse.egit.ui.team.stash.create";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List nodes = this.getSelectedNodes(event);
        if (nodes.isEmpty()) {
            return null;
        }
        Repository repo = ((RepositoryNode)nodes.get(0)).getRepository();
        if (repo == null) {
            return null;
        }
        final Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        InputDialog commitMessageDialog = new InputDialog(shell, UIText.StashCreateCommand_titleEnterCommitMessage, UIText.StashCreateCommand_messageEnterCommitMessage, null, null);
        if (commitMessageDialog.open() != 0) {
            return null;
        }
        String message = commitMessageDialog.getValue();
        if (message.length() == 0) {
            message = null;
        }
        final StashCreateOperation op = new StashCreateOperation(repo, message);
        Job job = new Job(UIText.StashCreateCommand_jobTitle){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("", 1);
                try {
                    op.execute(monitor);
                    RevCommit commit = op.getCommit();
                    if (commit == null) {
                        StashCreateCommand.this.showNoChangesToStash(shell);
                    }
                }
                catch (CoreException e) {
                    Activator.logError(UIText.StashCreateCommand_stashFailed, e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.STASH.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.setRule(op.getSchedulingRule());
        job.schedule();
        return null;
    }

    private void showNoChangesToStash(final Shell shell) {
        shell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)shell, (String)UIText.StashCreateCommand_titleNoChanges, (String)UIText.StashCreateCommand_messageNoChanges);
            }
        });
    }
}

