/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.reflog;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.commit.CommitEditor;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.reflog.RefSelectionDialog;
import org.eclipse.egit.ui.internal.reflog.ReflogViewContentProvider;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.ReflogEntry;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.part.ViewPart;

public class ReflogView
extends ViewPart
implements RefsChangedListener {
    public static final String VIEW_ID = "org.eclipse.egit.ui.ReflogView";
    public static final String POPUP_MENU_ID = "org.eclipse.egit.ui.internal.reflogview.popup";
    private FormToolkit toolkit;
    private Form form;
    private TreeViewer refLogTableTreeViewer;
    private ISelectionListener selectionChangedListener;
    private ListenerHandle addRefsChangedListener;
    private final DateFormat absoluteFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public void createPartControl(Composite parent) {
        IWorkbenchPart part;
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.toolkit = new FormToolkit(parent.getDisplay());
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ReflogView.this.toolkit.dispose();
            }
        });
        this.form = this.toolkit.createForm(parent);
        Image repoImage = UIIcons.REPOSITORY.createImage();
        UIUtils.hookDisposal((Widget)this.form, (Resource)repoImage);
        final Image branchImage = UIIcons.CHANGESET.createImage();
        UIUtils.hookDisposal((Widget)this.form, (Resource)branchImage);
        this.form.setImage(repoImage);
        this.form.setText(UIText.StagingView_NoSelectionTitle);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.form);
        this.toolkit.decorateFormHeading(this.form);
        GridLayoutFactory.fillDefaults().applyTo(this.form.getBody());
        Composite tableComposite = this.toolkit.createComposite(this.form.getBody());
        tableComposite.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComposite);
        final TreeColumnLayout layout = new TreeColumnLayout();
        FilteredTree filteredTree = new FilteredTree(tableComposite, 67584, new PatternFilter(), true){

            protected void createControl(Composite composite, int treeStyle) {
                super.createControl(composite, treeStyle);
                this.treeComposite.setLayout((Layout)layout);
            }
        };
        this.toolkit.adapt((Composite)filteredTree);
        this.refLogTableTreeViewer = filteredTree.getViewer();
        this.refLogTableTreeViewer.getTree().setLinesVisible(true);
        this.refLogTableTreeViewer.getTree().setHeaderVisible(true);
        this.refLogTableTreeViewer.setContentProvider((IContentProvider)new ReflogViewContentProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.refLogTableTreeViewer);
        TreeViewerColumn toColumn = this.createColumn(layout, UIText.ReflogView_CommitColumnHeader, 10, 16384);
        toColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ReflogEntry entry = (ReflogEntry)element;
                return entry.getNewId().abbreviate(7).name();
            }

            public String getToolTipText(Object element) {
                ReflogEntry entry = (ReflogEntry)element;
                return entry.getNewId().name();
            }

            public Image getImage(Object element) {
                return branchImage;
            }
        });
        TreeViewerColumn commitMessageColumn = this.createColumn(layout, UIText.ReflogView_CommitMessageColumnHeader, 40, 16384);
        commitMessageColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ReflogEntry entry = (ReflogEntry)element;
                RevCommit c = this.getCommit(entry);
                return c == null ? "" : c.getShortMessage();
            }

            private RevCommit getCommit(ReflogEntry entry) {
                RevWalk walk = new RevWalk(ReflogView.this.getRepository());
                walk.setRetainBody(true);
                RevCommit c = null;
                try {
                    try {
                        c = walk.parseCommit((AnyObjectId)entry.getNewId());
                    }
                    catch (IOException iOException) {
                        walk.release();
                    }
                }
                finally {
                    walk.release();
                }
                return c;
            }
        });
        TreeViewerColumn dateColumn = this.createColumn(layout, UIText.ReflogView_DateColumnHeader, 15, 16384);
        dateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ReflogEntry entry = (ReflogEntry)element;
                PersonIdent who = entry.getWho();
                return ReflogView.this.absoluteFormatter.format(who.getWhen());
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        TreeViewerColumn messageColumn = this.createColumn(layout, UIText.ReflogView_MessageColumnHeader, 40, 16384);
        messageColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            private ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

            public String getText(Object element) {
                ReflogEntry entry = (ReflogEntry)element;
                return entry.getComment();
            }

            public Image getImage(Object element) {
                String comment = ((ReflogEntry)element).getComment();
                if (comment.startsWith("commit:") || comment.startsWith("commit (initial):")) {
                    return (Image)this.resourceManager.get((DeviceResourceDescriptor)UIIcons.COMMIT);
                }
                if (comment.startsWith("commit (amend):")) {
                    return (Image)this.resourceManager.get((DeviceResourceDescriptor)UIIcons.AMEND_COMMIT);
                }
                if (comment.startsWith("pull")) {
                    return (Image)this.resourceManager.get((DeviceResourceDescriptor)UIIcons.PULL);
                }
                if (comment.startsWith("clone")) {
                    return (Image)this.resourceManager.get((DeviceResourceDescriptor)UIIcons.CLONEGIT);
                }
                if (comment.startsWith("rebase")) {
                    return (Image)this.resourceManager.get((DeviceResourceDescriptor)UIIcons.REBASE);
                }
                if (comment.startsWith("merge")) {
                    return (Image)this.resourceManager.get((DeviceResourceDescriptor)UIIcons.MERGE);
                }
                if (comment.startsWith("fetch")) {
                    return (Image)this.resourceManager.get((DeviceResourceDescriptor)UIIcons.FETCH);
                }
                if (comment.startsWith("branch")) {
                    return (Image)this.resourceManager.get((DeviceResourceDescriptor)UIIcons.CREATE_BRANCH);
                }
                if (comment.startsWith("checkout")) {
                    return (Image)this.resourceManager.get((DeviceResourceDescriptor)UIIcons.CHECKOUT);
                }
                return null;
            }

            public void dispose() {
                this.resourceManager.dispose();
                super.dispose();
            }
        });
        this.refLogTableTreeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                Repository repo = ReflogView.this.getRepository();
                if (repo == null) {
                    return;
                }
                RevWalk walk = new RevWalk(repo);
                try {
                    try {
                        Object[] objectArray = selection.toArray();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object element = objectArray[n2];
                            ReflogEntry entry = (ReflogEntry)element;
                            ObjectId id = entry.getNewId();
                            if (id == null || id.equals((AnyObjectId)ObjectId.zeroId())) {
                                id = entry.getOldId();
                            }
                            if (id != null && !id.equals((AnyObjectId)ObjectId.zeroId())) {
                                CommitEditor.openQuiet(new RepositoryCommit(repo, walk.parseCommit((AnyObjectId)id)));
                            }
                            ++n2;
                        }
                    }
                    catch (IOException e) {
                        Activator.logError(UIText.ReflogView_ErrorOnOpenCommit, e);
                        walk.release();
                    }
                }
                finally {
                    walk.release();
                }
            }
        });
        this.selectionChangedListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (part instanceof IEditorPart) {
                    IEditorInput input = ((IEditorPart)part).getEditorInput();
                    if (input instanceof IFileEditorInput) {
                        ReflogView.this.reactOnSelection((ISelection)new StructuredSelection((Object)((IFileEditorInput)input).getFile()));
                    }
                } else {
                    ReflogView.this.reactOnSelection(selection);
                }
            }
        };
        IWorkbenchPartSite site = this.getSite();
        ISelectionService service = (ISelectionService)site.getService(ISelectionService.class);
        service.addPostSelectionListener(this.selectionChangedListener);
        ISelection selection = service.getSelection();
        if (selection != null && !selection.isEmpty() && (part = site.getPage().getActivePart()) != null) {
            this.selectionChangedListener.selectionChanged(part, selection);
        }
        site.setSelectionProvider((ISelectionProvider)this.refLogTableTreeViewer);
        this.addRefsChangedListener = Repository.getGlobalListenerList().addRefsChangedListener((RefsChangedListener)this);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IContributionItem)new Separator("additions"));
        Tree tree = this.refLogTableTreeViewer.getTree();
        tree.setMenu(menuManager.createContextMenu((Control)tree));
        this.getSite().registerContextMenu(POPUP_MENU_ID, menuManager, (ISelectionProvider)this.refLogTableTreeViewer);
    }

    public void setFocus() {
        this.refLogTableTreeViewer.getControl().setFocus();
        this.activateContextService();
    }

    private void activateContextService() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext(VIEW_ID);
        }
    }

    public void dispose() {
        super.dispose();
        ISelectionService service = (ISelectionService)this.getSite().getService(ISelectionService.class);
        service.removePostSelectionListener(this.selectionChangedListener);
        if (this.addRefsChangedListener != null) {
            this.addRefsChangedListener.remove();
        }
    }

    private void reactOnSelection(ISelection selection) {
        IResource adapted;
        IResource resource;
        RepositoryMapping mapping;
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ssel = (IStructuredSelection)selection;
        if (ssel.size() != 1) {
            return;
        }
        Repository selectedRepo = null;
        Object first = ssel.getFirstElement();
        if (first instanceof IResource && (mapping = RepositoryMapping.getMapping((IResource)(resource = (IResource)ssel.getFirstElement()).getProject())) != null) {
            selectedRepo = mapping.getRepository();
        }
        if (selectedRepo == null && first instanceof IAdaptable && (adapted = (IResource)((IAdaptable)ssel.getFirstElement()).getAdapter(IResource.class)) != null && (mapping = RepositoryMapping.getMapping((IResource)adapted)) != null) {
            selectedRepo = mapping.getRepository();
        }
        if (selectedRepo == null && first instanceof RepositoryTreeNode) {
            RepositoryTreeNode repoNode = (RepositoryTreeNode)ssel.getFirstElement();
            selectedRepo = repoNode.getRepository();
        }
        if (selectedRepo == null) {
            return;
        }
        Repository currentRepo = this.getRepository();
        if (currentRepo == null || !selectedRepo.getDirectory().equals(currentRepo.getDirectory())) {
            this.showReflogFor(selectedRepo);
        }
    }

    private void updateRefLink(final String name) {
        IToolBarManager toolbar = this.form.getToolBarManager();
        toolbar.removeAll();
        ControlContribution refLabelControl = new ControlContribution("refLabel"){

            protected Control createControl(Composite cParent) {
                Composite composite = ReflogView.this.toolkit.createComposite(cParent);
                composite.setLayout((Layout)new RowLayout());
                composite.setBackground(null);
                final ImageHyperlink refLink = new ImageHyperlink(composite, 0);
                Image image = UIIcons.BRANCH.createImage();
                UIUtils.hookDisposal((Widget)refLink, (Resource)image);
                refLink.setImage(image);
                refLink.setFont(JFaceResources.getBannerFont());
                refLink.setForeground(ReflogView.this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
                refLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent event) {
                        Repository repository = ReflogView.this.getRepository();
                        if (repository == null) {
                            return;
                        }
                        RefSelectionDialog dialog = new RefSelectionDialog(refLink.getShell(), repository);
                        if (dialog.open() == 0) {
                            ReflogView.this.showReflogFor(repository, dialog.getRefName());
                        }
                    }
                });
                refLink.setText(Repository.shortenRefName((String)name));
                return composite;
            }
        };
        toolbar.add((IContributionItem)refLabelControl);
        toolbar.update(true);
    }

    public Repository getRepository() {
        Object input = this.refLogTableTreeViewer.getInput();
        if (input instanceof ReflogViewContentProvider.ReflogInput) {
            return ((ReflogViewContentProvider.ReflogInput)input).getRepository();
        }
        return null;
    }

    public void showReflogFor(Repository repository) {
        this.showReflogFor(repository, "HEAD");
    }

    private void showReflogFor(Repository repository, String ref) {
        if (repository != null && ref != null) {
            this.refLogTableTreeViewer.setInput((Object)new ReflogViewContentProvider.ReflogInput(repository, ref));
            this.updateRefLink(ref);
            this.form.setText(ReflogView.getRepositoryName(repository));
        }
    }

    private TreeViewerColumn createColumn(TreeColumnLayout columnLayout, String text, int weight, int style) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this.refLogTableTreeViewer, style);
        TreeColumn column = viewerColumn.getColumn();
        column.setText(text);
        columnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(weight, 10));
        return viewerColumn;
    }

    private static String getRepositoryName(Repository repository) {
        String repoName = Activator.getDefault().getRepositoryUtil().getRepositoryName(repository);
        RepositoryState state = repository.getRepositoryState();
        if (state != RepositoryState.SAFE) {
            return String.valueOf(repoName) + '|' + state.getDescription();
        }
        return repoName;
    }

    public void onRefsChanged(RefsChangedEvent event) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                ReflogView.this.refLogTableTreeViewer.refresh();
            }
        });
    }

    public ISelectionProvider getSelectionProvider() {
        return this.refLogTableTreeViewer;
    }
}

