/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.core.op.DeleteBranchOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.dialogs.AbstractBranchSelectionDialog;
import org.eclipse.egit.ui.internal.dialogs.UnmergedBranchDialog;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteBranchDialog
extends AbstractBranchSelectionDialog {
    private final Set<Ref> selectedRefs = new HashSet<Ref>();
    private String currentBranch;

    public DeleteBranchDialog(Shell parentShell, Repository repo) {
        super(parentShell, repo, 326);
        try {
            this.currentBranch = repo.getFullBranch();
        }
        catch (IOException iOException) {}
    }

    @Override
    protected String getMessageText() {
        return UIText.DeleteBranchDialog_DialogMessage;
    }

    @Override
    protected String getTitle() {
        return UIText.DeleteBranchDialog_DialogTitle;
    }

    @Override
    protected String getWindowTitle() {
        return UIText.DeleteBranchDialog_WindowTitle;
    }

    @Override
    protected String refNameFromDialog() {
        this.selectedRefs.clear();
        HashSet<String> selected = new HashSet<String>();
        IStructuredSelection selection = (IStructuredSelection)this.branchTree.getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object sel = objectArray[n2];
            if (sel instanceof RefNode) {
                RefNode node = (RefNode)sel;
                Ref ref = (Ref)node.getObject();
                this.selectedRefs.add(ref);
                selected.add(ref.getName());
            }
            ++n2;
        }
        boolean enabled = !selected.isEmpty() && !selected.contains(this.currentBranch);
        this.getButton(0).setEnabled(enabled);
        return null;
    }

    @Override
    protected void refNameSelected(String refName) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            try {
                int result = this.deleteBranch(this.selectedRefs, false);
                if (result == 2) {
                    List<RefNode> nodes = this.extractSelectedRefNodes();
                    UnmergedBranchDialog<RefNode> messageDialog = new UnmergedBranchDialog<RefNode>(this.getShell(), nodes);
                    if (messageDialog.open() != 0) return;
                    this.deleteBranch(this.selectedRefs, true);
                } else if (result == 1) {
                    Activator.handleError(UIText.DeleteBranchCommand_CannotDeleteCheckedOutBranch, null, true);
                }
            }
            catch (CoreException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
        }
        super.buttonPressed(buttonId);
    }

    private int deleteBranch(Set<Ref> ref, boolean force) throws CoreException {
        DeleteBranchOperation dbop = new DeleteBranchOperation(this.repo, ref, force);
        dbop.execute(null);
        return dbop.getStatus();
    }

    private List<RefNode> extractSelectedRefNodes() {
        Object[] array;
        ArrayList<RefNode> nodes = new ArrayList<RefNode>();
        Object[] objectArray = array = ((IStructuredSelection)this.branchTree.getSelection()).toArray();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object selected = objectArray[n2];
            if (selected instanceof RefNode) {
                nodes.add((RefNode)selected);
            }
            ++n2;
        }
        return nodes;
    }
}

