/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.IOException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class BranchConfigurationDialog
extends TitleAreaDialog {
    private final String myBranchName;
    private final Repository myRepository;
    private final StoredConfig myConfig;
    private final String myTitle;
    private Combo branchText;
    private Combo remoteText;
    private Button rebase;

    public BranchConfigurationDialog(Shell shell, String branchName, Repository repository) {
        super(shell);
        this.myBranchName = branchName;
        this.myRepository = repository;
        this.myConfig = this.myRepository.getConfig();
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        this.myTitle = UIText.BranchConfigurationDialog_BranchConfigurationTitle;
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(main);
        GridDataFactory.fillDefaults().grab(true, false).indent(5, 5).applyTo((Control)main);
        Label branchLabel = new Label(main, 0);
        branchLabel.setText(UIText.BranchConfigurationDialog_UpstreamBranchLabel);
        this.branchText = new Combo(main, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.branchText);
        try {
            for (Ref ref : this.myRepository.getRefDatabase().getRefs("refs/heads/").values()) {
                this.branchText.add(ref.getName());
            }
            for (Ref ref : this.myRepository.getRefDatabase().getRefs("refs/remotes/").values()) {
                this.branchText.add(ref.getName());
            }
        }
        catch (IOException e) {
            Activator.logError(UIText.BranchConfigurationDialog_ExceptionGettingRefs, e);
        }
        Label remoteLabel = new Label(main, 0);
        remoteLabel.setText(UIText.BranchConfigurationDialog_RemoteLabel);
        this.remoteText = new Combo(main, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.remoteText);
        this.remoteText.add(".");
        for (String remote : this.myConfig.getSubsections("remote")) {
            this.remoteText.add(remote);
        }
        this.rebase = new Button(main, 32);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.rebase);
        this.rebase.setText(UIText.BranchConfigurationDialog_RebaseLabel);
        String branch = this.myConfig.getString("branch", this.myBranchName, "merge");
        if (branch == null) {
            branch = "";
        }
        this.branchText.setText(branch);
        String remote = this.myConfig.getString("branch", this.myBranchName, "remote");
        if (remote == null) {
            remote = "";
        }
        this.remoteText.setText(remote);
        boolean rebaseFlag = this.myConfig.getBoolean("branch", this.myBranchName, "rebase", false);
        this.rebase.setSelection(rebaseFlag);
        BranchConfigurationDialog.applyDialogFont((Control)main);
        return main;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.BranchConfigurationDialog_BranchConfigurationTitle);
    }

    public void create() {
        super.create();
        this.setTitle(this.myTitle);
        this.setMessage(NLS.bind((String)UIText.BranchConfigurationDialog_EditBranchConfigMessage, (Object)this.myBranchName));
    }

    protected void okPressed() {
        try {
            String merge = this.branchText.getText();
            if (merge.length() > 0) {
                this.myConfig.setString("branch", this.myBranchName, "merge", merge);
            } else {
                this.myConfig.unset("branch", this.myBranchName, "merge");
            }
            String remote = this.remoteText.getText();
            if (remote.length() > 0) {
                this.myConfig.setString("branch", this.myBranchName, "remote", remote);
            } else {
                this.myConfig.unset("branch", this.myBranchName, "remote");
            }
            boolean rebaseFlag = this.rebase.getSelection();
            if (rebaseFlag) {
                this.myConfig.setBoolean("branch", this.myBranchName, "rebase", true);
            } else {
                this.myConfig.unset("branch", this.myBranchName, "rebase");
            }
            try {
                this.myConfig.save();
                super.okPressed();
            }
            catch (IOException e) {
                Activator.handleError(UIText.BranchConfigurationDialog_SaveBranchConfigFailed, e, true);
            }
        }
        catch (RuntimeException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
    }
}

