/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.decorators.DecoratableResource;
import org.eclipse.egit.ui.internal.decorators.DecoratableResourceHelper;
import org.eclipse.egit.ui.internal.decorators.IDecoratableResource;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jgit.lib.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DecoratableResourceAdapter
extends DecoratableResource {
    private final RepositoryMapping mapping;
    private final Repository repository;
    private final boolean trace;
    private IndexDiffData indexDiffData;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DecoratableResourceAdapter(IndexDiffData indexDiffData, IResource resourceToWrap) throws IOException {
        super(resourceToWrap);
        this.indexDiffData = indexDiffData;
        this.trace = GitTraceLocation.DECORATION.isActive();
        long start = 0L;
        if (this.trace) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.DECORATION.getLocation(), "Decorate " + this.resource.getFullPath());
            start = System.currentTimeMillis();
        }
        try {
            this.mapping = RepositoryMapping.getMapping((IResource)this.resource);
            if (this.mapping == null) {
                this.repository = null;
                return;
            }
            this.repository = this.mapping.getRepository();
            if (this.repository == null) {
                return;
            }
            this.repositoryName = DecoratableResourceHelper.getRepositoryName(this.repository);
            this.branch = DecoratableResourceHelper.getShortBranch(this.repository);
            this.branchStatus = DecoratableResourceHelper.getBranchStatus(this.repository);
            switch (this.resource.getType()) {
                case 1: {
                    this.extractResourceProperties();
                    return;
                }
                case 4: {
                    this.tracked = true;
                }
                case 2: {
                    this.extractContainerProperties();
                }
            }
            return;
        }
        finally {
            if (this.trace) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.DECORATION.getLocation(), "Decoration took " + (System.currentTimeMillis() - start) + " ms");
            }
        }
    }

    public String toString() {
        return "DecoratableResourceAdapter[" + this.getName() + (this.isTracked() ? ", tracked" : "") + (this.isIgnored() ? ", ignored" : "") + (this.isDirty() ? ", dirty" : "") + (this.hasConflicts() ? ",conflicts" : "") + ", staged=" + (Object)((Object)this.staged) + "]";
    }

    private void extractResourceProperties() {
        String repoRelativePath = this.makeRepoRelative(this.resource);
        Set ignoredFiles = this.indexDiffData.getIgnoredNotInIndex();
        this.ignored = ignoredFiles.contains(repoRelativePath) || this.containsPrefixPath(ignoredFiles, repoRelativePath);
        Set untracked = this.indexDiffData.getUntracked();
        this.tracked = !untracked.contains(repoRelativePath) && !this.ignored;
        Set added = this.indexDiffData.getAdded();
        Set removed = this.indexDiffData.getRemoved();
        Set changed = this.indexDiffData.getChanged();
        this.staged = added.contains(repoRelativePath) ? IDecoratableResource.Staged.ADDED : (removed.contains(repoRelativePath) ? IDecoratableResource.Staged.REMOVED : (changed.contains(repoRelativePath) ? IDecoratableResource.Staged.MODIFIED : IDecoratableResource.Staged.NOT_STAGED));
        Set conflicting = this.indexDiffData.getConflicting();
        this.conflicts = conflicting.contains(repoRelativePath);
        Set modified = this.indexDiffData.getModified();
        this.dirty = modified.contains(repoRelativePath);
    }

    private void extractContainerProperties() {
        String repoRelativePath = String.valueOf(this.makeRepoRelative(this.resource)) + "/";
        Set ignoredFiles = this.indexDiffData.getIgnoredNotInIndex();
        Set untrackedFolders = this.indexDiffData.getUntrackedFolders();
        this.ignored = this.containsPrefixPath(ignoredFiles, repoRelativePath);
        this.tracked = this.ignored ? false : !this.containsPrefixPath(untrackedFolders, repoRelativePath);
        HashSet<String> changed = new HashSet<String>(this.indexDiffData.getChanged());
        changed.addAll(this.indexDiffData.getAdded());
        changed.addAll(this.indexDiffData.getRemoved());
        this.staged = this.containsPrefix(changed, repoRelativePath) ? IDecoratableResource.Staged.MODIFIED : IDecoratableResource.Staged.NOT_STAGED;
        Set conflicting = this.indexDiffData.getConflicting();
        this.conflicts = this.containsPrefix(conflicting, repoRelativePath);
        Set modified = this.indexDiffData.getModified();
        Set untracked = this.indexDiffData.getUntracked();
        this.dirty = this.containsPrefix(modified, repoRelativePath) || this.containsPrefix(untracked, repoRelativePath);
    }

    private String makeRepoRelative(IResource res) {
        return Repository.stripWorkDir((File)this.repository.getWorkTree(), (File)res.getLocation().toFile());
    }

    private boolean containsPrefix(Set<String> collection, String prefix) {
        if (prefix.length() == 1 && !collection.isEmpty()) {
            return true;
        }
        for (String path : collection) {
            if (!path.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean containsPrefixPath(Set<String> collection, String path) {
        for (String entry : collection) {
            String entryPath = entry.endsWith("/") ? entry : String.valueOf(entry) + "/";
            if (!path.startsWith(entryPath)) continue;
            return true;
        }
        return false;
    }
}

