/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit.command;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.RevertCommitOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.commit.command.CommitCommandHandler;
import org.eclipse.egit.ui.internal.dialogs.RevertFailureDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RevertHandler
extends CommitCommandHandler {
    public static final String ID = "org.eclipse.egit.ui.commit.Revert";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<RepositoryCommit> commits = this.getCommits(event);
        if (commits.size() == 1) {
            RepositoryCommit repoCommit = commits.get(0);
            final RevCommit commit = repoCommit.getRevCommit();
            Repository repo = repoCommit.getRepository();
            final Shell shell = this.getPart(event).getSite().getShell();
            final RevertCommitOperation op = new RevertCommitOperation(repo, commit);
            Job job = new Job(MessageFormat.format(UIText.RevertHandler_JobName, commit.name())){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        op.execute(monitor);
                        RevCommit newHead = op.getNewHead();
                        List revertedRefs = op.getRevertedRefs();
                        if (newHead != null && revertedRefs.isEmpty()) {
                            RevertHandler.showRevertedDialog(shell);
                        }
                        if (newHead == null) {
                            RevertHandler.showFailureDialog(shell, commit, op.getFailingResult());
                        }
                    }
                    catch (CoreException e) {
                        Activator.handleError(UIText.RevertOperation_InternalError, e, true);
                    }
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    if (JobFamilies.REVERT_COMMIT.equals(family)) {
                        return true;
                    }
                    return super.belongsTo(family);
                }
            };
            job.setUser(true);
            job.setRule(op.getSchedulingRule());
            job.schedule();
            return null;
        }
        return null;
    }

    private static void showFailureDialog(final Shell shell, final RevCommit commit, final MergeResult result) {
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                RevertFailureDialog.show(shell, commit, result);
            }
        });
    }

    private static void showRevertedDialog(final Shell shell) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openWarning((Shell)shell, (String)UIText.RevertHandler_NoRevertTitle, (String)UIText.RevertHandler_AlreadyRevertedMessage);
            }
        });
    }
}

