/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commands.shared;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractSharedCommandHandler
extends AbstractHandler {
    private static final IWorkbench WORKBENCH = PlatformUI.getWorkbench();

    public static Repository getRepository(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        return AbstractSharedCommandHandler.getRepository(selection);
    }

    protected static Repository getRepository(ISelection selection) {
        RepositoryMapping mapping;
        IEditorInput activeEditor;
        IResource resource;
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            Repository result = null;
            for (Object element : ssel.toList()) {
                IResource adapted;
                RepositoryMapping mapping2;
                Repository elementRepository = null;
                if (element instanceof RepositoryTreeNode) {
                    elementRepository = ((RepositoryTreeNode)element).getRepository();
                } else if (element instanceof IResource) {
                    IResource resource2 = (IResource)element;
                    mapping2 = RepositoryMapping.getMapping((IResource)resource2.getProject());
                    if (mapping2 != null) {
                        elementRepository = mapping2.getRepository();
                    }
                } else if (element instanceof IAdaptable && (adapted = (IResource)((IAdaptable)element).getAdapter(IResource.class)) != null && (mapping2 = RepositoryMapping.getMapping((IResource)adapted.getProject())) != null) {
                    elementRepository = mapping2.getRepository();
                }
                if (elementRepository == null) continue;
                if (result != null && !elementRepository.equals(result)) {
                    return null;
                }
                if (result != null) continue;
                result = elementRepository;
            }
            return result;
        }
        if (selection instanceof TextSelection && (resource = (IResource)(activeEditor = WORKBENCH.getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput()).getAdapter(IResource.class)) != null && (mapping = RepositoryMapping.getMapping((IResource)resource)) != null) {
            return mapping.getRepository();
        }
        return null;
    }

    protected Ref getRef(Object selected) {
        RepositoryTreeNode node;
        if (selected instanceof RepositoryTreeNode && (node = (RepositoryTreeNode)selected).getType() == RepositoryTreeNodeType.REF) {
            return (Ref)((RefNode)node).getObject();
        }
        return null;
    }

    protected Shell getShell(ExecutionEvent event) {
        return HandlerUtil.getActiveShell((ExecutionEvent)event);
    }
}

