/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.FollowFilter;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.ResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class RepositoryActionHandler
extends AbstractHandler {
    private IEvaluationContext evaluationContext;
    private IStructuredSelection mySelection;

    RepositoryActionHandler() {
    }

    public void setSelection(ISelection selection) {
        this.mySelection = this.convertSelection(null, selection);
    }

    private IProject[] getProjectsForSelectedResources(IStructuredSelection selection) {
        LinkedHashSet<IProject> ret = new LinkedHashSet<IProject>();
        IResource[] iResourceArray = (IResource[])this.getSelectedAdaptables((ISelection)selection, IResource.class);
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            ret.add(resource.getProject());
            ++n2;
        }
        ret.addAll(this.extractProjectsFromMappings(selection));
        return ret.toArray(new IProject[ret.size()]);
    }

    private Set<IProject> extractProjectsFromMappings(IStructuredSelection selection) {
        LinkedHashSet<IProject> ret = new LinkedHashSet<IProject>();
        ResourceMapping[] resourceMappingArray = (ResourceMapping[])this.getSelectedAdaptables((ISelection)selection, ResourceMapping.class);
        int n = resourceMappingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            IProject[] projects = mapping.getProjects();
            if (projects != null) {
                ret.addAll(Arrays.asList(projects));
            }
            ++n2;
        }
        return ret;
    }

    protected IProject[] getProjectsForSelectedResources(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection(event);
        return this.getProjectsForSelectedResources(selection);
    }

    protected IProject[] getProjectsForSelectedResources() {
        IStructuredSelection selection = this.getSelection();
        return this.getProjectsForSelectedResources(selection);
    }

    protected Repository[] getRepositoriesFor(IProject[] projects) {
        LinkedHashSet<Repository> ret = new LinkedHashSet<Repository>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryMapping repositoryMapping = RepositoryMapping.getMapping((IResource)project);
            if (repositoryMapping == null) {
                return new Repository[0];
            }
            ret.add(repositoryMapping.getRepository());
            ++n2;
        }
        return ret.toArray(new Repository[ret.size()]);
    }

    protected IProject[] getProjectsInRepositoryOfSelectedResources(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection(event);
        return this.getProjectsInRepositoryOfSelectedResources(selection);
    }

    protected IProject[] getProjectsInRepositoryOfSelectedResources() {
        IStructuredSelection selection = this.getSelection();
        return this.getProjectsInRepositoryOfSelectedResources(selection);
    }

    private IProject[] getProjectsInRepositoryOfSelectedResources(IStructuredSelection selection) {
        IProject[] projects;
        LinkedHashSet<IProject> ret = new LinkedHashSet<IProject>();
        Repository[] repositories = this.getRepositoriesFor(this.getProjectsForSelectedResources(selection));
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)project);
            Repository[] repositoryArray = repositories;
            int n3 = repositories.length;
            int n4 = 0;
            while (n4 < n3) {
                Repository repository = repositoryArray[n4];
                if (mapping != null && mapping.getRepository() == repository) {
                    ret.add(project);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return ret.toArray(new IProject[ret.size()]);
    }

    protected Repository getRepository(boolean warn, ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection(event);
        Shell shell = this.getShell(event);
        return this.getRepository(warn, selection, shell);
    }

    protected Repository getRepository() {
        IStructuredSelection selection = this.getSelection();
        return this.getRepository(false, selection, null);
    }

    private Repository getRepository(boolean warn, IStructuredSelection selection, Shell shell) {
        RepositoryMapping mapping = null;
        IResource[] iResourceArray = this.getSelectedResources(selection);
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            RepositoryMapping repositoryMapping = RepositoryMapping.getMapping((IResource)resource);
            if (mapping == null) {
                mapping = repositoryMapping;
            }
            if (repositoryMapping == null) {
                return null;
            }
            if (mapping.getRepository() != repositoryMapping.getRepository()) {
                if (warn) {
                    MessageDialog.openError((Shell)shell, (String)UIText.RepositoryAction_multiRepoSelectionTitle, (String)UIText.RepositoryAction_multiRepoSelection);
                }
                return null;
            }
            ++n2;
        }
        Repository result = null;
        if (mapping == null) {
            Object[] objectArray = selection.toArray();
            int n3 = objectArray.length;
            n = 0;
            while (n < n3) {
                Object o = objectArray[n];
                Repository nextRepo = null;
                if (o instanceof Repository) {
                    nextRepo = (Repository)o;
                } else if (o instanceof PlatformObject) {
                    nextRepo = (Repository)((PlatformObject)o).getAdapter(Repository.class);
                }
                if (nextRepo != null && result != null && !result.equals(nextRepo)) {
                    if (warn) {
                        MessageDialog.openError((Shell)shell, (String)UIText.RepositoryAction_multiRepoSelectionTitle, (String)UIText.RepositoryAction_multiRepoSelection);
                    }
                    return null;
                }
                result = nextRepo;
                ++n;
            }
        } else {
            result = mapping.getRepository();
        }
        if (result == null) {
            if (warn) {
                MessageDialog.openError((Shell)shell, (String)UIText.RepositoryAction_errorFindingRepoTitle, (String)UIText.RepositoryAction_errorFindingRepo);
            }
            return null;
        }
        return result;
    }

    protected Repository[] getRepositories(ExecutionEvent event) throws ExecutionException {
        IProject[] selectedProjects = this.getProjectsForSelectedResources(event);
        if (selectedProjects.length > 0) {
            return this.getRepositoriesFor(selectedProjects);
        }
        IStructuredSelection selection = this.getSelection(event);
        if (!selection.isEmpty()) {
            LinkedHashSet<Repository> repos = new LinkedHashSet<Repository>();
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Repository repo;
                Object o = objectArray[n2];
                if (o instanceof Repository) {
                    repos.add((Repository)o);
                } else if (o instanceof PlatformObject && (repo = (Repository)((PlatformObject)o).getAdapter(Repository.class)) != null) {
                    repos.add(repo);
                }
                ++n2;
            }
            return repos.toArray(new Repository[repos.size()]);
        }
        return new Repository[0];
    }

    protected Repository[] getRepositories() {
        IProject[] selectedProjects = this.getProjectsForSelectedResources();
        if (selectedProjects.length > 0) {
            return this.getRepositoriesFor(selectedProjects);
        }
        IStructuredSelection selection = this.getSelection();
        if (!selection.isEmpty()) {
            LinkedHashSet<Repository> repos = new LinkedHashSet<Repository>();
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Repository repo;
                Object o = objectArray[n2];
                if (o instanceof Repository) {
                    repos.add((Repository)o);
                } else if (o instanceof PlatformObject && (repo = (Repository)((PlatformObject)o).getAdapter(Repository.class)) != null) {
                    repos.add(repo);
                }
                ++n2;
            }
            return repos.toArray(new Repository[repos.size()]);
        }
        return new Repository[0];
    }

    protected IStructuredSelection getSelection(ExecutionEvent event) throws ExecutionException {
        if (event == null) {
            throw new IllegalArgumentException("event must not be NULL");
        }
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (selection == null) {
            selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        }
        if (selection instanceof TextSelection) {
            IEditorInput editorInput = (IEditorInput)HandlerUtil.getVariable((ExecutionEvent)event, (String)"activeEditorInput");
            IResource resource = ResourceUtil.getResource((IEditorInput)editorInput);
            if (resource != null) {
                return new StructuredSelection((Object)resource);
            }
            resource = ResourceUtil.getFile((IEditorInput)editorInput);
            if (resource != null) {
                return new StructuredSelection((Object)resource);
            }
        }
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    protected IStructuredSelection getSelection() {
        if (this.mySelection != null) {
            return this.mySelection;
        }
        return this.convertSelection(this.evaluationContext, null);
    }

    private IStructuredSelection convertSelection(IEvaluationContext aContext, Object aSelection) {
        Object selection;
        if (aContext == null && aSelection == null) {
            return StructuredSelection.EMPTY;
        }
        IEvaluationContext ctx = aContext;
        if (aSelection == null && ctx != null) {
            selection = ctx.getVariable("activeMenuSelection");
            if (!(selection instanceof ISelection)) {
                selection = ctx.getVariable("selection");
            }
        } else if (aSelection != null) {
            selection = aSelection;
        } else {
            return StructuredSelection.EMPTY;
        }
        if (selection instanceof TextSelection) {
            IResource resource;
            if (ctx == null) {
                ctx = this.getEvaluationContext();
            }
            if ((resource = ResourceUtil.getResource((Object)ctx.getVariable("activeEditorInput"))) != null) {
                return new StructuredSelection((Object)resource);
            }
        }
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    public void setEnabled(Object evaluationContext) {
        this.evaluationContext = (IEvaluationContext)evaluationContext;
    }

    private IEvaluationContext getEvaluationContext() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IHandlerService hsr = (IHandlerService)activeWorkbenchWindow.getService(IHandlerService.class);
        IEvaluationContext ctx = hsr.getCurrentState();
        return ctx;
    }

    private Object[] getSelectedAdaptables(ISelection selection, Class c) {
        ArrayList<Object> result = null;
        if (selection != null && !selection.isEmpty()) {
            result = new ArrayList<Object>();
            Iterator elements = ((IStructuredSelection)selection).iterator();
            while (elements.hasNext()) {
                Object adapter = this.getAdapter(elements.next(), c);
                if (!c.isInstance(adapter)) continue;
                result.add(adapter);
            }
        }
        if (result != null && !result.isEmpty()) {
            return result.toArray((Object[])Array.newInstance(c, result.size()));
        }
        return (Object[])Array.newInstance(c, 0);
    }

    private Object getAdapter(Object adaptable, Class c) {
        IAdaptable a;
        Object adapter;
        if (c.isInstance(adaptable)) {
            return adaptable;
        }
        if (adaptable instanceof IAdaptable && c.isInstance(adapter = (a = (IAdaptable)adaptable).getAdapter(c))) {
            return adapter;
        }
        return null;
    }

    protected IResource[] getSelectedResources(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection(event);
        return this.getSelectedResources(selection);
    }

    protected IResource[] getSelectedResources() {
        IStructuredSelection selection = this.getSelection();
        return this.getSelectedResources(selection);
    }

    private IResource[] getSelectedResources(IStructuredSelection selection) {
        LinkedHashSet<IResource> result = new LinkedHashSet<IResource>();
        for (Object o : selection.toList()) {
            IResource resource = (IResource)this.getAdapter(o, IResource.class);
            if (resource != null) {
                result.add(resource);
                continue;
            }
            this.extractResourcesFromMapping(result, o);
        }
        return result.toArray(new IResource[result.size()]);
    }

    private void extractResourcesFromMapping(Set<IResource> result, Object o) {
        ResourceMapping mapping = (ResourceMapping)this.getAdapter(o, ResourceMapping.class);
        if (mapping != null) {
            try {
                ResourceTraversal[] traversals;
                ResourceTraversal[] resourceTraversalArray = traversals = mapping.getTraversals(null, null);
                int n = traversals.length;
                int n2 = 0;
                while (n2 < n) {
                    ResourceTraversal traversal = resourceTraversalArray[n2];
                    IResource[] resources = traversal.getResources();
                    result.addAll(Arrays.asList(resources));
                    ++n2;
                }
            }
            catch (CoreException e) {
                Activator.logError(e.getMessage(), e);
            }
        }
    }

    protected Shell getShell(ExecutionEvent event) throws ExecutionException {
        return HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
    }

    protected IWorkbenchPage getPartPage(ExecutionEvent event) throws ExecutionException {
        return this.getPart(event).getSite().getPage();
    }

    protected IWorkbenchPart getPart(ExecutionEvent event) throws ExecutionException {
        return HandlerUtil.getActivePartChecked((ExecutionEvent)event);
    }

    protected boolean canMerge(Repository repository, ExecutionEvent event) throws ExecutionException {
        String message = null;
        try {
            Ref head = repository.getRef("HEAD");
            if (head == null || !head.isSymbolic()) {
                message = UIText.MergeAction_HeadIsNoBranch;
            } else if (!repository.getRepositoryState().equals((Object)RepositoryState.SAFE)) {
                message = NLS.bind((String)UIText.MergeAction_WrongRepositoryState, (Object)repository.getRepositoryState());
            }
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
            message = e.getMessage();
        }
        if (message != null) {
            MessageDialog.openError((Shell)this.getShell(event), (String)UIText.MergeAction_CannotMerge, (String)message);
        }
        return message == null;
    }

    protected boolean containsHead(Repository repository) {
        try {
            return repository != null ? repository.resolve("HEAD") != null : false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean isLocalBranchCheckedout(Repository repository) {
        try {
            return repository.getFullBranch().startsWith("refs/heads/");
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected String getPreviousPath(Repository repository, ObjectReader reader, RevCommit headCommit, RevCommit previousCommit, String path) throws IOException {
        TreeWalk walk = new TreeWalk(reader);
        walk.setRecursive(true);
        walk.addTree((AnyObjectId)previousCommit.getTree());
        walk.addTree((AnyObjectId)headCommit.getTree());
        List entries = DiffEntry.scan((TreeWalk)walk);
        if (entries.size() < 2) {
            return path;
        }
        for (DiffEntry diff : entries) {
            if (diff.getChangeType() != DiffEntry.ChangeType.MODIFY || !path.equals(diff.getNewPath())) continue;
            return path;
        }
        RenameDetector detector = new RenameDetector(repository);
        detector.addAll((Collection)entries);
        List renames = detector.compute(walk.getObjectReader(), (ProgressMonitor)NullProgressMonitor.INSTANCE);
        for (DiffEntry diff : renames) {
            if (diff.getChangeType() != DiffEntry.ChangeType.RENAME || !path.equals(diff.getNewPath())) continue;
            return diff.getOldPath();
        }
        return path;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<PreviousCommit> findPreviousCommits() throws IOException {
        ArrayList<PreviousCommit> result = new ArrayList<PreviousCommit>();
        Repository repository = this.getRepository();
        IResource resource = this.getSelectedResources()[0];
        String path = RepositoryMapping.getMapping((IResource)resource.getProject()).getRepoRelativePath(resource);
        RevWalk rw = new RevWalk(repository);
        try {
            block10: {
                RevCommit previousCommit;
                List<RevCommit> directParents;
                RevCommit headCommit;
                block9: {
                    if (path.length() > 0) {
                        FollowFilter filter = FollowFilter.create((String)path);
                        rw.setTreeFilter((TreeFilter)filter);
                    }
                    headCommit = rw.parseCommit((AnyObjectId)repository.getRef("HEAD").getObjectId());
                    rw.markStart(headCommit);
                    headCommit = rw.next();
                    if (headCommit == null) {
                        ArrayList<PreviousCommit> arrayList = result;
                        return arrayList;
                    }
                    directParents = Arrays.asList(headCommit.getParents());
                    previousCommit = rw.next();
                    if (!true) break block9;
                    if (previousCommit == null) return result;
                    if (result.size() >= directParents.size()) break block10;
                }
                do {
                    if (directParents.contains(previousCommit)) {
                        String previousPath = this.getPreviousPath(repository, rw.getObjectReader(), headCommit, previousCommit, path);
                        result.add(new PreviousCommit(previousCommit, previousPath));
                    }
                    previousCommit = rw.next();
                    if (previousCommit == null) return result;
                } while (result.size() < directParents.size());
            }
            return result;
        }
        finally {
            rw.dispose();
        }
    }

    protected static final class PreviousCommit {
        final RevCommit commit;
        final String path;

        PreviousCommit(RevCommit commit, String path) {
            this.commit = commit;
            this.path = path;
        }
    }
}

