/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearOutgoingAction
extends Action {
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.mark.discard";
    private final List<IRepositoryElement> selectedElements;
    private AbstractTaskEditorPage taskEditorPage;

    public ClearOutgoingAction(List<IRepositoryElement> selectedElements) {
        this.selectedElements = selectedElements;
        this.setText(Messages.ClearOutgoingAction_Clear_outgoing);
        this.setToolTipText(Messages.ClearOutgoingAction_Clear_outgoing);
        this.setImageDescriptor(CommonImages.CLEAR);
        this.setId(ID);
        if (selectedElements.size() == 1 && selectedElements.get(0) instanceof ITask) {
            ITask task = (ITask)selectedElements.get(0);
            this.setEnabled(ClearOutgoingAction.hasOutgoingChanges(task));
        } else {
            this.setEnabled(false);
        }
    }

    public AbstractTaskEditorPage getTaskEditorPage() {
        return this.taskEditorPage;
    }

    public void setTaskEditorPage(AbstractTaskEditorPage taskEditorPage) {
        this.taskEditorPage = taskEditorPage;
    }

    public static boolean hasOutgoingChanges(ITask task) {
        return task.getSynchronizationState().equals((Object)ITask.SynchronizationState.OUTGOING) || task.getSynchronizationState().equals((Object)ITask.SynchronizationState.CONFLICT);
    }

    public void run() {
        ArrayList<AbstractTask> toClear = new ArrayList<AbstractTask>();
        for (IRepositoryElement selectedObject : this.selectedElements) {
            if (!(selectedObject instanceof ITask) || !ClearOutgoingAction.hasOutgoingChanges((ITask)selectedObject)) continue;
            toClear.add((AbstractTask)selectedObject);
        }
        if (toClear.size() > 0) {
            AbstractTask task = (AbstractTask)toClear.get(0);
            boolean confirm = MessageDialog.openConfirm(null, (String)Messages.ClearOutgoingAction_Confirm_discard, (String)(String.valueOf(Messages.ClearOutgoingAction_Discard_all_outgoing_changes_) + "\n\n" + task.getSummary()));
            if (confirm) {
                if (this.taskEditorPage != null) {
                    this.taskEditorPage.doSave(null);
                }
                try {
                    TasksUi.getTaskDataManager().discardEdits((ITask)task);
                }
                catch (CoreException e) {
                    TasksUiInternal.displayStatus(Messages.ClearOutgoingAction_Clear_outgoing_failed, e.getStatus());
                }
            }
        }
    }
}

