/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ITasksCoreConstants;
import org.eclipse.mylyn.internal.tasks.core.TaskActivationHistory;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.externalization.AbstractExternalizationParticipant;
import org.eclipse.mylyn.internal.tasks.core.externalization.ExternalizationManager;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivationListener;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class TaskActivationExternalizationParticipant
extends AbstractExternalizationParticipant
implements ITaskActivationListener {
    private final ExternalizationManager externalizationManager;
    private boolean dirty;
    private final TaskActivationHistory activationHistory;
    private final File file;
    private final TaskList taskList;

    public TaskActivationExternalizationParticipant(ExternalizationManager externalizationManager, TaskList taskList, TaskActivationHistory history, File file) {
        this.externalizationManager = externalizationManager;
        this.taskList = taskList;
        this.activationHistory = history;
        this.file = file;
    }

    public String getDescription() {
        return Messages.TaskActivationExternalizationParticipant_Task_Activation_History;
    }

    public ISchedulingRule getSchedulingRule() {
        return ITasksCoreConstants.ACTIVITY_SCHEDULING_RULE;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestSave() {
        TaskActivationExternalizationParticipant taskActivationExternalizationParticipant = this;
        synchronized (taskActivationExternalizationParticipant) {
            this.dirty = true;
        }
        this.externalizationManager.requestSave();
    }

    public void load(File sourceFile, IProgressMonitor monitor) throws CoreException {
        block7: {
            try {
                this.activationHistory.clear();
                if (!this.file.exists()) break block7;
                FileReader reader = new FileReader(this.file);
                try {
                    IMemento[] items;
                    XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                    IMemento[] iMementoArray = items = memento.getChildren("task");
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractTask task;
                        IMemento child = iMementoArray[n2];
                        String handle = child.getString("handle");
                        if (handle != null && (task = this.taskList.getTask(handle)) != null) {
                            this.activationHistory.addTaskInternal(task);
                        }
                        ++n2;
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to load task activation history", (Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File targetFile, IProgressMonitor monitor) throws CoreException {
        TaskActivationExternalizationParticipant taskActivationExternalizationParticipant = this;
        synchronized (taskActivationExternalizationParticipant) {
            this.dirty = false;
        }
        XMLMemento memento = XMLMemento.createWriteRoot((String)"taskActivationHistory");
        for (AbstractTask task : this.activationHistory.getPreviousTasks()) {
            IMemento child = memento.createChild("task");
            child.putString("handle", task.getHandleIdentifier());
        }
        try {
            this.file.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(this.file);
            try {
                memento.save((Writer)writer);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to save task activation history", (Throwable)e));
        }
    }

    public String getFileName() {
        return this.file.getName();
    }

    public File getFile(String rootPath) throws CoreException {
        return this.file;
    }

    public void preTaskActivated(ITask task) {
    }

    public void preTaskDeactivated(ITask task) {
    }

    public void taskActivated(ITask task) {
        this.activationHistory.addTask((AbstractTask)task);
        this.requestSave();
    }

    public void taskDeactivated(ITask task) {
    }
}

