/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.addons;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.Parameter;
import org.eclipse.e4.ui.model.LocalizationHelper;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.MCategory;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MCommandParameter;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class CommandProcessingAddon {
    @Inject
    private ECommandService commandService;
    @Inject
    private CommandManager commandManager;
    @Inject
    private MApplication application;
    @Inject
    private IEventBroker broker;
    private Category undefinedCategory;
    private EventHandler additionHandler;

    @PostConstruct
    public void init() {
        Activator.trace("/trace/commands", "Initialize commands from model", null);
        this.undefinedCategory = this.commandService.defineCategory(MApplication.class.getName(), "Application Category", null);
        this.createCategories();
        this.createCommands();
        this.registerModelListeners();
    }

    @PreDestroy
    public void dispose() {
        this.unregsiterModelListeners();
    }

    private void registerModelListeners() {
        this.additionHandler = new EventHandler(){

            public void handleEvent(Event event) {
                if (CommandProcessingAddon.this.application == event.getProperty("ChangedElement") && "ADD".equals(event.getProperty("EventType"))) {
                    Object obj = event.getProperty("NewValue");
                    if (obj instanceof MCommand) {
                        CommandProcessingAddon.this.createCommand((MCommand)obj);
                    } else if (obj instanceof MCategory) {
                        CommandProcessingAddon.this.createCategory((MCategory)obj);
                    }
                }
            }
        };
        this.broker.subscribe("org/eclipse/e4/ui/model/application/Application/commands/*", this.additionHandler);
        this.broker.subscribe("org/eclipse/e4/ui/model/application/Application/categories/*", this.additionHandler);
    }

    private void unregsiterModelListeners() {
        this.broker.unsubscribe(this.additionHandler);
        this.broker.unsubscribe(this.additionHandler);
    }

    private void createCommands() {
        for (MCommand cmdModel : this.application.getCommands()) {
            this.createCommand(cmdModel);
        }
    }

    private void createCommand(MCommand cmdModel) {
        IParameter[] parms = null;
        String id = cmdModel.getElementId();
        String name = this.localize(cmdModel.getCommandName(), (MApplicationElement)cmdModel);
        String desc = this.localize(cmdModel.getDescription(), (MApplicationElement)cmdModel);
        List modelParms = cmdModel.getParameters();
        if (modelParms != null && !modelParms.isEmpty()) {
            ArrayList<Parameter> parmList = new ArrayList<Parameter>();
            for (MCommandParameter cmdParm : modelParms) {
                ParameterType parameterType = null;
                if (cmdParm.getTypeId() != null && cmdParm.getTypeId().length() > 0) {
                    parameterType = this.commandManager.getParameterType(cmdParm.getTypeId());
                }
                parmList.add(new Parameter(cmdParm.getElementId(), cmdParm.getName(), null, parameterType, cmdParm.isOptional()));
            }
            parms = parmList.toArray(new Parameter[parmList.size()]);
        }
        Category cat = this.undefinedCategory;
        if (cmdModel.getCategory() != null) {
            cat = this.commandService.getCategory(cmdModel.getCategory().getElementId());
        }
        this.commandService.defineCommand(id, name, desc, cat, parms);
    }

    private void createCategories() {
        for (MCategory catModel : this.application.getCategories()) {
            this.createCategory(catModel);
        }
    }

    private void createCategory(MCategory catModel) {
        Category category = this.commandService.getCategory(catModel.getElementId());
        if (!category.isDefined()) {
            category.define(this.localize(catModel.getName(), (MApplicationElement)catModel), this.localize(catModel.getDescription(), (MApplicationElement)catModel));
        }
    }

    private String localize(String key, MApplicationElement modelElement) {
        if (key == null) {
            return null;
        }
        String localized = LocalizationHelper.getLocalized((String)key, (MApplicationElement)modelElement);
        return localized == null ? key : localized;
    }
}

