/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.binders;

import com.google.inject.Binder;
import com.google.inject.ImplementedBy;
import com.google.inject.Key;
import com.google.inject.ProvidedBy;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Qualifier;
import org.sonatype.guice.bean.binders.BeanEntryProvider;
import org.sonatype.guice.bean.binders.BeanListProvider;
import org.sonatype.guice.bean.binders.BeanMapProvider;
import org.sonatype.guice.bean.binders.BeanProvider;
import org.sonatype.guice.bean.binders.BeanSetProvider;
import org.sonatype.guice.bean.binders.NamedBeanMapProvider;
import org.sonatype.guice.bean.binders.PlaceholderBeanProvider;
import org.sonatype.guice.bean.binders.Wiring;
import org.sonatype.guice.bean.locators.BeanLocator;
import org.sonatype.guice.bean.locators.HiddenBinding;
import org.sonatype.guice.bean.locators.Implicit;
import org.sonatype.guice.bean.reflect.TypeParameters;
import org.sonatype.inject.BeanEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocatorWiring
implements Wiring {
    private static final HiddenBinding HIDDEN_SOURCE = new HiddenBinding(){

        public String toString() {
            return LocatorWiring.class.getName();
        }
    };
    private final Binder binder;

    LocatorWiring(Binder binder) {
        this.binder = binder.withSource((Object)HIDDEN_SOURCE);
    }

    @Override
    public boolean wire(Key<?> key) {
        Class clazz = key.getTypeLiteral().getRawType();
        if (Map.class == clazz) {
            this.bindMapImport(key);
        } else if (List.class == clazz || Iterable.class == clazz) {
            this.bindListImport(key);
        } else if (Set.class == clazz) {
            this.bindSetImport(key);
        } else if (!LocatorWiring.isRestricted(clazz)) {
            this.bindBeanImport(key);
        }
        return true;
    }

    private void bindMapImport(Key<?> key) {
        TypeLiteral[] parameters = TypeParameters.get((TypeLiteral)key.getTypeLiteral());
        if (2 == parameters.length && null == key.getAnnotation()) {
            Class qualifierType = parameters[0].getRawType();
            if (String.class == qualifierType) {
                this.binder.bind(key).toProvider(new NamedBeanMapProvider(parameters[1]));
            } else if (qualifierType.isAnnotationPresent(Qualifier.class)) {
                this.binder.bind(key).toProvider(new BeanMapProvider(Key.get((TypeLiteral)parameters[1], (Class)qualifierType)));
            }
        }
    }

    private void bindListImport(Key<?> key) {
        TypeLiteral[] parameters = TypeParameters.get((TypeLiteral)key.getTypeLiteral());
        if (1 == parameters.length && null == key.getAnnotation()) {
            TypeLiteral elementType = parameters[0];
            if (BeanEntry.class == elementType.getRawType()) {
                Class qualifierType;
                parameters = TypeParameters.get((TypeLiteral)elementType);
                if (2 == parameters.length && (qualifierType = parameters[0].getRawType()).isAnnotationPresent(Qualifier.class)) {
                    this.binder.bind(key).toProvider(new BeanEntryProvider(Key.get((TypeLiteral)parameters[1], (Class)qualifierType)));
                }
            } else {
                this.binder.bind(key).toProvider(new BeanListProvider(Key.get((TypeLiteral)elementType)));
            }
        }
    }

    private void bindSetImport(Key<?> key) {
        TypeLiteral[] parameters = TypeParameters.get((TypeLiteral)key.getTypeLiteral());
        if (1 == parameters.length && null == key.getAnnotation()) {
            this.binder.bind(key).toProvider(new BeanSetProvider(Key.get((TypeLiteral)parameters[0])));
        }
    }

    private <T> void bindBeanImport(Key<T> key) {
        Annotation qualifier = key.getAnnotation();
        if (qualifier instanceof Named) {
            if (((Named)qualifier).value().length() == 0) {
                this.binder.bind(key).toProvider(new BeanProvider(Key.get((TypeLiteral)key.getTypeLiteral(), Named.class)));
            } else {
                this.binder.bind(key).toProvider(new PlaceholderBeanProvider<T>(key));
            }
        } else {
            this.binder.bind(key).toProvider(new BeanProvider<T>(key));
            if (null == key.getAnnotationType()) {
                this.bindImplicitType(key.getTypeLiteral());
            }
        }
    }

    private void bindImplicitType(TypeLiteral type) {
        try {
            Class clazz = type.getRawType();
            if (TypeParameters.isConcrete((Class)clazz)) {
                Member ctor = InjectionPoint.forConstructorOf((TypeLiteral)type).getMember();
                this.binder.bind(Key.get((Class)clazz, Implicit.class)).toConstructor((Constructor)ctor);
            } else {
                ImplementedBy implementedBy = clazz.getAnnotation(ImplementedBy.class);
                if (null != implementedBy) {
                    this.binder.bind(Key.get((Class)clazz, Implicit.class)).to(implementedBy.value());
                } else {
                    ProvidedBy providedBy = clazz.getAnnotation(ProvidedBy.class);
                    if (null != providedBy) {
                        this.binder.bind(Key.get((Class)clazz, Implicit.class)).toProvider(providedBy.value());
                    }
                }
            }
        }
        catch (RuntimeException e) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
    }

    private static boolean isRestricted(Class<?> clazz) {
        return "org.slf4j.Logger".equals(clazz.getName()) || BeanLocator.class.isAssignableFrom(clazz);
    }
}

