/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.overrides;

import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;
import java.util.zip.ZipEntry;
import org.eclipse.jdt.core.IType;
import org.eclipse.recommenders.internal.completion.rcp.overrides.ClassOverridesNetwork;
import org.eclipse.recommenders.internal.completion.rcp.overrides.ClassOverridesNetworkBuilder;
import org.eclipse.recommenders.internal.completion.rcp.overrides.ClassOverridesObservation;
import org.eclipse.recommenders.internal.rcp.models.archive.ZipPoolableModelFactory;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.gson.GsonUtil;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.rcp.JavaElementResolver;

public final class OverridesZipModelFactory
extends ZipPoolableModelFactory<IType, ClassOverridesNetwork> {
    private JavaElementResolver jdtResolver;

    public OverridesZipModelFactory(File zip, JavaElementResolver jdtResolver) throws IOException {
        super(zip);
        this.jdtResolver = jdtResolver;
    }

    public boolean hasModel(IType key) {
        return this.getEntry(key) != null;
    }

    private ZipEntry getEntry(IType jType) {
        ITypeName rType = this.toRecName(jType);
        String name = String.valueOf(rType.getIdentifier().substring(1)) + ".json";
        return this.zip.getEntry(name);
    }

    private ITypeName toRecName(IType jType) {
        ITypeName rType = this.jdtResolver.toRecType(jType);
        return rType;
    }

    public ClassOverridesNetwork createModel(IType key) throws IOException {
        ClassOverridesNetwork classOverridesNetwork;
        InputStream is = null;
        try {
            ClassOverridesNetwork network;
            ITypeName typeName = this.toRecName(key);
            is = this.zip.getInputStream(this.getEntry(key));
            Type listType = new TypeToken<List<ClassOverridesObservation>>(){}.getType();
            List observations = (List)GsonUtil.deserialize((InputStream)is, (Type)listType);
            if (observations.size() == 0) {
                observations.add(new ClassOverridesObservation());
            }
            ClassOverridesNetworkBuilder b = new ClassOverridesNetworkBuilder(typeName, observations);
            b.createPatternsNode();
            b.createMethodNodes();
            classOverridesNetwork = network = b.build();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)is);
        return classOverridesNetwork;
    }

    public void activateModel(IType key, ClassOverridesNetwork model) {
        model.clearEvidence();
    }
}

