/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.overrides;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContextFactory;
import org.eclipse.recommenders.internal.completion.rcp.overrides.ClassOverridesNetwork;
import org.eclipse.recommenders.internal.completion.rcp.overrides.OverridesRecommendation;
import org.eclipse.recommenders.internal.rcp.models.IModelArchiveStore;
import org.eclipse.recommenders.internal.utils.codestructs.MethodDeclaration;
import org.eclipse.recommenders.internal.utils.codestructs.TypeDeclaration;
import org.eclipse.recommenders.rcp.RecommendersPlugin;
import org.eclipse.recommenders.utils.Tuple;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmMethodName;
import org.eclipse.recommenders.utils.rcp.CompletionProposalDecorator;
import org.eclipse.recommenders.utils.rcp.JavaElementResolver;
import org.eclipse.recommenders.utils.rcp.JdtUtils;

public class OverridesCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    private final double MIN_PROBABILITY_THRESHOLD = 0.1;
    private final IRecommendersCompletionContextFactory ctxFactory;
    private IModelArchiveStore<IType, ClassOverridesNetwork> modelStore;
    private final JavaElementResolver jdtCache;
    private IRecommendersCompletionContext ctx;
    private IType enclosingType;
    private IType supertype;
    private List<OverridesRecommendation> recommendations;
    private List<IJavaCompletionProposal> proposals;
    private ClassOverridesNetwork model;

    @Inject
    public OverridesCompletionProposalComputer(IModelArchiveStore<IType, ClassOverridesNetwork> modelStore, IRecommendersCompletionContextFactory ctxFactory, JavaElementResolver jdtCache) {
        this.modelStore = modelStore;
        this.ctxFactory = ctxFactory;
        this.jdtCache = jdtCache;
    }

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        this.initializeContexts(context);
        if (!this.findEnclosingType()) {
            return Collections.emptyList();
        }
        if (!this.findSuperclass()) {
            return Collections.emptyList();
        }
        if (!this.hasModel()) {
            return Collections.emptyList();
        }
        try {
            try {
                this.computeRecommendations();
                this.computeProposals();
            }
            catch (Exception e) {
                RecommendersPlugin.logError((Exception)e, (String)"Exception caught in overrides completion proposal computer.", (Object[])new Object[0]);
                List list = Collections.emptyList();
                this.releaseModel();
                return list;
            }
        }
        finally {
            this.releaseModel();
        }
        return this.proposals;
    }

    private void releaseModel() {
        if (this.model != null) {
            this.modelStore.releaseModel((Object)this.model);
        }
    }

    private void initializeContexts(ContentAssistInvocationContext context) {
        this.ctx = this.ctxFactory.create((JavaContentAssistInvocationContext)context);
    }

    private boolean findEnclosingType() {
        this.enclosingType = (IType)this.ctx.getEnclosingType().orNull();
        return this.enclosingType != null;
    }

    private boolean findSuperclass() {
        this.supertype = (IType)JdtUtils.findSuperclass((IType)this.enclosingType).orNull();
        return this.supertype != null;
    }

    private boolean hasModel() {
        this.model = (ClassOverridesNetwork)this.modelStore.aquireModel((Object)this.supertype).orNull();
        return this.model != null;
    }

    private void computeRecommendations() throws JavaModelException {
        TypeDeclaration query = this.computeQuery();
        for (MethodDeclaration method : query.methods) {
            this.model.observeMethodNode(method.superDeclaration);
        }
        this.recommendations = this.readRecommendations();
    }

    private List<OverridesRecommendation> readRecommendations() {
        LinkedList res = Lists.newLinkedList();
        for (Tuple tuple : this.model.getRecommendedMethodOverrides(0.1, 5)) {
            IMethodName method = (IMethodName)tuple.getFirst();
            Double probability = (Double)tuple.getSecond();
            OverridesRecommendation recommendation = new OverridesRecommendation(method, probability);
            res.add(recommendation);
        }
        return res;
    }

    private TypeDeclaration computeQuery() throws JavaModelException {
        TypeDeclaration query = TypeDeclaration.create(null, (ITypeName)this.jdtCache.toRecType(this.supertype));
        IMethod[] iMethodArray = this.enclosingType.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod m = iMethodArray[n2];
            Optional superMethod = JdtUtils.findOverriddenMethod((IMethod)m);
            if (superMethod.isPresent()) {
                IMethodName recMethod = (IMethodName)this.jdtCache.toRecMethod(m).or((Object)VmMethodName.NULL);
                IMethodName recSuperMethod = (IMethodName)this.jdtCache.toRecMethod((IMethod)superMethod.get()).or((Object)VmMethodName.NULL);
                MethodDeclaration create = MethodDeclaration.create((IMethodName)recMethod);
                create.superDeclaration = recSuperMethod;
                query.methods.add(create);
            }
            ++n2;
        }
        return query;
    }

    private void computeProposals() {
        this.proposals = Lists.newLinkedList();
        String prefix = this.ctx.getPrefix();
        block3: for (Map.Entry pair : this.ctx.getProposals().entrySet()) {
            IJavaCompletionProposal uiProposal = (IJavaCompletionProposal)pair.getKey();
            CompletionProposal cProposal = (CompletionProposal)pair.getValue();
            switch (cProposal.getKind()) {
                case 7: {
                    String signature = String.valueOf(cProposal.getSignature()).replace('.', '/');
                    String name = String.valueOf(cProposal.getName());
                    String propSignature = (String.valueOf(name) + signature).replaceAll("<\\.>", "");
                    for (OverridesRecommendation r : this.recommendations) {
                        String recSignature;
                        if (!r.method.getName().startsWith(prefix) || !(recSignature = r.method.getSignature()).equals(propSignature)) continue;
                        if (uiProposal instanceof AbstractJavaCompletionProposal) {
                            int baseRelevance = uiProposal.getRelevance();
                            ((AbstractJavaCompletionProposal)uiProposal).setRelevance(baseRelevance += (int)Math.rint(r.probability * 100.0));
                        }
                        CompletionProposalDecorator decoratedProposal = new CompletionProposalDecorator(uiProposal, r.probability);
                        this.proposals.add((IJavaCompletionProposal)decoratedProposal);
                    }
                    continue block3;
                }
            }
        }
    }

    public void sessionStarted() {
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }
}

