/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.overrides;

import com.google.inject.Inject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.jdt.core.IType;
import org.eclipse.recommenders.internal.completion.rcp.overrides.ClassOverridesNetwork;
import org.eclipse.recommenders.internal.completion.rcp.overrides.OverridesModule;
import org.eclipse.recommenders.internal.completion.rcp.overrides.OverridesZipModelFactory;
import org.eclipse.recommenders.internal.rcp.models.IModelArchive;
import org.eclipse.recommenders.internal.rcp.models.ModelArchiveMetadata;
import org.eclipse.recommenders.internal.rcp.models.archive.IModelFactory;
import org.eclipse.recommenders.internal.rcp.models.archive.PoolingModelArchive;
import org.eclipse.recommenders.internal.rcp.models.store.DefaultModelArchiveStore;
import org.eclipse.recommenders.internal.rcp.models.store.IDependenciesFactory;
import org.eclipse.recommenders.internal.rcp.models.store.ModelArchiveResolutionJob;
import org.eclipse.recommenders.internal.rcp.wiring.RecommendersModule;
import org.eclipse.recommenders.rcp.IClasspathEntryInfoProvider;
import org.eclipse.recommenders.rcp.repo.IModelRepository;
import org.eclipse.recommenders.rcp.repo.IModelRepositoryIndex;
import org.eclipse.recommenders.utils.rcp.JavaElementResolver;

public class ManualModelStoreWiring {

    @RecommendersModule.AutoCloseOnWorkbenchShutdown
    static class OverridesModelArchiveStore
    extends DefaultModelArchiveStore<IType, ClassOverridesNetwork> {
        private static final String CLASSIFIER = "ovrm";

        @Inject
        public OverridesModelArchiveStore(@OverridesModule.OverridesModelStore File store, final IModelRepository repository, final IModelRepositoryIndex searchindex, final IClasspathEntryInfoProvider cpeInfoProvider, final JavaElementResolver jdtResolver) {
            super(store, CLASSIFIER, repository, new IDependenciesFactory(){

                public ModelArchiveResolutionJob newResolutionJob(ModelArchiveMetadata metadata, String classifier) {
                    return new ModelArchiveResolutionJob(metadata, cpeInfoProvider, repository, searchindex, OverridesModelArchiveStore.CLASSIFIER);
                }

                public IModelArchive<IType, ClassOverridesNetwork> newModelArchive(File location) throws IOException {
                    if (!location.exists()) {
                        throw new FileNotFoundException("Model file not found: " + location.getAbsolutePath());
                    }
                    return new PoolingModelArchive((IModelFactory)new OverridesZipModelFactory(location, jdtResolver));
                }
            });
        }
    }
}

