/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.chain.ui;

import com.google.common.base.Joiner;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.recommenders.internal.completion.rcp.chain.ChainCompletionPlugin;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ChainPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID_MAX_CHAINS = "recommenders.chain.max_chains";
    public static final String ID_MAX_DEPTH = "recommenders.chain.max_chain_length";
    public static final String ID_TIMEOUT = "recommenders.chain.timeout";
    public static final String ID_IGNORE_TYPES = "recommenders.chain.ignore_types";
    public static final char IGNORE_TYPES_SEPARATOR = '|';

    public ChainPreferencePage() {
        super(1);
        this.setPreferenceStore(ChainCompletionPlugin.getDefault().getPreferenceStore());
        this.setDescription("Call chains offer ways to obtain objects of the requested type by calling multiple methods in a row. Since those chains can become long and time-consuming to search, the following options allow to limit the proposals.");
    }

    protected void createFieldEditors() {
        this.addField(ID_MAX_CHAINS, "Maximum number of chains:", 1, 99);
        this.addField(ID_MAX_DEPTH, "Maximum chain depth:", 2, 99);
        this.addField(ID_TIMEOUT, "Chain search timeout (sec):", 1, 99);
        this.addField((FieldEditor)new IgnoredTypesEditor("Return types to ignore:", this.getFieldEditorParent()));
    }

    private void addField(String name, String labeltext, int min, int max) {
        IntegerFieldEditor field = new IntegerFieldEditor(name, labeltext, this.getFieldEditorParent());
        field.setValidRange(min, max);
        this.addField((FieldEditor)field);
    }

    public void init(IWorkbench workbench) {
    }

    private static final class IgnoredTypesEditor
    extends ListEditor {
        private IgnoredTypesEditor(String label, Composite parent) {
            super(ChainPreferencePage.ID_IGNORE_TYPES, label, parent);
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            super.doFillIntoGrid(parent, numColumns);
        }

        protected String[] parseString(String stringList) {
            this.getUpButton().setVisible(false);
            this.getDownButton().setVisible(false);
            return stringList.split("\\|");
        }

        protected String getNewInputObject() {
            SelectionDialog dialog;
            block3: {
                try {
                    dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)new ProgressMonitorDialog(this.getShell()), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)256, (boolean)false);
                    if (dialog.open() != 1) break block3;
                    return null;
                }
                catch (JavaModelException e) {
                    Throws.throwIllegalArgumentException((String)e.getMessage());
                    return null;
                }
            }
            return ((IType)dialog.getResult()[0]).getFullyQualifiedName();
        }

        protected String createList(String[] items) {
            return Joiner.on((char)'|').join((Object[])items);
        }
    }
}

