/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.chain;

import com.google.common.base.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.rcp.JdtUtils;
import org.eclipse.recommenders.utils.rcp.internal.RecommendersUtilsPlugin;

public class MemberEdge {
    private final IJavaElement element;
    private Optional<IType> optReturnType;
    private int dimension;
    private EdgeType edgeType;

    public MemberEdge(IJavaElement member) {
        this.element = (IJavaElement)Checks.ensureIsNotNull((Object)member);
    }

    private void initializeReturnType() throws JavaModelException {
        String typeSignature = null;
        switch (this.getEdgeElement().getElementType()) {
            case 8: {
                IField field = (IField)this.getEdgeElement();
                typeSignature = field.getTypeSignature();
                this.edgeType = EdgeType.FIELD;
                break;
            }
            case 14: {
                ILocalVariable local = (ILocalVariable)this.getEdgeElement();
                typeSignature = local.getTypeSignature();
                this.edgeType = EdgeType.LOCAL_VARIABLE;
                break;
            }
            case 9: {
                IMethod method = (IMethod)this.getEdgeElement();
                typeSignature = method.getReturnType();
                this.edgeType = EdgeType.METHOD;
            }
        }
        this.dimension = Signature.getArrayCount((char[])typeSignature.toCharArray());
        this.optReturnType = JdtUtils.findTypeFromSignature((String)typeSignature, (IJavaElement)this.element);
    }

    public <T extends IJavaElement> T getEdgeElement() {
        return (T)this.element;
    }

    public String toString() {
        try {
            switch (this.getEdgeElement().getElementType()) {
                case 8: {
                    return ((IField)this.getEdgeElement()).getKey();
                }
                case 14: {
                    return ((ILocalVariable)this.getEdgeElement()).getHandleIdentifier();
                }
                case 9: {
                    IMethod m = (IMethod)this.getEdgeElement();
                    return String.valueOf(m.getElementName()) + m.getSignature();
                }
            }
        }
        catch (JavaModelException e) {
            return e.toString();
        }
        return super.toString();
    }

    public EdgeType getEdgeType() {
        return this.edgeType;
    }

    public Optional<IType> getReturnType() {
        if (this.optReturnType == null) {
            try {
                this.initializeReturnType();
            }
            catch (JavaModelException e) {
                RecommendersUtilsPlugin.log((CoreException)e);
            }
        }
        return this.optReturnType;
    }

    public int getDimension() {
        if (this.optReturnType == null) {
            this.getReturnType();
        }
        return this.dimension;
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MemberEdge) {
            MemberEdge other = (MemberEdge)obj;
            return this.element.equals(other.element);
        }
        return super.equals(obj);
    }

    public static enum EdgeType {
        METHOD,
        FIELD,
        LOCAL_VARIABLE;

    }
}

