/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.chain;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.recommenders.internal.completion.rcp.chain.MemberEdge;
import org.eclipse.recommenders.utils.HashBag;
import org.eclipse.recommenders.utils.rcp.internal.RecommendersUtilsPlugin;
import org.eclipse.swt.graphics.Image;

public class CompletionTemplateBuilder {
    private HashBag<String> varNames;
    private StringBuilder sb;

    public TemplateProposal create(List<MemberEdge> chain, int expectedDimension, JavaContentAssistInvocationContext context) {
        String title = CompletionTemplateBuilder.createCompletionTitle(chain);
        String body = this.createCompletionBody(chain, expectedDimension);
        Template template = new Template(title, String.valueOf(chain.size()) + " elements", "java", body, false);
        return CompletionTemplateBuilder.createTemplateProposal(template, context);
    }

    private static String createCompletionTitle(List<MemberEdge> chain) {
        StringBuilder sb = new StringBuilder(64);
        for (MemberEdge edge : chain) {
            switch (edge.getEdgeType()) {
                case FIELD: 
                case LOCAL_VARIABLE: {
                    Object var = edge.getEdgeElement();
                    sb.append(var.getElementName());
                    break;
                }
                case METHOD: {
                    IMethod method = (IMethod)edge.getEdgeElement();
                    String label = JavaElementLabels.getElementLabel((IJavaElement)method, (long)3L);
                    sb.append(label);
                }
            }
            int i = edge.getDimension();
            while (i-- > 0) {
                sb.append("[]");
            }
            sb.append(".");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private String createCompletionBody(List<MemberEdge> chain, int expectedDimension) {
        this.varNames = HashBag.newHashBag();
        this.sb = new StringBuilder(64);
        for (MemberEdge edge : chain) {
            switch (edge.getEdgeType()) {
                case FIELD: 
                case LOCAL_VARIABLE: {
                    Object var = edge.getEdgeElement();
                    this.appendIdentifier((IJavaElement)var);
                    break;
                }
                case METHOD: {
                    IMethod method = (IMethod)edge.getEdgeElement();
                    this.appendIdentifier((IJavaElement)method);
                    this.appendParameters(method);
                }
            }
            this.appendArrayDimensions(edge.getDimension(), expectedDimension);
            this.sb.append(".");
        }
        this.deleteLastChar();
        return this.sb.toString();
    }

    private StringBuilder appendIdentifier(IJavaElement var) {
        return this.sb.append(var.getElementName());
    }

    private void appendParameters(IMethod method) {
        this.sb.append("(");
        try {
            String[] paramNames = method.getParameterNames();
            String[] paramTypes = method.getParameterTypes();
            int numberOfParams = paramNames.length;
            int i = 0;
            while (i < numberOfParams) {
                this.appendTemplateVariable(paramNames[i], paramTypes[i]);
                this.sb.append(", ");
                ++i;
            }
            if (numberOfParams > 0) {
                this.deleteLastChar();
                this.deleteLastChar();
            }
        }
        catch (JavaModelException e) {
            RecommendersUtilsPlugin.log((CoreException)e);
        }
        this.sb.append(")");
    }

    private void appendTemplateVariable(String varname, String varType) {
        this.varNames.add((Object)varname);
        this.sb.append("${").append(varname);
        int count = this.varNames.count((Object)varname);
        if (count > 1) {
            this.sb.append(count);
        }
        this.sb.append("}");
    }

    private StringBuilder deleteLastChar() {
        return this.sb.deleteCharAt(this.sb.length() - 1);
    }

    private void appendArrayDimensions(int dimension, int expectedDimension) {
        int i = dimension;
        while (i-- > expectedDimension) {
            this.sb.append("[");
            this.appendTemplateVariable("i", "I");
            this.sb.append("]");
        }
    }

    static TemplateProposal createTemplateProposal(Template template, JavaContentAssistInvocationContext contentAssistContext) {
        JavaContext javaTemplateContext = CompletionTemplateBuilder.createJavaContext(contentAssistContext);
        TemplateProposal proposal = new TemplateProposal(template, (TemplateContext)javaTemplateContext, (IRegion)new Region(javaTemplateContext.getCompletionOffset(), javaTemplateContext.getCompletionLength()), CompletionTemplateBuilder.getChainCompletionIcon());
        return proposal;
    }

    static JavaContext createJavaContext(JavaContentAssistInvocationContext contentAssistContext) {
        ContextTypeRegistry templateContextRegistry = JavaPlugin.getDefault().getTemplateContextRegistry();
        TemplateContextType templateContextType = templateContextRegistry.getContextType("java");
        JavaContext javaTemplateContext = new JavaContext(templateContextType, contentAssistContext.getDocument(), contentAssistContext.getInvocationOffset(), contentAssistContext.getCoreContext().getToken().length, contentAssistContext.getCompilationUnit());
        javaTemplateContext.setForceEvaluation(true);
        return javaTemplateContext;
    }

    static Image getChainCompletionIcon() {
        return JavaPlugin.getImageDescriptorRegistry().get(JavaPluginImages.DESC_MISC_PUBLIC);
    }
}

