/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.registry;

import java.io.File;
import org.apache.maven.execution.MavenExecutionRequest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryManager;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryRefreshJob;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.project.ResolverConfiguration;

public class MavenProjectManager
implements IMavenProjectRegistry {
    public static final String STATE_FILENAME = "workspacestate.properties";
    private final ProjectRegistryManager manager;
    private final ProjectRegistryRefreshJob mavenBackgroundJob;
    private final File workspaceStateFile;

    public MavenProjectManager(ProjectRegistryManager manager, ProjectRegistryRefreshJob mavenBackgroundJob, File stateLocation) {
        this.manager = manager;
        this.mavenBackgroundJob = mavenBackgroundJob;
        this.workspaceStateFile = new File(stateLocation, STATE_FILENAME);
    }

    public void refresh(MavenUpdateRequest request) {
        this.mavenBackgroundJob.refresh(request);
    }

    public void refresh(MavenUpdateRequest request, IProgressMonitor monitor) throws CoreException {
        this.manager.refresh(request, monitor);
    }

    public void addMavenProjectChangedListener(IMavenProjectChangedListener listener) {
        this.manager.addMavenProjectChangedListener(listener);
    }

    public void removeMavenProjectChangedListener(IMavenProjectChangedListener listener) {
        this.manager.removeMavenProjectChangedListener(listener);
    }

    public IMavenProjectFacade create(IFile pom, boolean load, IProgressMonitor monitor) {
        return this.manager.create(pom, load, monitor);
    }

    public IMavenProjectFacade create(IProject project, IProgressMonitor monitor) {
        return this.manager.create(project, monitor);
    }

    public IMavenProjectFacade[] getProjects() {
        return this.manager.getProjects();
    }

    public IMavenProjectFacade getProject(IProject project) {
        return this.manager.getProject(project);
    }

    public IMavenProjectFacade getMavenProject(String groupId, String artifactId, String version) {
        return this.manager.getMavenProject(groupId, artifactId, version);
    }

    public File getWorkspaceStateFile() {
        return this.workspaceStateFile;
    }

    public MavenExecutionRequest createExecutionRequest(IFile pom, ResolverConfiguration resolverConfiguration, IProgressMonitor monitor) throws CoreException {
        return this.manager.createExecutionRequest(pom, resolverConfiguration, monitor);
    }

    public MavenExecutionRequest createExecutionRequest(IMavenProjectFacade project, IProgressMonitor monitor) throws CoreException {
        return this.createExecutionRequest(project.getPom(), project.getResolverConfiguration(), monitor);
    }
}

