/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.lifecyclemapping;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.embedder.MavenImpl;
import org.eclipse.m2e.core.internal.lifecyclemapping.ActionMessageProblemInfo;
import org.eclipse.m2e.core.internal.lifecyclemapping.DuplicateMappingException;
import org.eclipse.m2e.core.internal.lifecyclemapping.InvalidLifecycleMapping;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingConfigurationException;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingResult;
import org.eclipse.m2e.core.internal.lifecyclemapping.MappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.MissingConfiguratorProblemInfo;
import org.eclipse.m2e.core.internal.lifecyclemapping.MissingLifecycleExtensionPoint;
import org.eclipse.m2e.core.internal.lifecyclemapping.NotCoveredMojoExecution;
import org.eclipse.m2e.core.internal.lifecyclemapping.SimpleMappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadata;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionFilter;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionMetadata;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.io.xpp3.LifecycleMappingMetadataSourceXpp3Reader;
import org.eclipse.m2e.core.internal.markers.MavenProblemInfo;
import org.eclipse.m2e.core.internal.markers.SourceLocation;
import org.eclipse.m2e.core.internal.markers.SourceLocationHelper;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectFacade;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractLifecycleMapping;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ILifecycleMapping;
import org.eclipse.m2e.core.project.configurator.ILifecycleMappingConfiguration;
import org.eclipse.m2e.core.project.configurator.MojoExecutionBuildParticipant;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleMappingFactory {
    private static final Logger log = LoggerFactory.getLogger(LifecycleMappingFactory.class);
    public static final String LIFECYCLE_MAPPING_PLUGIN_GROUPID = "org.eclipse.m2e";
    public static final String LIFECYCLE_MAPPING_PLUGIN_ARTIFACTID = "lifecycle-mapping";
    public static final String LIFECYCLE_MAPPING_PLUGIN_VERSION = "1.0.0";
    private static final String LIFECYCLE_MAPPING_PLUGIN_KEY = "org.eclipse.m2e:lifecycle-mapping";
    private static final String DEFAULT_LIFECYCLE_METADATA_BUNDLE = "org.eclipse.m2e.lifecyclemapping.defaults";
    public static final String LIFECYCLE_MAPPING_METADATA_SOURCE_NAME = "lifecycle-mapping-metadata.xml";
    private static final String LIFECYCLE_MAPPING_METADATA_SOURCE_PATH = "/lifecycle-mapping-metadata.xml";
    private static final String LIFECYCLE_MAPPING_METADATA_EMBEDDED_SOURCE_PATH = "META-INF/m2e/lifecycle-mapping-metadata.xml";
    public static final String EXTENSION_LIFECYCLE_MAPPINGS = "org.eclipse.m2e.core.lifecycleMappings";
    public static final String EXTENSION_PROJECT_CONFIGURATORS = "org.eclipse.m2e.core.projectConfigurators";
    public static final String EXTENSION_LIFECYCLE_MAPPING_METADATA_SOURCE = "org.eclipse.m2e.core.lifecycleMappingMetadataSource";
    private static final String ELEMENT_LIFECYCLE_MAPPING_METADATA = "lifecycleMappingMetadata";
    private static final String ELEMENT_LIFECYCLE_MAPPING = "lifecycleMapping";
    private static final String ELEMENT_SOURCES = "sources";
    private static final String ELEMENT_SOURCE = "source";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ELEMENT_CONFIGURATOR = "configurator";
    private static final String ELEMENT_MESSAGE = "message";
    private static final String ELEMENT_RUN_ON_INCREMENTAL = "runOnIncremental";
    private static final String ELEMENT_RUN_ON_CONFIGURATION = "runOnConfiguration";
    private static final String ATTR_GROUPID = "groupId";
    private static final String ATTR_ARTIFACTID = "artifactId";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_SECONDARY_TO = "secondaryTo";
    private static final String LIFECYCLE_MAPPING_METADATA_CLASSIFIER = "lifecycle-mapping-metadata";
    private static List<LifecycleMappingMetadataSource> bundleMetadataSources = null;
    private static LifecycleMappingMetadataSource defaultLifecycleMappingMetadataSource;
    private static boolean useDefaultLifecycleMappingMetadataSource;
    private static final String[] INTERESTING_PHASES;

    static {
        useDefaultLifecycleMappingMetadataSource = true;
        INTERESTING_PHASES = new String[]{"validate", "initialize", "generate-sources", "process-sources", "generate-resources", "process-resources", "compile", "process-classes", "generate-test-sources", "process-test-sources", "generate-test-resources", "process-test-resources", "test-compile", "process-test-classes"};
    }

    public static LifecycleMappingResult calculateLifecycleMapping(MavenExecutionRequest templateRequest, MavenProjectFacade projectFacade, IProgressMonitor monitor) {
        long start = System.currentTimeMillis();
        log.debug("Loading lifecycle mapping for {}.", (Object)projectFacade.toString());
        LifecycleMappingResult result = new LifecycleMappingResult();
        try {
            try {
                MavenProject mavenProject = projectFacade.getMavenProject(monitor);
                LifecycleMappingFactory.calculateEffectiveLifecycleMappingMetadata(result, templateRequest, mavenProject, projectFacade.getMojoExecutions(), monitor);
                LifecycleMappingFactory.instantiateLifecycleMapping(result, mavenProject, result.getLifecycleMappingId());
                if (result.getLifecycleMapping() != null) {
                    LifecycleMappingFactory.instantiateProjectConfigurators(mavenProject, result, result.getMojoExecutionMapping());
                }
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                result.addProblem(new MavenProblemInfo(1, (Throwable)ex));
                log.info("Using {} lifecycle mapping for {}.", (Object)result.getLifecycleMappingId(), (Object)projectFacade.toString());
                log.debug("Loaded lifecycle mapping in {} ms for {}.", (Object)(System.currentTimeMillis() - start), (Object)projectFacade.toString());
            }
        }
        finally {
            log.info("Using {} lifecycle mapping for {}.", (Object)result.getLifecycleMappingId(), (Object)projectFacade.toString());
            log.debug("Loaded lifecycle mapping in {} ms for {}.", (Object)(System.currentTimeMillis() - start), (Object)projectFacade.toString());
        }
        return result;
    }

    public static void calculateEffectiveLifecycleMappingMetadata(LifecycleMappingResult result, MavenExecutionRequest templateRequest, MavenProject mavenProject, List<MojoExecution> mojoExecutions, IProgressMonitor monitor) throws CoreException {
        List<MappingMetadataSource> metadataSources;
        String packagingType = mavenProject.getPackaging();
        if ("pom".equals(packagingType)) {
            log.debug("Using NoopLifecycleMapping lifecycle mapping for {}.", (Object)mavenProject.toString());
            LifecycleMappingMetadata lifecycleMappingMetadata = new LifecycleMappingMetadata();
            lifecycleMappingMetadata.setLifecycleMappingId("NULL");
            result.setLifecycleMappingMetadata(lifecycleMappingMetadata);
            LinkedHashMap<MojoExecutionKey, List<IPluginExecutionMetadata>> executionMapping = new LinkedHashMap<MojoExecutionKey, List<IPluginExecutionMetadata>>();
            result.setMojoExecutionMapping(executionMapping);
            return;
        }
        try {
            metadataSources = LifecycleMappingFactory.getProjectMetadataSources(templateRequest, mavenProject, LifecycleMappingFactory.getBundleMetadataSources(), mojoExecutions, true, monitor);
        }
        catch (LifecycleMappingConfigurationException e) {
            result.addProblem(new MavenProblemInfo(mavenProject, e));
            return;
        }
        LifecycleMappingFactory.calculateEffectiveLifecycleMappingMetadata(result, templateRequest, metadataSources, mavenProject, mojoExecutions, true);
    }

    public static List<MappingMetadataSource> getProjectMetadataSources(MavenExecutionRequest templateRequest, MavenProject mavenProject, List<LifecycleMappingMetadataSource> bundleMetadataSources, List<MojoExecution> mojoExecutions, boolean includeDefault, IProgressMonitor monitor) throws CoreException, LifecycleMappingConfigurationException {
        LifecycleMappingMetadataSource defaultSource;
        ArrayList<MappingMetadataSource> metadataSources = new ArrayList<MappingMetadataSource>();
        for (LifecycleMappingMetadataSource source : LifecycleMappingFactory.getPomMappingMetadataSources(mavenProject, templateRequest, monitor)) {
            metadataSources.add(new SimpleMappingMetadataSource(source));
        }
        metadataSources.add(new SimpleMappingMetadataSource(bundleMetadataSources));
        for (LifecycleMappingMetadataSource source : LifecycleMappingFactory.getMavenPluginEmbeddedMetadataSources(mojoExecutions, mavenProject.getPluginArtifactRepositories(), monitor)) {
            metadataSources.add(new SimpleMappingMetadataSource(source));
        }
        if (includeDefault && (defaultSource = LifecycleMappingFactory.getDefaultLifecycleMappingMetadataSource()) != null) {
            metadataSources.add(new SimpleMappingMetadataSource(defaultSource));
        }
        return metadataSources;
    }

    private static List<LifecycleMappingMetadataSource> getMavenPluginEmbeddedMetadataSources(List<MojoExecution> mojoExecutions, List<ArtifactRepository> remoteRepositories, IProgressMonitor monitor) {
        LinkedHashMap<File, LifecycleMappingMetadataSource> result = new LinkedHashMap<File, LifecycleMappingMetadataSource>();
        if (mojoExecutions == null || mojoExecutions.isEmpty()) {
            return Collections.emptyList();
        }
        MavenImpl maven = (MavenImpl)MavenPlugin.getMaven();
        for (MojoExecution execution : mojoExecutions) {
            LifecycleMappingMetadataSource metadata;
            Artifact artifact;
            try {
                artifact = maven.resolvePluginArtifact(execution.getPlugin(), remoteRepositories, monitor);
            }
            catch (CoreException coreException) {
                continue;
            }
            File file = artifact.getFile();
            if (file == null || result.containsKey(file) || !file.canRead() || (metadata = LifecycleMappingFactory.readMavenPluginEmbeddedMetadata(artifact)) == null) continue;
            for (LifecycleMappingMetadata lifecycleMetadta : metadata.getLifecycleMappings()) {
                LifecycleMappingFactory.enforcePluginMapping(artifact, lifecycleMetadta.getPluginExecutions());
            }
            LifecycleMappingFactory.enforcePluginMapping(artifact, metadata.getPluginExecutions());
            result.put(file, metadata);
        }
        return new ArrayList<LifecycleMappingMetadataSource>(result.values());
    }

    private static void enforcePluginMapping(Artifact artifact, List<PluginExecutionMetadata> executions) {
        if (executions == null) {
            return;
        }
        ListIterator<PluginExecutionMetadata> iter = executions.listIterator();
        while (iter.hasNext()) {
            PluginExecutionMetadata execution = iter.next();
            PluginExecutionFilter filter = execution.getFilter();
            if (!(LifecycleMappingFactory.isNullOrEqual(artifact.getGroupId(), filter.getGroupId()) && LifecycleMappingFactory.isNullOrEqual(artifact.getArtifactId(), filter.getArtifactId()) && LifecycleMappingFactory.isNullOrEqual(artifact.getBaseVersion(), filter.getVersionRange()))) {
                String mappingGAV = String.valueOf(filter.getGroupId()) + ":" + filter.getArtifactId() + ":" + filter.getVersionRange();
                String pluginGAV = String.valueOf(artifact.getGroupId()) + ":" + artifact.getArtifactId() + ":" + artifact.getBaseVersion();
                log.warn("Ignoring plugin execution mapping {} defined in maven plugin {} because it matches other plugins and/or plugin versions", (Object)mappingGAV, (Object)pluginGAV);
                iter.remove();
                continue;
            }
            filter.setGroupId(artifact.getGroupId());
            filter.setArtifactId(artifact.getArtifactId());
            filter.setVersionRange(artifact.getBaseVersion());
        }
    }

    private static boolean isNullOrEqual(String expected, String actual) {
        return actual == null || actual.equals(expected);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static LifecycleMappingMetadataSource readMavenPluginEmbeddedMetadata(Artifact artifact) {
        File file = artifact.getFile();
        try {
            if (file.isFile()) {
                ZipEntry entry;
                JarFile jar;
                block18: {
                    jar = new JarFile(file);
                    try {
                        entry = jar.getEntry(LIFECYCLE_MAPPING_METADATA_EMBEDDED_SOURCE_PATH);
                        if (entry != null) break block18;
                    }
                    catch (Throwable throwable) {
                        try {
                            jar.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        jar.close();
                        return null;
                    }
                    catch (IOException iOException) {}
                    return null;
                }
                InputStream is = jar.getInputStream(entry);
                LifecycleMappingMetadataSource lifecycleMappingMetadataSource = LifecycleMappingFactory.readMavenPluginEmbeddedMetadata(artifact, is);
                try {
                    jar.close();
                    return lifecycleMappingMetadataSource;
                }
                catch (IOException iOException) {}
                return lifecycleMappingMetadataSource;
            }
            if (!file.isDirectory()) return null;
            try {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(new File(file, LIFECYCLE_MAPPING_METADATA_EMBEDDED_SOURCE_PATH)));
                try {
                    LifecycleMappingMetadataSource lifecycleMappingMetadataSource = LifecycleMappingFactory.readMavenPluginEmbeddedMetadata(artifact, is);
                    return lifecycleMappingMetadataSource;
                }
                finally {
                    IOUtil.close((InputStream)is);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        catch (XmlPullParserException e) {
            throw new LifecycleMappingConfigurationException("Cannot read lifecycle mapping metadata for artifact " + artifact, e);
        }
        catch (IOException e) {
            throw new LifecycleMappingConfigurationException("Cannot read lifecycle mapping metadata for artifact " + artifact, e);
        }
    }

    private static LifecycleMappingMetadataSource readMavenPluginEmbeddedMetadata(Artifact artifact, InputStream is) throws IOException, XmlPullParserException {
        return new LifecycleMappingMetadataSourceXpp3Reader().read(is);
    }

    public static void calculateEffectiveLifecycleMappingMetadata(LifecycleMappingResult result, MavenExecutionRequest templateRequest, List<MappingMetadataSource> metadataSources, MavenProject mavenProject, List<MojoExecution> mojoExecutions, boolean applyDefaultStrategy) {
        IMaven maven = MavenPlugin.getMaven();
        MavenSession session = maven.createSession(LifecycleMappingFactory.newMavenExecutionRequest(templateRequest), mavenProject);
        LifecycleMappingMetadata lifecycleMappingMetadata = null;
        SimpleMappingMetadataSource originalMetadataSource = null;
        int i = 0;
        while (i < metadataSources.size()) {
            MappingMetadataSource source = metadataSources.get(i);
            try {
                lifecycleMappingMetadata = source.getLifecycleMappingMetadata(mavenProject.getPackaging());
                if (lifecycleMappingMetadata != null) {
                    originalMetadataSource = new SimpleMappingMetadataSource(lifecycleMappingMetadata);
                    metadataSources.add(i, originalMetadataSource);
                    break;
                }
            }
            catch (DuplicateMappingException duplicateMappingException) {
                log.error("Duplicate lifecycle mapping metadata for {}.", (Object)mavenProject.toString());
                result.addProblem(new MavenProblemInfo(1, NLS.bind((String)Messages.LifecycleDuplicate, (Object)mavenProject.getPackaging())));
                return;
            }
            ++i;
        }
        if (lifecycleMappingMetadata == null && applyDefaultStrategy) {
            lifecycleMappingMetadata = new LifecycleMappingMetadata();
            lifecycleMappingMetadata.setLifecycleMappingId("DEFAULT");
            lifecycleMappingMetadata.setPackagingType(mavenProject.getPackaging());
        }
        result.setLifecycleMappingMetadata(lifecycleMappingMetadata);
        LinkedHashMap<MojoExecutionKey, List<IPluginExecutionMetadata>> executionMapping = new LinkedHashMap<MojoExecutionKey, List<IPluginExecutionMetadata>>();
        if (mojoExecutions != null) {
            for (MojoExecution execution : mojoExecutions) {
                MojoExecutionKey executionKey = new MojoExecutionKey(execution);
                PluginExecutionMetadata primaryMetadata = null;
                try {
                    for (MappingMetadataSource source : metadataSources) {
                        try {
                            List<PluginExecutionMetadata> metadatas = LifecycleMappingFactory.applyParametersFilter(session, source.getPluginExecutionMetadata(executionKey), mavenProject, execution);
                            for (PluginExecutionMetadata executionMetadata : metadatas) {
                                if (!LifecycleMappingFactory.isPrimaryMapping(executionMetadata)) continue;
                                if (primaryMetadata != null) {
                                    primaryMetadata = null;
                                    throw new DuplicateMappingException();
                                }
                                primaryMetadata = executionMetadata;
                            }
                            if (primaryMetadata == null) continue;
                            break;
                        }
                        catch (CoreException e) {
                            SourceLocation location = SourceLocationHelper.findLocation(mavenProject, executionKey);
                            result.addProblem(new MavenProblemInfo(location, (Throwable)e));
                        }
                    }
                }
                catch (DuplicateMappingException duplicateMappingException) {
                    log.debug("Duplicate plugin execution mapping metadata for {}.", (Object)executionKey.toString());
                    result.addProblem(new MavenProblemInfo(1, NLS.bind((String)Messages.PluginExecutionMappingDuplicate, (Object)executionKey.toString())));
                }
                if (primaryMetadata != null && !LifecycleMappingFactory.isValidPluginExecutionMetadata(primaryMetadata)) {
                    log.debug("Invalid plugin execution mapping metadata for {}.", (Object)executionKey.toString());
                    result.addProblem(new MavenProblemInfo(1, NLS.bind((String)Messages.PluginExecutionMappingInvalid, (Object)executionKey.toString())));
                    primaryMetadata = null;
                }
                ArrayList<PluginExecutionMetadata> executionMetadatas = new ArrayList<PluginExecutionMetadata>();
                if (primaryMetadata != null) {
                    executionMetadatas.add(primaryMetadata);
                    if (primaryMetadata.getAction() == PluginExecutionAction.configurator) {
                        for (MappingMetadataSource source : metadataSources) {
                            try {
                                List<PluginExecutionMetadata> metadatas = source.getPluginExecutionMetadata(executionKey);
                                metadatas = LifecycleMappingFactory.applyParametersFilter(session, metadatas, mavenProject, execution);
                                for (PluginExecutionMetadata metadata : metadatas) {
                                    if (LifecycleMappingFactory.isValidPluginExecutionMetadata(metadata)) {
                                        if (metadata.getAction() != PluginExecutionAction.configurator || !LifecycleMappingFactory.isSecondaryMapping(metadata, primaryMetadata)) continue;
                                        executionMetadatas.add(metadata);
                                        continue;
                                    }
                                    log.debug("Invalid secondary lifecycle mapping metadata for {}.", (Object)executionKey.toString());
                                }
                            }
                            catch (CoreException e) {
                                SourceLocation location = SourceLocationHelper.findLocation(mavenProject, executionKey);
                                result.addProblem(new MavenProblemInfo(location, (Throwable)e));
                            }
                        }
                    }
                }
                executionMapping.put(executionKey, executionMetadatas);
            }
        } else {
            log.debug("Execution plan is null, could not calculate mojo execution mapping for {}.", (Object)mavenProject.toString());
        }
        result.setMojoExecutionMapping(executionMapping);
    }

    private static List<PluginExecutionMetadata> applyParametersFilter(MavenSession session, List<PluginExecutionMetadata> metadatas, MavenProject mavenProject, MojoExecution execution) throws CoreException {
        IMaven maven = MavenPlugin.getMaven();
        ArrayList<PluginExecutionMetadata> result = new ArrayList<PluginExecutionMetadata>();
        block0: for (PluginExecutionMetadata metadata : metadatas) {
            Map parameters = metadata.getFilter().getParameters();
            if (!parameters.isEmpty()) {
                for (String name : parameters.keySet()) {
                    MojoExecution setupExecution;
                    String value = (String)parameters.get(name);
                    if (!LifecycleMappingFactory.eq(value, maven.getMojoParameterValue(session, setupExecution = maven.setupMojoExecution(session, mavenProject, execution), name, String.class))) continue block0;
                }
            }
            result.add(metadata);
        }
        return result;
    }

    private static boolean isValidPluginExecutionMetadata(PluginExecutionMetadata metadata) {
        switch (metadata.getAction()) {
            case ignore: 
            case execute: 
            case error: {
                return true;
            }
            case configurator: {
                try {
                    LifecycleMappingFactory.getProjectConfiguratorId(metadata);
                    return true;
                }
                catch (LifecycleMappingConfigurationException lifecycleMappingConfigurationException) {
                    return false;
                }
            }
        }
        return false;
    }

    public static void instantiateLifecycleMapping(LifecycleMappingResult result, MavenProject mavenProject, String lifecycleMappingId) {
        AbstractLifecycleMapping lifecycleMapping = null;
        if (lifecycleMappingId != null && (lifecycleMapping = LifecycleMappingFactory.getLifecycleMapping(lifecycleMappingId)) == null) {
            SourceLocation markerLocation = SourceLocationHelper.findPackagingLocation(mavenProject);
            result.addProblem(new MissingLifecycleExtensionPoint(lifecycleMappingId, markerLocation));
        }
        result.setLifecycleMapping(lifecycleMapping);
    }

    public static void instantiateProjectConfigurators(MavenProject mavenProject, LifecycleMappingResult result, Map<MojoExecutionKey, List<IPluginExecutionMetadata>> map) {
        if (map == null) {
            Map<String, AbstractProjectConfigurator> configurators = Collections.emptyMap();
            result.setProjectConfigurators(configurators);
            return;
        }
        LinkedHashMap<String, AbstractProjectConfigurator> configurators = new LinkedHashMap<String, AbstractProjectConfigurator>();
        for (Map.Entry<MojoExecutionKey, List<IPluginExecutionMetadata>> entry : map.entrySet()) {
            MojoExecutionKey executionKey = entry.getKey();
            List<IPluginExecutionMetadata> executionMetadatas = entry.getValue();
            if (executionMetadatas == null || executionMetadatas.isEmpty()) {
                if (!LifecycleMappingFactory.isInterestingPhase(executionKey.getLifecyclePhase())) continue;
                SourceLocation markerLocation = SourceLocationHelper.findLocation(mavenProject, executionKey);
                result.addProblem(new NotCoveredMojoExecution(executionKey, markerLocation));
                continue;
            }
            block9: for (IPluginExecutionMetadata metadata : executionMetadatas) {
                String message = LifecycleMappingFactory.getActionMessage(metadata);
                switch (metadata.getAction()) {
                    case error: {
                        if (message == null) {
                            message = NLS.bind((String)Messages.LifecycleConfigurationPluginExecutionErrorMessage, (Object)executionKey.toString());
                        }
                        SourceLocation markerLocation = SourceLocationHelper.findLocation(mavenProject, executionKey);
                        result.addProblem(new ActionMessageProblemInfo(message, 2, executionKey, markerLocation, LifecycleMappingFactory.isPomMapping(metadata)));
                        break;
                    }
                    case execute: {
                        if (message == null) break;
                        SourceLocation markerLocation = SourceLocationHelper.findLocation(mavenProject, executionKey);
                        result.addProblem(new ActionMessageProblemInfo(message, 1, executionKey, markerLocation, LifecycleMappingFactory.isPomMapping(metadata)));
                        break;
                    }
                    case configurator: {
                        String configuratorId = LifecycleMappingFactory.getProjectConfiguratorId(metadata);
                        try {
                            if (configurators.containsKey(configuratorId)) break;
                            configurators.put(configuratorId, LifecycleMappingFactory.createProjectConfigurator(metadata));
                        }
                        catch (LifecycleMappingConfigurationException e) {
                            log.debug("Could not instantiate project configurator {}.", (Object)configuratorId, (Object)e);
                            SourceLocation markerLocation = SourceLocationHelper.findLocation(mavenProject, executionKey);
                            result.addProblem(new MissingConfiguratorProblemInfo(configuratorId, markerLocation));
                            result.addProblem(new NotCoveredMojoExecution(executionKey, markerLocation));
                        }
                        continue block9;
                    }
                    case ignore: {
                        if (message == null) break;
                        SourceLocation markerLocation = SourceLocationHelper.findLocation(mavenProject, executionKey);
                        result.addProblem(new ActionMessageProblemInfo(message, 1, executionKey, markerLocation, LifecycleMappingFactory.isPomMapping(metadata)));
                    }
                }
            }
        }
        result.setProjectConfigurators(configurators);
    }

    private static boolean isPomMapping(IPluginExecutionMetadata metadata) {
        LifecycleMappingMetadataSource source = ((PluginExecutionMetadata)metadata).getSource();
        return source != null && source.getSource() instanceof MavenProject;
    }

    public static List<LifecycleMappingMetadataSource> getPomMappingMetadataSources(MavenProject mavenProject, MavenExecutionRequest templateRequest, IProgressMonitor monitor) throws CoreException {
        IMaven maven = MavenPlugin.getMaven();
        ArrayList<LifecycleMappingMetadataSource> sources = new ArrayList<LifecycleMappingMetadataSource>();
        LinkedHashSet<String> referenced = new LinkedHashSet<String>();
        MavenProject project = mavenProject;
        while (!monitor.isCanceled()) {
            LifecycleMappingMetadataSource embeddedSource = LifecycleMappingFactory.getEmbeddedMetadataSource(project);
            if (embeddedSource != null) {
                maven.detachFromSession(project);
                embeddedSource.setSource(project);
                sources.add(embeddedSource);
            }
            for (LifecycleMappingMetadataSource referencedSource : LifecycleMappingFactory.getReferencedMetadataSources(referenced, project, monitor)) {
                sources.add(referencedSource);
            }
            MavenExecutionRequest request = LifecycleMappingFactory.newMavenExecutionRequest(templateRequest);
            project = maven.resolveParentProject(request, project, monitor);
            if (project != null) continue;
        }
        return sources;
    }

    private static MavenExecutionRequest newMavenExecutionRequest(MavenExecutionRequest templateRequest) {
        MavenExecutionRequest copy = DefaultMavenExecutionRequest.copy((MavenExecutionRequest)templateRequest);
        copy.setStartTime(templateRequest.getStartTime());
        return copy;
    }

    public static AbstractProjectConfigurator createProjectConfigurator(IPluginExecutionMetadata metadata) {
        PluginExecutionAction pluginExecutionAction = metadata.getAction();
        if (pluginExecutionAction != PluginExecutionAction.configurator) {
            throw new IllegalArgumentException();
        }
        String configuratorId = LifecycleMappingFactory.getProjectConfiguratorId(metadata);
        AbstractProjectConfigurator projectConfigurator = LifecycleMappingFactory.createProjectConfigurator(configuratorId);
        if (projectConfigurator == null) {
            String message = NLS.bind((String)Messages.ProjectConfiguratorNotAvailable, (Object)configuratorId);
            throw new LifecycleMappingConfigurationException(message);
        }
        return projectConfigurator;
    }

    public static String getProjectConfiguratorId(IPluginExecutionMetadata metadata) {
        Xpp3Dom child = ((PluginExecutionMetadata)metadata).getConfiguration().getChild(ATTR_ID);
        if (child == null || child.getValue().trim().length() == 0) {
            throw new LifecycleMappingConfigurationException("A configurator id must be specified");
        }
        return child.getValue();
    }

    public static String getActionMessage(IPluginExecutionMetadata metadata) {
        Xpp3Dom child = ((PluginExecutionMetadata)metadata).getConfiguration().getChild(ELEMENT_MESSAGE);
        if (child == null || child.getValue().trim().length() == 0) {
            return null;
        }
        return child.getValue();
    }

    public static LifecycleMappingMetadataSource createLifecycleMappingMetadataSource(InputStream is) throws IOException, XmlPullParserException {
        LifecycleMappingMetadataSource metadataSource = new LifecycleMappingMetadataSourceXpp3Reader().read(is);
        LifecycleMappingFactory.postCreateLifecycleMappingMetadataSource(metadataSource);
        return metadataSource;
    }

    private static void postCreateLifecycleMappingMetadataSource(LifecycleMappingMetadataSource metadataSource) {
        for (LifecycleMappingMetadata lifecycleMappingMetadata : metadataSource.getLifecycleMappings()) {
            lifecycleMappingMetadata.setSource(metadataSource);
            for (PluginExecutionMetadata executionMetadata : lifecycleMappingMetadata.getPluginExecutions()) {
                executionMetadata.setSource(metadataSource);
            }
        }
        for (PluginExecutionMetadata executionMetadata : metadataSource.getPluginExecutions()) {
            executionMetadata.setSource(metadataSource);
        }
    }

    private static AbstractLifecycleMapping createLifecycleMapping(IConfigurationElement element) {
        String mappingId = null;
        try {
            AbstractLifecycleMapping mapping = (AbstractLifecycleMapping)element.createExecutableExtension(ATTR_CLASS);
            mappingId = element.getAttribute(ATTR_ID);
            mapping.setId(mappingId);
            mapping.setName(element.getAttribute(ATTR_NAME));
            return mapping;
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static MojoExecutionBuildParticipant createMojoExecutionBuildParicipant(IMavenProjectFacade projectFacade, MojoExecution mojoExecution, IPluginExecutionMetadata executionMetadata) {
        boolean runOnIncremental = true;
        boolean runOnConfiguration = false;
        Xpp3Dom child = ((PluginExecutionMetadata)executionMetadata).getConfiguration().getChild(ELEMENT_RUN_ON_INCREMENTAL);
        if (child != null) {
            runOnIncremental = Boolean.parseBoolean(child.getValue());
        }
        if ((child = ((PluginExecutionMetadata)executionMetadata).getConfiguration().getChild(ELEMENT_RUN_ON_CONFIGURATION)) != null) {
            runOnConfiguration = Boolean.parseBoolean(child.getValue());
        }
        return new MojoExecutionBuildParticipant(mojoExecution, runOnIncremental, runOnConfiguration);
    }

    public static Map<String, IConfigurationElement> getLifecycleMappingExtensions() {
        HashMap<String, IConfigurationElement> mappings = new HashMap<String, IConfigurationElement>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint configuratorsExtensionPoint = registry.getExtensionPoint(EXTENSION_LIFECYCLE_MAPPINGS);
        if (configuratorsExtensionPoint != null) {
            IExtension[] configuratorExtensions;
            IExtension[] iExtensionArray = configuratorExtensions = configuratorsExtensionPoint.getExtensions();
            int n = configuratorExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals(ELEMENT_LIFECYCLE_MAPPING)) {
                        mappings.put(element.getAttribute(ATTR_ID), element);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return mappings;
    }

    private static AbstractLifecycleMapping getLifecycleMapping(String mappingId) {
        IConfigurationElement element = LifecycleMappingFactory.getLifecycleMappingExtensions().get(mappingId);
        if (element != null && element.getName().equals(ELEMENT_LIFECYCLE_MAPPING) && mappingId.equals(element.getAttribute(ATTR_ID))) {
            return LifecycleMappingFactory.createLifecycleMapping(element);
        }
        return null;
    }

    public static AbstractProjectConfigurator createProjectConfigurator(String configuratorId) {
        IConfigurationElement element = LifecycleMappingFactory.getProjectConfiguratorExtension(configuratorId);
        if (element != null) {
            try {
                AbstractProjectConfigurator configurator = (AbstractProjectConfigurator)element.createExecutableExtension(ATTR_CLASS);
                configurator.setProjectManager(MavenPlugin.getMavenProjectRegistry());
                configurator.setMavenConfiguration(MavenPlugin.getMavenConfiguration());
                configurator.setMarkerManager(MavenPluginActivator.getDefault().getMavenMarkerManager());
                return configurator;
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    public static Map<String, IConfigurationElement> getProjectConfiguratorExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        return LifecycleMappingFactory.getProjectConfiguratorExtensions(registry);
    }

    public static Map<String, IConfigurationElement> getProjectConfiguratorExtensions(IExtensionRegistry registry) {
        HashMap<String, IConfigurationElement> extensions = new HashMap<String, IConfigurationElement>();
        IExtensionPoint configuratorsExtensionPoint = registry.getExtensionPoint(EXTENSION_PROJECT_CONFIGURATORS);
        if (configuratorsExtensionPoint != null) {
            IExtension[] configuratorExtensions;
            IExtension[] iExtensionArray = configuratorExtensions = configuratorsExtensionPoint.getExtensions();
            int n = configuratorExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals(ELEMENT_CONFIGURATOR)) {
                        extensions.put(element.getAttribute(ATTR_ID), element);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return extensions;
    }

    private static IConfigurationElement getProjectConfiguratorExtension(String configuratorId) {
        IConfigurationElement element = LifecycleMappingFactory.getProjectConfiguratorExtensions().get(configuratorId);
        if (element != null && element.getName().equals(ELEMENT_CONFIGURATOR) && configuratorId.equals(element.getAttribute(ATTR_ID))) {
            return element;
        }
        return null;
    }

    private static void checkCompatibleVersion(Plugin metadataPlugin) {
        ComparableVersion version = new ComparableVersion(metadataPlugin.getVersion());
        if (!version.equals((Object)new ComparableVersion(LIFECYCLE_MAPPING_PLUGIN_VERSION))) {
            SourceLocation location = SourceLocationHelper.findLocation(metadataPlugin, ATTR_VERSION);
            throw new LifecycleMappingConfigurationException(NLS.bind((String)Messages.LifecycleMappingPluginVersionIncompatible, (Object)metadataPlugin.getVersion()), location);
        }
    }

    private static LifecycleMappingMetadataSource getEmbeddedMetadataSource(MavenProject mavenProject) throws CoreException {
        PluginManagement pluginManagement = LifecycleMappingFactory.getPluginManagement(mavenProject);
        Plugin metadataPlugin = (Plugin)pluginManagement.getPluginsAsMap().get(LIFECYCLE_MAPPING_PLUGIN_KEY);
        if (metadataPlugin != null) {
            Xpp3Dom lifecycleMappingDom;
            LifecycleMappingFactory.checkCompatibleVersion(metadataPlugin);
            Xpp3Dom configurationDom = (Xpp3Dom)metadataPlugin.getConfiguration();
            if (configurationDom != null && (lifecycleMappingDom = configurationDom.getChild(ELEMENT_LIFECYCLE_MAPPING_METADATA)) != null) {
                try {
                    LifecycleMappingMetadataSource metadataSource = new LifecycleMappingMetadataSourceXpp3Reader().read(new StringReader(lifecycleMappingDom.toString()));
                    LifecycleMappingFactory.postCreateLifecycleMappingMetadataSource(metadataSource);
                    String packagingType = mavenProject.getPackaging();
                    if (!"pom".equals(packagingType)) {
                        for (LifecycleMappingMetadata lifecycleMappingMetadata : metadataSource.getLifecycleMappings()) {
                            if (packagingType.equals(lifecycleMappingMetadata.getPackagingType())) continue;
                            SourceLocation location = SourceLocationHelper.findLocation(metadataPlugin, "configuration");
                            throw new LifecycleMappingConfigurationException(NLS.bind((String)Messages.LifecycleMappingPackagingMismatch, (Object)lifecycleMappingMetadata.getPackagingType(), (Object)packagingType), location);
                        }
                    }
                    return metadataSource;
                }
                catch (IOException e) {
                    throw new LifecycleMappingConfigurationException("Cannot read lifecycle mapping metadata for maven project " + mavenProject, e);
                }
                catch (XmlPullParserException e) {
                    throw new LifecycleMappingConfigurationException("Cannot parse lifecycle mapping metadata for maven project " + mavenProject, e);
                }
                catch (LifecycleMappingConfigurationException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw new LifecycleMappingConfigurationException("Cannot load lifecycle mapping metadata for maven project " + mavenProject, e);
                }
            }
        }
        return null;
    }

    private static List<LifecycleMappingMetadataSource> getReferencedMetadataSources(Set<String> referenced, MavenProject mavenProject, IProgressMonitor monitor) throws CoreException {
        ArrayList<LifecycleMappingMetadataSource> metadataSources = new ArrayList<LifecycleMappingMetadataSource>();
        PluginManagement pluginManagement = LifecycleMappingFactory.getPluginManagement(mavenProject);
        for (Plugin plugin : pluginManagement.getPlugins()) {
            Xpp3Dom configuration;
            if (!LIFECYCLE_MAPPING_PLUGIN_KEY.equals(plugin.getKey()) || (configuration = (Xpp3Dom)plugin.getConfiguration()) == null) continue;
            LifecycleMappingFactory.checkCompatibleVersion(plugin);
            Xpp3Dom sources = configuration.getChild(ELEMENT_SOURCES);
            if (sources == null) continue;
            Xpp3Dom[] xpp3DomArray = sources.getChildren(ELEMENT_SOURCE);
            int n = xpp3DomArray.length;
            int n2 = 0;
            while (n2 < n) {
                Xpp3Dom source = xpp3DomArray[n2];
                String groupId = null;
                Xpp3Dom child = source.getChild(ATTR_GROUPID);
                if (child != null) {
                    groupId = child.getValue();
                }
                String artifactId = null;
                child = source.getChild(ATTR_ARTIFACTID);
                if (child != null) {
                    artifactId = child.getValue();
                }
                String version = null;
                child = source.getChild(ATTR_VERSION);
                if (child != null) {
                    version = child.getValue();
                }
                if (referenced.add(String.valueOf(groupId) + ":" + artifactId)) {
                    try {
                        LifecycleMappingMetadataSource lifecycleMappingMetadataSource = LifecycleMappingFactory.getLifecycleMappingMetadataSource(groupId, artifactId, version, mavenProject.getRemoteArtifactRepositories(), monitor);
                        metadataSources.add(lifecycleMappingMetadataSource);
                    }
                    catch (LifecycleMappingConfigurationException e) {
                        SourceLocation location = SourceLocationHelper.findLocation(plugin, "configuration");
                        e.setLocation(location);
                        throw e;
                    }
                }
                ++n2;
            }
        }
        return metadataSources;
    }

    private static PluginManagement getPluginManagement(MavenProject mavenProject) throws CoreException {
        Model model = new Model();
        Build build = new Build();
        model.setBuild(build);
        PluginManagement result = new PluginManagement();
        build.setPluginManagement(result);
        if (mavenProject == null) {
            return null;
        }
        LifecycleMappingFactory.addBuild(result, (BuildBase)mavenProject.getOriginalModel().getBuild());
        for (Profile profile : mavenProject.getActiveProfiles()) {
            LifecycleMappingFactory.addBuild(result, profile.getBuild());
        }
        MavenImpl maven = (MavenImpl)MavenPlugin.getMaven();
        maven.interpolateModel(mavenProject, model);
        return result;
    }

    private static void addBuild(PluginManagement result, BuildBase build) {
        PluginManagement pluginManagement;
        if (build != null && (pluginManagement = build.getPluginManagement()) != null) {
            List _plugins = pluginManagement.getPlugins();
            for (Plugin plugin : _plugins) {
                result.addPlugin(plugin.clone());
            }
        }
    }

    public static LifecycleMappingMetadataSource getDefaultLifecycleMappingMetadataSource() {
        if (!useDefaultLifecycleMappingMetadataSource) {
            return null;
        }
        if (defaultLifecycleMappingMetadataSource == null) {
            Bundle bundle = Platform.getBundle((String)DEFAULT_LIFECYCLE_METADATA_BUNDLE);
            defaultLifecycleMappingMetadataSource = LifecycleMappingFactory.getMetadataSource(bundle);
        }
        return defaultLifecycleMappingMetadataSource;
    }

    public static void setDefaultLifecycleMappingMetadataSource(LifecycleMappingMetadataSource defaultLifecycleMappingMetadataSource) {
        LifecycleMappingFactory.defaultLifecycleMappingMetadataSource = defaultLifecycleMappingMetadataSource;
        useDefaultLifecycleMappingMetadataSource = true;
    }

    public static void setUseDefaultLifecycleMappingMetadataSource(boolean use) {
        useDefaultLifecycleMappingMetadataSource = use;
        if (!use) {
            defaultLifecycleMappingMetadataSource = null;
        }
    }

    private static LifecycleMappingMetadataSource getLifecycleMappingMetadataSource(String groupId, String artifactId, String version, List<ArtifactRepository> repositories, IProgressMonitor monitor) {
        IMaven maven = MavenPlugin.getMaven();
        try {
            Artifact artifact = maven.resolve(groupId, artifactId, version, "xml", LIFECYCLE_MAPPING_METADATA_CLASSIFIER, repositories, monitor);
            File file = artifact.getFile();
            if (file == null || !file.exists() || !file.canRead()) {
                throw new LifecycleMappingConfigurationException("Cannot find file for artifact " + artifact);
            }
            try {
                LifecycleMappingMetadataSource metadataSource = LifecycleMappingFactory.createLifecycleMappingMetadataSource(groupId, artifactId, version, file);
                metadataSource.setSource(artifact);
                return metadataSource;
            }
            catch (IOException e) {
                throw new LifecycleMappingConfigurationException("Cannot read lifecycle mapping metadata for " + artifact, e);
            }
            catch (XmlPullParserException e) {
                throw new LifecycleMappingConfigurationException("Cannot parse lifecycle mapping metadata for " + artifact, e);
            }
            catch (RuntimeException e) {
                throw new LifecycleMappingConfigurationException("Cannot load lifecycle mapping metadata for " + artifact, e);
            }
        }
        catch (CoreException ex) {
            throw new LifecycleMappingConfigurationException(ex);
        }
    }

    private static LifecycleMappingMetadataSource createLifecycleMappingMetadataSource(String groupId, String artifactId, String version, File configuration) throws IOException, XmlPullParserException {
        FileInputStream in = new FileInputStream(configuration);
        try {
            LifecycleMappingMetadataSource lifecycleMappingMetadataSource = LifecycleMappingFactory.createLifecycleMappingMetadataSource(in);
            lifecycleMappingMetadataSource.setGroupId(groupId);
            lifecycleMappingMetadataSource.setArtifactId(artifactId);
            lifecycleMappingMetadataSource.setVersion(version);
            LifecycleMappingMetadataSource lifecycleMappingMetadataSource2 = lifecycleMappingMetadataSource;
            return lifecycleMappingMetadataSource2;
        }
        finally {
            IOUtil.close((InputStream)in);
        }
    }

    public static synchronized List<LifecycleMappingMetadataSource> getBundleMetadataSources() {
        if (bundleMetadataSources == null) {
            bundleMetadataSources = new ArrayList<LifecycleMappingMetadataSource>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint configuratorsExtensionPoint = registry.getExtensionPoint(EXTENSION_LIFECYCLE_MAPPING_METADATA_SOURCE);
            if (configuratorsExtensionPoint != null) {
                IExtension[] configuratorExtensions;
                IExtension[] iExtensionArray = configuratorExtensions = configuratorsExtensionPoint.getExtensions();
                int n = configuratorExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    RegistryContributor contributor = (RegistryContributor)extension.getContributor();
                    Bundle bundle = Platform.getBundle((String)contributor.getActualName());
                    LifecycleMappingMetadataSource source = LifecycleMappingFactory.getMetadataSource(bundle);
                    if (source != null) {
                        bundleMetadataSources.add(source);
                    }
                    ++n2;
                }
            }
        }
        return bundleMetadataSources;
    }

    private static LifecycleMappingMetadataSource getMetadataSource(Bundle bundle) {
        block8: {
            if (bundle == null) {
                return null;
            }
            URL url = bundle.getEntry(LIFECYCLE_MAPPING_METADATA_SOURCE_PATH);
            if (url != null) {
                LifecycleMappingMetadataSource lifecycleMappingMetadataSource;
                InputStream in = url.openStream();
                try {
                    lifecycleMappingMetadataSource = LifecycleMappingFactory.createLifecycleMappingMetadataSource(in);
                }
                catch (Throwable throwable) {
                    try {
                        IOUtil.close((InputStream)in);
                        throw throwable;
                    }
                    catch (IOException e) {
                        log.warn("Could not read lifecycle-mapping-metadata.xml for bundle {}", (Object)bundle.getSymbolicName(), (Object)e);
                        break block8;
                    }
                    catch (XmlPullParserException e) {
                        log.warn("Could not read lifecycle-mapping-metadata.xml for bundle {}", (Object)bundle.getSymbolicName(), (Object)e);
                    }
                }
                IOUtil.close((InputStream)in);
                return lifecycleMappingMetadataSource;
            }
        }
        return null;
    }

    private static boolean isPrimaryMapping(PluginExecutionMetadata executionMetadata) {
        String configuratorId;
        IConfigurationElement element;
        if (executionMetadata == null) {
            return false;
        }
        if (executionMetadata.getAction() == PluginExecutionAction.configurator && (element = LifecycleMappingFactory.getProjectConfiguratorExtension(configuratorId = LifecycleMappingFactory.getProjectConfiguratorId(executionMetadata))) != null) {
            return element.getAttribute(ATTR_SECONDARY_TO) == null;
        }
        return true;
    }

    private static boolean isSecondaryMapping(PluginExecutionMetadata metadata, PluginExecutionMetadata primaryMetadata) {
        if (metadata == null || primaryMetadata == null) {
            return false;
        }
        if (PluginExecutionAction.configurator != metadata.getAction() || PluginExecutionAction.configurator != primaryMetadata.getAction()) {
            return false;
        }
        if (!LifecycleMappingFactory.isPrimaryMapping(primaryMetadata)) {
            return false;
        }
        String primaryId = LifecycleMappingFactory.getProjectConfiguratorId(primaryMetadata);
        String secondaryId = LifecycleMappingFactory.getProjectConfiguratorId(metadata);
        if (primaryId == null || secondaryId == null) {
            return false;
        }
        if (secondaryId.equals(primaryId)) {
            return false;
        }
        IConfigurationElement extension = LifecycleMappingFactory.getProjectConfiguratorExtension(secondaryId);
        if (extension == null) {
            return false;
        }
        return primaryId.equals(extension.getAttribute(ATTR_SECONDARY_TO));
    }

    public static ILifecycleMapping getLifecycleMapping(IMavenProjectFacade facade) {
        ILifecycleMapping lifecycleMapping = (ILifecycleMapping)facade.getSessionProperty(MavenProjectFacade.PROP_LIFECYCLE_MAPPING);
        if (lifecycleMapping == null) {
            String lifecycleMappingId = facade.getLifecycleMappingId();
            if (lifecycleMappingId != null) {
                lifecycleMapping = LifecycleMappingFactory.getLifecycleMapping(lifecycleMappingId);
            }
            if (lifecycleMapping == null) {
                lifecycleMapping = new InvalidLifecycleMapping();
            }
            facade.setSessionProperty(MavenProjectFacade.PROP_LIFECYCLE_MAPPING, lifecycleMapping);
        }
        return lifecycleMapping;
    }

    public static Map<String, AbstractProjectConfigurator> getProjectConfigurators(IMavenProjectFacade facade) {
        Map<String, AbstractProjectConfigurator> configurators = (Map<String, AbstractProjectConfigurator>)facade.getSessionProperty(MavenProjectFacade.PROP_CONFIGURATORS);
        if (configurators == null) {
            LifecycleMappingResult result = new LifecycleMappingResult();
            LifecycleMappingFactory.instantiateProjectConfigurators(facade.getMavenProject(), result, facade.getMojoExecutionMapping());
            configurators = result.getProjectConfigurators();
            facade.setSessionProperty(MavenProjectFacade.PROP_CONFIGURATORS, configurators);
        }
        return configurators;
    }

    public static boolean isLifecycleMappingChanged(IMavenProjectFacade newFacade, ILifecycleMappingConfiguration oldConfiguration, IProgressMonitor monitor) {
        if (oldConfiguration == null || newFacade == null) {
            return false;
        }
        String lifecycleMappingId = newFacade.getLifecycleMappingId();
        if (lifecycleMappingId == null || newFacade.getMojoExecutionMapping() == null) {
            return false;
        }
        if (!LifecycleMappingFactory.eq(lifecycleMappingId, oldConfiguration.getLifecycleMappingId())) {
            return true;
        }
        AbstractLifecycleMapping lifecycleMapping = LifecycleMappingFactory.getLifecycleMapping(lifecycleMappingId);
        if (lifecycleMapping == null) {
            return false;
        }
        return lifecycleMapping.hasLifecycleMappingChanged(newFacade, oldConfiguration, monitor);
    }

    private static <T> boolean eq(T a, T b) {
        return a != null ? a.equals(b) : b == null;
    }

    public static boolean isInterestingPhase(String phase) {
        String[] stringArray = INTERESTING_PHASES;
        int n = INTERESTING_PHASES.length;
        int n2 = 0;
        while (n2 < n) {
            String interestingPhase = stringArray[n2];
            if (interestingPhase.equals(phase)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static synchronized void setBundleMetadataSources(List<LifecycleMappingMetadataSource> bundleMetadataSources) {
        LifecycleMappingFactory.bundleMetadataSources = bundleMetadataSources;
    }
}

