/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.builder;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.internal.M2EUtils;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.builder.DeltaProvider;
import org.eclipse.m2e.core.internal.builder.MavenBuilderImpl;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.ILifecycleMapping;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenBuilder
extends IncrementalProjectBuilder
implements DeltaProvider {
    private static Logger log = LoggerFactory.getLogger(MavenBuilder.class);
    private MavenBuilderImpl builder = new MavenBuilderImpl(this);

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        log.debug("Building project {}", (Object)project.getName());
        long start = System.currentTimeMillis();
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
        IMavenConfiguration mavenConfiguration = MavenPlugin.getMavenConfiguration();
        IMavenMarkerManager markerManager = MavenPluginActivator.getDefault().getMavenMarkerManager();
        markerManager.deleteMarkers((IResource)project, kind == 6, "org.eclipse.m2e.core.maven2Problem.build");
        if (!project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
            return null;
        }
        IFile pomResource = project.getFile("pom.xml");
        if (pomResource == null) {
            log.error("Project {} does not have pom.xml", (Object)project.getName());
            return null;
        }
        IResourceDelta delta = this.getDelta(project);
        IMavenProjectFacade projectFacade = projectManager.create(this.getProject(), monitor);
        if (delta == null || projectFacade == null || projectFacade.isStale()) {
            MavenUpdateRequest updateRequest = new MavenUpdateRequest(project, mavenConfiguration.isOffline(), false);
            projectManager.refresh(updateRequest, monitor);
            projectFacade = projectManager.create(project, monitor);
            if (projectFacade == null) {
                return null;
            }
        }
        MavenProject mavenProject = null;
        try {
            mavenProject = projectFacade.getMavenProject(monitor);
        }
        catch (CoreException ce) {
            this.addErrorMarker(project, (Exception)((Object)ce));
            monitor.done();
            return null;
        }
        ILifecycleMapping lifecycleMapping = configurationManager.getLifecycleMapping(projectFacade);
        if (lifecycleMapping == null) {
            return null;
        }
        Map<MojoExecutionKey, List<AbstractBuildParticipant>> buildParticipantsByMojoExecutionKey = lifecycleMapping.getBuildParticipants(projectFacade, monitor);
        IMaven maven = MavenPlugin.getMaven();
        MavenExecutionRequest request = projectManager.createExecutionRequest(pomResource, projectFacade.getResolverConfiguration(), monitor);
        MavenSession session = maven.createSession(request, mavenProject);
        Set<IProject> dependencies = this.builder.build(session, projectFacade, kind, args, buildParticipantsByMojoExecutionKey, monitor);
        log.debug("Built project {} in {} ms", (Object)project.getName(), (Object)(System.currentTimeMillis() - start));
        if (dependencies.isEmpty()) {
            return null;
        }
        return dependencies.toArray(new IProject[dependencies.size()]);
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
        IProject project = this.getProject();
        IMavenMarkerManager markerManager = MavenPluginActivator.getDefault().getMavenMarkerManager();
        markerManager.deleteMarkers((IResource)project, "org.eclipse.m2e.core.maven2Problem.build");
        if (!project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
            return;
        }
        IFile pomResource = project.getFile("pom.xml");
        if (pomResource == null) {
            return;
        }
        IMavenProjectFacade projectFacade = projectManager.create(this.getProject(), monitor);
        if (projectFacade == null) {
            return;
        }
        if (projectFacade.getMavenProject(monitor) == null) {
            return;
        }
        ILifecycleMapping lifecycleMapping = configurationManager.getLifecycleMapping(projectFacade);
        if (lifecycleMapping == null) {
            return;
        }
        Map<MojoExecutionKey, List<AbstractBuildParticipant>> buildParticipantsByMojoExecutionKey = lifecycleMapping.getBuildParticipants(projectFacade, monitor);
        MavenProject mavenProject = null;
        try {
            mavenProject = projectFacade.getMavenProject(monitor);
        }
        catch (CoreException ce) {
            this.addErrorMarker(project, (Exception)((Object)ce));
            return;
        }
        IMaven maven = MavenPlugin.getMaven();
        MavenExecutionRequest request = projectManager.createExecutionRequest(pomResource, projectFacade.getResolverConfiguration(), monitor);
        MavenSession session = maven.createSession(request, mavenProject);
        this.builder.clean(session, projectFacade, buildParticipantsByMojoExecutionKey, monitor);
    }

    private void addErrorMarker(IProject project, Exception e) {
        String msg = e.getMessage();
        String rootCause = M2EUtils.getRootCauseMessage(e);
        if (!e.equals(msg)) {
            msg = String.valueOf(msg) + ": " + rootCause;
        }
        IMavenMarkerManager markerManager = MavenPluginActivator.getDefault().getMavenMarkerManager();
        markerManager.addMarker((IResource)project, "org.eclipse.m2e.core.maven2Problem.build", msg, 1, 2);
    }
}

