/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.archetype;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.archetype.ArchetypeCatalogFactory;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLFilterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchetypeCatalogsWriter {
    private static final Logger log = LoggerFactory.getLogger(ArchetypeCatalogsWriter.class);
    private static final String ELEMENT_CATALOGS = "archetypeCatalogs";
    private static final String ELEMENT_CATALOG = "catalog";
    private static final String ATT_CATALOG_TYPE = "type";
    private static final String ATT_CATALOG_LOCATION = "location";
    public static final String ATT_CATALOG_DESCRIPTION = "description";
    private static final String TYPE_LOCAL = "local";
    private static final String TYPE_REMOTE = "remote";

    public Collection<ArchetypeCatalogFactory> readArchetypeCatalogs(InputStream is) throws IOException {
        ArrayList<ArchetypeCatalogFactory> catalogs = new ArrayList<ArchetypeCatalogFactory>();
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            SAXParser parser = parserFactory.newSAXParser();
            parser.parse(is, (DefaultHandler)new ArchetypeCatalogsContentHandler(catalogs));
        }
        catch (SAXException ex) {
            String msg = Messages.ArchetypeCatalogsWriter_error_parse;
            log.error(msg, (Throwable)ex);
            throw new IOException(NLS.bind((String)msg, (Object)ex.getMessage()));
        }
        catch (ParserConfigurationException ex) {
            String msg = Messages.ArchetypeCatalogsWriter_error_parse;
            log.error(msg, (Throwable)ex);
            throw new IOException(NLS.bind((String)msg, (Object)ex.getMessage()));
        }
        return catalogs;
    }

    public void writeArchetypeCatalogs(Collection<ArchetypeCatalogFactory> catalogs, OutputStream os) throws IOException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new SAXSource(new XMLArchetypeCatalogsWriter(catalogs), new InputSource()), new StreamResult(os));
        }
        catch (TransformerFactoryConfigurationError ex) {
            throw new IOException(NLS.bind((String)Messages.ArchetypeCatalogsWriter_error_write, (Object)ex.getMessage()));
        }
        catch (TransformerException ex) {
            throw new IOException(NLS.bind((String)Messages.ArchetypeCatalogsWriter_error_write, (Object)ex.getMessage()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ArchetypeCatalogsContentHandler
    extends DefaultHandler {
        private Collection<ArchetypeCatalogFactory> catalogs;

        public ArchetypeCatalogsContentHandler(Collection<ArchetypeCatalogFactory> catalogs) {
            this.catalogs = catalogs;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (ArchetypeCatalogsWriter.ELEMENT_CATALOG.equals(qName) && attributes != null) {
                String url;
                String type = attributes.getValue(ArchetypeCatalogsWriter.ATT_CATALOG_TYPE);
                if (ArchetypeCatalogsWriter.TYPE_LOCAL.equals(type)) {
                    String path = attributes.getValue(ArchetypeCatalogsWriter.ATT_CATALOG_LOCATION);
                    if (path != null) {
                        String description = attributes.getValue(ArchetypeCatalogsWriter.ATT_CATALOG_DESCRIPTION);
                        this.catalogs.add(new ArchetypeCatalogFactory.LocalCatalogFactory(path, description, true));
                    }
                } else if (ArchetypeCatalogsWriter.TYPE_REMOTE.equals(type) && (url = attributes.getValue(ArchetypeCatalogsWriter.ATT_CATALOG_LOCATION)) != null) {
                    String description = attributes.getValue(ArchetypeCatalogsWriter.ATT_CATALOG_DESCRIPTION);
                    this.catalogs.add(new ArchetypeCatalogFactory.RemoteCatalogFactory(url, description, true));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class XMLArchetypeCatalogsWriter
    extends XMLFilterImpl {
        private final Collection<ArchetypeCatalogFactory> catalogs;

        public XMLArchetypeCatalogsWriter(Collection<ArchetypeCatalogFactory> catalogs) {
            this.catalogs = catalogs;
        }

        @Override
        public void parse(InputSource input) throws SAXException {
            ContentHandler handler = this.getContentHandler();
            handler.startDocument();
            handler.startElement(null, ArchetypeCatalogsWriter.ELEMENT_CATALOGS, ArchetypeCatalogsWriter.ELEMENT_CATALOGS, new AttributesImpl());
            for (ArchetypeCatalogFactory factory : this.catalogs) {
                AttributesImpl attrs;
                if (!factory.isEditable()) continue;
                if (factory instanceof ArchetypeCatalogFactory.LocalCatalogFactory) {
                    attrs = new AttributesImpl();
                    attrs.addAttribute(null, ArchetypeCatalogsWriter.ATT_CATALOG_TYPE, ArchetypeCatalogsWriter.ATT_CATALOG_TYPE, null, ArchetypeCatalogsWriter.TYPE_LOCAL);
                    attrs.addAttribute(null, ArchetypeCatalogsWriter.ATT_CATALOG_LOCATION, ArchetypeCatalogsWriter.ATT_CATALOG_LOCATION, null, factory.getId());
                    attrs.addAttribute(null, ArchetypeCatalogsWriter.ATT_CATALOG_DESCRIPTION, ArchetypeCatalogsWriter.ATT_CATALOG_DESCRIPTION, null, factory.getDescription());
                    handler.startElement(null, ArchetypeCatalogsWriter.ELEMENT_CATALOG, ArchetypeCatalogsWriter.ELEMENT_CATALOG, attrs);
                    handler.endElement(null, ArchetypeCatalogsWriter.ELEMENT_CATALOG, ArchetypeCatalogsWriter.ELEMENT_CATALOG);
                    continue;
                }
                if (!(factory instanceof ArchetypeCatalogFactory.RemoteCatalogFactory)) continue;
                attrs = new AttributesImpl();
                attrs.addAttribute(null, ArchetypeCatalogsWriter.ATT_CATALOG_TYPE, ArchetypeCatalogsWriter.ATT_CATALOG_TYPE, null, ArchetypeCatalogsWriter.TYPE_REMOTE);
                attrs.addAttribute(null, ArchetypeCatalogsWriter.ATT_CATALOG_LOCATION, ArchetypeCatalogsWriter.ATT_CATALOG_LOCATION, null, factory.getId());
                attrs.addAttribute(null, ArchetypeCatalogsWriter.ATT_CATALOG_DESCRIPTION, ArchetypeCatalogsWriter.ATT_CATALOG_DESCRIPTION, null, factory.getDescription());
                handler.startElement(null, ArchetypeCatalogsWriter.ELEMENT_CATALOG, ArchetypeCatalogsWriter.ELEMENT_CATALOG, attrs);
                handler.endElement(null, ArchetypeCatalogsWriter.ELEMENT_CATALOG, ArchetypeCatalogsWriter.ELEMENT_CATALOG);
            }
            handler.endElement(null, ArchetypeCatalogsWriter.ELEMENT_CATALOGS, ArchetypeCatalogsWriter.ELEMENT_CATALOGS);
            handler.endDocument();
        }
    }
}

